/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.additions.soaphttp;

import com.sap.engine.interfaces.webservices.runtime.Config;
import com.sap.engine.interfaces.webservices.runtime.Fault;
import com.sap.engine.interfaces.webservices.runtime.JavaToQNameMappingRegistry;
import com.sap.engine.interfaces.webservices.runtime.Key;
import com.sap.engine.interfaces.webservices.runtime.OperationDefinition;
import com.sap.engine.interfaces.webservices.runtime.PropertyDescriptor;
import com.sap.engine.interfaces.webservices.runtime.RawMessage;
import com.sap.engine.interfaces.webservices.runtime.RuntimeContext;
import com.sap.engine.interfaces.webservices.runtime.Transport;
import com.sap.engine.interfaces.webservices.runtime.TransportBindingException;
import com.sap.engine.interfaces.webservices.runtime.soaphttp.HTTPTransport;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriter;
import com.sap.engine.services.webservices.additions.soaphttp.AbstractSOAPTransportBinding;
import com.sap.engine.services.webservices.additions.soaphttp.DOMEngine;
import com.sap.engine.services.webservices.additions.soaphttp.InternalSOAPMessage;
import com.sap.engine.services.webservices.additions.soaphttp.StreamEngine;
import com.sap.engine.services.webservices.additions.soaphttp.exceptions.ConfigurationException;
import com.sap.engine.services.webservices.additions.soaphttp.exceptions.ProcessException;
import com.sap.engine.services.webservices.additions.soaphttp.exceptions.TBindingResourceAccessor;
import com.sap.engine.services.webservices.runtime.InstancesPool;
import com.sap.engine.services.webservices.tools.ReferenceByteArrayOutputStream;
import com.sap.localization.ResourceAccessor;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPHTTPTransportBinding
extends AbstractSOAPTransportBinding {
    private static final String BODYTAG = "Body";
    private static final String STYLE = "style";
    static final String DOCUMENT = "document";
    static final String RPC = "rpc";
    private static final String RPC_ENC = "rpc_enc";
    private static final String TEXT_XML = "text/xml";
    static final String SOAP_REQUEST_WRAPPER = "SoapRequestWrapper";
    static final String SOAP_RESPONSE_WRAPPER = "SoapResponseWrapper";
    private HTTPTransport transport;
    private InternalSOAPMessage message;
    private OperationDefinition virtualOperation;
    private TypeMappingRegistry typeMappingRegistry;
    private JavaToQNameMappingRegistry javaToSchemaRegistry;
    private RuntimeContext runtimeContext;
    private String style;
    private boolean isClientFault = false;
    private static InstancesPool messages = new InstancesPool();
    static /* synthetic */ Class class$com$sap$engine$interfaces$webservices$runtime$soaphttp$HTTPTransport;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$additions$soaphttp$InternalSOAPMessage;

    public Key[] getMessageKeys() throws TransportBindingException {
        if (!this.message.isDOMbuilt()) {
            return this.getMessageKeysFromReader();
        }
        Key[] keys = new Key[2];
        Element elImpl = this.message.getSoapBody();
        Node first = elImpl.getFirstChild();
        while (first != null) {
            if (first.getNodeType() == 1) break;
            first = first.getNextSibling();
        }
        if (first != null) {
            keys[0] = new Key("first-body-element-ns", first.getNamespaceURI());
            keys[1] = this.style.equals(DOCUMENT) ? new Key(SOAP_REQUEST_WRAPPER, first.getLocalName()) : new Key("first-body-element-name", first.getLocalName());
        } else {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2109");
        }
        return keys;
    }

    public void setTransport(Transport transport) throws TransportBindingException {
        if (!(transport instanceof HTTPTransport)) {
            throw new ConfigurationException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2112", new Object[]{transport, (class$com$sap$engine$interfaces$webservices$runtime$soaphttp$HTTPTransport == null ? (class$com$sap$engine$interfaces$webservices$runtime$soaphttp$HTTPTransport = SOAPHTTPTransportBinding.class$("com.sap.engine.interfaces.webservices.runtime.soaphttp.HTTPTransport")) : class$com$sap$engine$interfaces$webservices$runtime$soaphttp$HTTPTransport).getName()});
        }
        this.transport = (HTTPTransport)transport;
        HttpServletRequest request = this.transport.getRequest();
        if (!request.getMethod().equalsIgnoreCase("POST")) {
            ProcessException prE = new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2168", new Object[]{"POST", request.getMethod()});
            prE.setResponseErrorCode(405);
            throw prE;
        }
        String contentType = request.getContentType();
        if (contentType == null || !contentType.trim().startsWith(TEXT_XML)) {
            ProcessException prE = new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2167", new Object[]{TEXT_XML, request.getContentType()});
            prE.setResponseErrorCode(415);
            throw prE;
        }
        this.style = request.getParameter(STYLE);
        if (this.style == null || !this.style.equals(DOCUMENT) && !this.style.equals(RPC) && !this.style.equals(RPC_ENC)) {
            ProcessException prE = new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2110", new Object[]{this.style});
            prE.setResponseErrorCode(400);
            throw prE;
        }
        Object inputStream = null;
        try {
            inputStream = request.getInputStream();
        }
        catch (IOException ioE) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2111", new Object[]{"inputStream", ioE.getLocalizedMessage()}, ioE);
        }
        Location location = this.runtimeContext.getLogLocation();
        if (location != null && location.beLogged(100)) {
            inputStream = this.logRequest(location, (InputStream)inputStream, request.getContextPath());
        }
        this.message = this.getInternalSOAPMessage();
        this.message.initDeserializationMode((InputStream)inputStream);
    }

    public Transport getTransport() {
        return this.transport;
    }

    public RawMessage getRawMessage() throws TransportBindingException {
        return this.message;
    }

    public void setRawMessage(RawMessage message) throws TransportBindingException {
        try {
            this.message = (InternalSOAPMessage)message;
        }
        catch (ClassCastException cstE) {
            throw new ConfigurationException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2112", new Object[]{message, (class$com$sap$engine$services$webservices$additions$soaphttp$InternalSOAPMessage == null ? (class$com$sap$engine$services$webservices$additions$soaphttp$InternalSOAPMessage = SOAPHTTPTransportBinding.class$("com.sap.engine.services.webservices.additions.soaphttp.InternalSOAPMessage")) : class$com$sap$engine$services$webservices$additions$soaphttp$InternalSOAPMessage).getName()});
        }
    }

    public Properties getSupportedFeatures() {
        return null;
    }

    public void setMappingRegistries(JavaToQNameMappingRegistry nameMapping, TypeMappingRegistry typeMappingRegistry) throws ConfigurationException {
        if (nameMapping == null || typeMappingRegistry == null) {
            throw new ConfigurationException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2113", new Object[]{nameMapping, typeMappingRegistry});
        }
        this.javaToSchemaRegistry = nameMapping;
        this.typeMappingRegistry = typeMappingRegistry;
    }

    public void setGlobalConfiguration(Config config) throws TransportBindingException {
    }

    public void setRuntimeContext(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }

    public void setVirtualOperation(OperationDefinition operation) throws TransportBindingException {
        this.virtualOperation = operation;
    }

    public Object[] getParameters(Class[] methodParameters, ClassLoader loader) throws TransportBindingException {
        if (this.message.isDOMbuilt()) {
            if (this.style.equals(RPC) || this.style.equals(DOCUMENT)) {
                return DOMEngine.deserializeLiteral(this.message, this.virtualOperation, methodParameters, this.typeMappingRegistry, this.javaToSchemaRegistry, loader);
            }
            return DOMEngine.deserializeEncoded(this.message, this.virtualOperation, methodParameters, this.typeMappingRegistry, this.javaToSchemaRegistry, loader);
        }
        if (this.style.equals(RPC) || this.style.equals(DOCUMENT)) {
            return StreamEngine.deserializeLiteral(this.message, this.virtualOperation, methodParameters, this.typeMappingRegistry, this.javaToSchemaRegistry, loader);
        }
        return StreamEngine.deserializeEncoded(this.message, this.virtualOperation, methodParameters, this.typeMappingRegistry, this.javaToSchemaRegistry, loader);
    }

    public Key[] getOperationKeys(OperationDefinition virtualOperation) throws TransportBindingException {
        Config cfg = virtualOperation.getInputConfiguration();
        PropertyDescriptor soapActionDescr = cfg.getProperty("soapAction");
        String firstElName = virtualOperation.getOperationName();
        PropertyDescriptor namespaceDescr = cfg.getProperty("namespace");
        if (namespaceDescr == null || namespaceDescr.getValue() == null) {
            throw new ConfigurationException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2101", new Object[]{firstElName, "namespace", "input"});
        }
        String namespace = namespaceDescr.getValue();
        Key[] keys = new Key[]{new Key("first-body-element-name", firstElName), new Key("first-body-element-ns", namespace)};
        cfg = virtualOperation.getGeneralConfiguration();
        String soapRequest = null;
        if (cfg != null) {
            String string = soapRequest = cfg.getProperty(SOAP_REQUEST_WRAPPER) != null ? cfg.getProperty(SOAP_REQUEST_WRAPPER).getValue() : null;
        }
        if (soapRequest == null) {
            soapRequest = firstElName;
        }
        Key[] newKeys = new Key[keys.length + 1];
        System.arraycopy(keys, 0, newKeys, 0, keys.length);
        newKeys[keys.length] = new Key(SOAP_REQUEST_WRAPPER, soapRequest);
        keys = newKeys;
        return keys;
    }

    public void clearState() {
        this.transport = null;
        this.message = null;
        this.virtualOperation = null;
        this.typeMappingRegistry = null;
        this.javaToSchemaRegistry = null;
    }

    public RawMessage createResponseMessage(Object returnObject, Class returnObjectClass, Object[] resultParams, Class[] resultParamsClasses) throws TransportBindingException {
        XMLTokenWriter writer = this.message.initSerializationMode();
        try {
            writer.enter("http://schemas.xmlsoap.org/soap/envelope/", BODYTAG);
            if (this.style.equals(RPC) || this.style.equals(DOCUMENT)) {
                StreamEngine.serializeLiteral(writer, returnObject, returnObjectClass, this.virtualOperation, this.typeMappingRegistry, this.javaToSchemaRegistry, this.style);
            } else {
                StreamEngine.serializeEncoded(writer, returnObject, returnObjectClass, this.virtualOperation, this.typeMappingRegistry, this.javaToSchemaRegistry);
            }
            writer.leave();
            writer.flush();
        }
        catch (IOException ioE) {
            throw new ProcessException(ioE);
        }
        return this.message;
    }

    public RawMessage createFaultMessage(Throwable thr) throws TransportBindingException {
        Fault[] faults = null;
        String operationName = null;
        if (this.virtualOperation != null) {
            faults = this.virtualOperation.getFaults();
            operationName = this.virtualOperation.getOperationName();
        }
        this.isClientFault = true;
        XMLTokenWriter writer = this.message.initSerializationMode();
        if (faults != null && faults.length > 0) {
            int i = 0;
            while (i < faults.length) {
                if (faults[i].getJavaClassName().equalsIgnoreCase(thr.getClass().getName())) break;
                ++i;
            }
            if (i < faults.length) {
                try {
                    writer.enter("http://schemas.xmlsoap.org/soap/envelope/", BODYTAG);
                    if (this.style != null && this.style.equals(RPC_ENC)) {
                        StreamEngine.serializeThrowableEncoded(writer, thr, "Client", faults[i], operationName, this.javaToSchemaRegistry, this.typeMappingRegistry);
                    } else {
                        StreamEngine.serializeThrowableLiteral(writer, thr, "Client", faults[i], operationName, this.javaToSchemaRegistry, this.typeMappingRegistry);
                    }
                    writer.leave();
                    writer.flush();
                }
                catch (IOException ioE) {
                    throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2125", new Object[]{ioE.getLocalizedMessage()}, ioE);
                }
                return this.message;
            }
        }
        try {
            writer.enter("http://schemas.xmlsoap.org/soap/envelope/", BODYTAG);
            StreamEngine.serializeThrowableLiteral(writer, thr, "Client", null, null, null, null);
            writer.leave();
            writer.flush();
        }
        catch (IOException ioE) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2125", new Object[]{ioE.getLocalizedMessage()}, ioE);
        }
        return this.message;
    }

    public void sendResponse() throws TransportBindingException {
        if (this.isClientFault) {
            this.sendMessage(500);
        } else {
            this.sendMessage(200);
        }
    }

    public void sendServerError(Throwable thr) throws TransportBindingException {
        try {
            if (thr instanceof ProcessException) {
                ProcessException prE = (ProcessException)((Object)thr);
                if (prE.getResponseErrorCode() != 0) {
                    this.transport.getResponse().sendError(prE.getResponseErrorCode(), prE.getLocalizedMessage());
                    return;
                }
                if (prE.getCause() instanceof ParserException) {
                    this.transport.getResponse().sendError(400, prE.getCause().toString());
                    return;
                }
            }
        }
        catch (IOException ioE) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2125", new Object[]{ioE.getLocalizedMessage()}, ioE);
        }
        if (this.message == null) {
            this.message = this.getInternalSOAPMessage();
        }
        XMLTokenWriter writer = this.message.initSerializationMode();
        try {
            writer.enter("http://schemas.xmlsoap.org/soap/envelope/", BODYTAG);
            StreamEngine.serializeThrowableLiteral(writer, thr, "Server", null, null, null, null);
            writer.leave();
        }
        catch (IOException ioE) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2125", new Object[]{ioE.getLocalizedMessage()}, ioE);
        }
        this.sendMessage(500);
    }

    public String getLiteralRequestTemplate(OperationDefinition operation, TypeMappingRegistry typeMapping, JavaToQNameMappingRegistry javaToQNameMappingRegistry) throws ProcessException {
        return this.getRequestTemplate(operation, typeMapping, javaToQNameMappingRegistry, "literal");
    }

    public String getEncodedRequestTemplate(OperationDefinition operation, TypeMappingRegistry typeMapping, JavaToQNameMappingRegistry javaToQNameMappingRegistry) throws ProcessException {
        return this.getRequestTemplate(operation, typeMapping, javaToQNameMappingRegistry, "encoded");
    }

    private String getRequestTemplate(OperationDefinition operationDefinition, TypeMappingRegistry typeMapping, JavaToQNameMappingRegistry javaToQNameMappingRegistry, String use) throws ProcessException {
        InternalSOAPMessage soapMessage = this.getInternalSOAPMessage();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        XMLTokenWriter writer = soapMessage.initSerializationMode();
        try {
            try {
                StreamEngine.buildSampleRequest(writer, operationDefinition, typeMapping, javaToQNameMappingRegistry, use);
                soapMessage.writeMessage(buffer);
            }
            catch (IOException ioE) {
                throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2116", new Object[]{ioE.getLocalizedMessage()}, ioE);
            }
            Object var10_8 = null;
            soapMessage.clearState();
            messages.rollBackInstance(soapMessage);
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            soapMessage.clearState();
            messages.rollBackInstance(soapMessage);
            throw throwable;
        }
        return buffer.toString();
    }

    private Key[] getMessageKeysFromReader() throws TransportBindingException {
        Key[] keys = new Key[2];
        XMLTokenReader reader = this.message.getReader();
        if (reader.getState() == 1 && reader.getLocalNameCharArray().equals((Object)BODYTAG)) {
            try {
                reader.moveToNextElementStart();
            }
            catch (ParserException pE) {
                throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2114", new Object[]{pE.getLocalizedMessage()}, pE);
            }
        }
        if (reader.getState() != 1) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2115");
        }
        String localName = reader.getLocalName();
        String uri = reader.getURI();
        keys[0] = new Key("first-body-element-ns", uri);
        keys[1] = this.style.equals(DOCUMENT) ? new Key(SOAP_REQUEST_WRAPPER, localName) : new Key("first-body-element-name", localName);
        this.message.setBodyWrapperData(reader);
        return keys;
    }

    private Key[] appendSAIfAvailable(Key[] keys, String soapActionValue) {
        if (soapActionValue != null && soapActionValue.length() > 0 && !soapActionValue.equals("\"\"")) {
            if (soapActionValue.charAt(0) == '\"' && soapActionValue.charAt(soapActionValue.length() - 1) == '\"') {
                soapActionValue = soapActionValue.substring(1, soapActionValue.length() - 1);
            }
            Key[] temp = new Key[]{keys[0], keys[1], new Key("soapAction", soapActionValue)};
            return temp;
        }
        return keys;
    }

    private void sendMessage(int responseCode) throws TransportBindingException {
        try {
            block6: {
                try {
                    Location location = this.runtimeContext.getLogLocation();
                    ByteArrayOutputStream buf = null;
                    if (location != null && location.beLogged(100)) {
                        buf = this.logResponse(location, this.message);
                    }
                    ServletOutputStream output = null;
                    HttpServletResponse response = this.transport.getResponse();
                    response.setStatus(responseCode);
                    response.setContentType("text/xml; charset=UTF-8");
                    output = response.getOutputStream();
                    if (buf != null) {
                        buf.writeTo((OutputStream)output);
                        break block6;
                    }
                    this.message.writeMessage((OutputStream)output);
                }
                catch (IOException ioE) {
                    throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2116", new Object[]{ioE.getLocalizedMessage()}, ioE);
                }
            }
            Object var7_7 = null;
            this.message.clearState();
            messages.rollBackInstance(this.message);
            this.message = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.message.clearState();
            messages.rollBackInstance(this.message);
            this.message = null;
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private InputStream logRequest(Location location, InputStream inputStream, String httpContext) throws ProcessException {
        ReferenceByteArrayOutputStream messBuf = new ReferenceByteArrayOutputStream();
        try {
            int b;
            byte[] rBuf = new byte[128];
            while ((b = inputStream.read(rBuf)) != -1) {
                void var5_6;
                messBuf.write(rBuf, 0, (int)var5_6);
            }
        }
        catch (IOException ioE) {
            throw new ProcessException(ioE);
        }
        location.logT(100, "Requested context: [" + httpContext + "] message: \r\n" + messBuf.toString());
        return new ByteArrayInputStream(messBuf.getContentReference(), 0, messBuf.size());
    }

    private InternalSOAPMessage getInternalSOAPMessage() {
        InternalSOAPMessage message = (InternalSOAPMessage)messages.getInstance();
        if (message == null) {
            return new InternalSOAPMessage();
        }
        return message;
    }

    private ByteArrayOutputStream logResponse(Location location, InternalSOAPMessage message) throws ProcessException {
        ReferenceByteArrayOutputStream messBuf = new ReferenceByteArrayOutputStream();
        try {
            message.writeMessage((OutputStream)messBuf);
        }
        catch (IOException ioE) {
            throw new ProcessException(ioE);
        }
        String httpContext = this.transport.getRequest().getContextPath();
        location.logT(100, "Response context: [" + httpContext + "] message: \r\n" + messBuf.toString());
        return messBuf;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

