/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.additions.soaphttp;

import com.sap.engine.interfaces.webservices.runtime.Config;
import com.sap.engine.interfaces.webservices.runtime.Fault;
import com.sap.engine.interfaces.webservices.runtime.JavaToQNameMappingRegistry;
import com.sap.engine.interfaces.webservices.runtime.Key;
import com.sap.engine.interfaces.webservices.runtime.OperationDefinition;
import com.sap.engine.interfaces.webservices.runtime.PropertyDescriptor;
import com.sap.engine.interfaces.webservices.runtime.RawMessage;
import com.sap.engine.interfaces.webservices.runtime.RuntimeContext;
import com.sap.engine.interfaces.webservices.runtime.Transport;
import com.sap.engine.interfaces.webservices.runtime.TransportBindingException;
import com.sap.engine.interfaces.webservices.runtime.soaphttp.HTTPTransport;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriter;
import com.sap.engine.services.webservices.additions.soaphttp.AbstractMIMETransportBinding;
import com.sap.engine.services.webservices.additions.soaphttp.InternalMIMEMessage;
import com.sap.engine.services.webservices.additions.soaphttp.InternalSOAPMessage;
import com.sap.engine.services.webservices.additions.soaphttp.SOAPHTTPConfigProperties;
import com.sap.engine.services.webservices.additions.soaphttp.StreamEngine;
import com.sap.engine.services.webservices.additions.soaphttp.StreamEngineMIME;
import com.sap.engine.services.webservices.additions.soaphttp.exceptions.ConfigurationException;
import com.sap.engine.services.webservices.additions.soaphttp.exceptions.ProcessException;
import com.sap.engine.services.webservices.additions.soaphttp.exceptions.TBindingResourceAccessor;
import com.sap.engine.services.webservices.exceptions.WSLogging;
import com.sap.engine.services.webservices.runtime.InstancesPool;
import com.sap.engine.services.webservices.tools.ReferenceByteArrayOutputStream;
import com.sap.localization.ResourceAccessor;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParameterList;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MIMEHTTPTransportBinding
extends AbstractMIMETransportBinding
implements SOAPHTTPConfigProperties {
    private static final String STYLE = "style";
    private static final String MIME_STYLE = "mime";
    private static final String BODYTAG = "Body";
    private OperationDefinition operation;
    private RuntimeContext runtimeContext;
    private HTTPTransport transport;
    private Config globalConfig;
    private JavaToQNameMappingRegistry javaToQNameMappingsRegistry;
    private TypeMappingRegistry typeMappingRegistry;
    private InternalMIMEMessage mimeMessage;
    private String style;
    private static InstancesPool messages = new InstancesPool();
    static /* synthetic */ Class class$com$sap$engine$services$webservices$additions$soaphttp$InternalMIMEMessage;
    static /* synthetic */ Class class$com$sap$engine$interfaces$webservices$runtime$soaphttp$HTTPTransport;

    public Transport getTransport() throws TransportBindingException {
        return this.transport;
    }

    public RawMessage getRawMessage() throws TransportBindingException {
        return null;
    }

    public void setMappingRegistries(JavaToQNameMappingRegistry nameMapping, TypeMappingRegistry registry) throws TransportBindingException {
        if (nameMapping == null || registry == null) {
            throw new ConfigurationException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2113", new Object[]{nameMapping, this.typeMappingRegistry});
        }
        this.javaToQNameMappingsRegistry = nameMapping;
        this.typeMappingRegistry = registry;
    }

    public Key[] getMessageKeys() throws TransportBindingException {
        Key[] keys = new Key[2];
        InternalSOAPMessage iSOAPMessage = this.mimeMessage.getSOAPMessage();
        if (!iSOAPMessage.isDOMbuilt()) {
            return this.getMessageKeysFromReader();
        }
        Element elImpl = null;
        elImpl = iSOAPMessage.getSoapBody();
        Node first = elImpl.getFirstChild();
        while (first != null) {
            if (first.getNodeType() == 1) break;
            first = first.getNextSibling();
        }
        if (first == null) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2109");
        }
        keys[0] = new Key("first-body-element-name", first.getNodeName());
        keys[1] = new Key("first-body-element-ns", first.getNamespaceURI());
        return keys;
    }

    private Key[] getMessageKeysFromReader() throws TransportBindingException {
        Key[] keys = new Key[2];
        InternalSOAPMessage iSMessage = this.mimeMessage.getSOAPMessage();
        XMLTokenReader reader = iSMessage.getReader();
        try {
            reader.moveToNextElementStart();
        }
        catch (ParserException pE) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2114", new Object[]{pE.getLocalizedMessage()}, pE);
        }
        if (reader.getState() != 1) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2115");
        }
        String localName = reader.getLocalName();
        String uri = reader.getURI();
        keys[0] = new Key("first-body-element-name", localName);
        keys[1] = new Key("first-body-element-ns", uri);
        iSMessage.setBodyWrapperData(reader);
        return keys;
    }

    private Key[] appendSAIfAvailable(Key[] keys, String soapActionValue) {
        if (soapActionValue != null && soapActionValue.length() > 0 && !soapActionValue.equals("\"\"")) {
            if (soapActionValue.charAt(0) == '\"' && soapActionValue.charAt(soapActionValue.length() - 1) == '\"') {
                soapActionValue = soapActionValue.substring(1, soapActionValue.length() - 1);
            }
            Key[] temp = new Key[]{keys[0], keys[1], new Key("soapAction", soapActionValue)};
            return temp;
        }
        return keys;
    }

    public void setRawMessage(RawMessage message) throws TransportBindingException {
        try {
            this.mimeMessage = (InternalMIMEMessage)message;
        }
        catch (ClassCastException e) {
            throw new ConfigurationException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2112", new Object[]{message, (class$com$sap$engine$services$webservices$additions$soaphttp$InternalMIMEMessage == null ? (class$com$sap$engine$services$webservices$additions$soaphttp$InternalMIMEMessage = MIMEHTTPTransportBinding.class$("com.sap.engine.services.webservices.additions.soaphttp.InternalMIMEMessage")) : class$com$sap$engine$services$webservices$additions$soaphttp$InternalMIMEMessage).getName()});
        }
    }

    public void setTransport(Transport transport) throws TransportBindingException {
        try {
            this.transport = (HTTPTransport)transport;
            HttpServletRequest request = this.transport.getRequest();
            this.style = request.getParameter(STYLE);
            if (this.style == null && !this.style.equals(MIME_STYLE)) {
                throw new ConfigurationException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2110", new Object[]{this.style});
            }
            Object messageStream = request.getInputStream();
            String contentTypeHeader = request.getContentType();
            Location location = Location.getLocation((String)WSLogging.RUNTIME_LOCATION);
            if (location.beLogged(100)) {
                messageStream = this.logRequest(location, (InputStream)messageStream, request.getContextPath());
            }
            this.mimeMessage = this.getMIMEMessage();
            this.mimeMessage.initDeserializationMode((InputStream)messageStream, contentTypeHeader);
        }
        catch (ClassCastException e) {
            throw new ConfigurationException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2112", new Object[]{transport, (class$com$sap$engine$interfaces$webservices$runtime$soaphttp$HTTPTransport == null ? (class$com$sap$engine$interfaces$webservices$runtime$soaphttp$HTTPTransport = MIMEHTTPTransportBinding.class$("com.sap.engine.interfaces.webservices.runtime.soaphttp.HTTPTransport")) : class$com$sap$engine$interfaces$webservices$runtime$soaphttp$HTTPTransport).getName()});
        }
        catch (IOException ioE) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2111", new Object[]{"inputStream", ioE.getLocalizedMessage()}, ioE);
        }
    }

    public void setGlobalConfiguration(Config config) throws TransportBindingException {
        this.globalConfig = config;
    }

    public void setVirtualOperation(OperationDefinition operation) throws TransportBindingException {
        this.operation = operation;
    }

    public OperationDefinition getOperation() {
        return this.operation;
    }

    public void setRuntimeContext(RuntimeContext wsInterface) {
        this.runtimeContext = wsInterface;
    }

    public Object[] getParameters(Class[] methodClass, ClassLoader loader) throws TransportBindingException {
        return StreamEngineMIME.deserializeEncoded(this.operation, methodClass, this.mimeMessage, this.typeMappingRegistry, this.javaToQNameMappingsRegistry, loader);
    }

    public RawMessage createResponseMessage(Object returnObject, Class returnObjectClass, Object[] resultParams, Class[] resultParamsClasses) throws TransportBindingException {
        try {
            this.mimeMessage.initSerializationMode();
            XMLTokenWriter writer = this.mimeMessage.getSOAPMessage().getWriter();
            writer.enter("http://schemas.xmlsoap.org/soap/envelope/", BODYTAG);
            StreamEngineMIME.serializeEncoded(writer, returnObject, returnObjectClass, this.operation, this.mimeMessage, this.typeMappingRegistry, this.javaToQNameMappingsRegistry);
            writer.leave();
            return this.mimeMessage;
        }
        catch (Exception e) {
            throw new ProcessException(e);
        }
    }

    public RawMessage createFaultMessage(Throwable thr) throws TransportBindingException {
        Fault[] faults = null;
        String operationName = null;
        if (this.operation != null) {
            faults = this.operation.getFaults();
            operationName = this.operation.getOperationName();
        }
        this.mimeMessage.initSerializationMode();
        InternalSOAPMessage soapMessage = this.mimeMessage.getSOAPMessage();
        XMLTokenWriter writer = soapMessage.initSerializationMode();
        if (faults != null && faults.length > 0) {
            int i = 0;
            while (i < faults.length) {
                if (faults[i].getJavaClassName().equalsIgnoreCase(thr.getClass().getName())) break;
                ++i;
            }
            if (i < faults.length) {
                try {
                    writer.enter("http://schemas.xmlsoap.org/soap/envelope/", BODYTAG);
                    StreamEngine.serializeThrowableEncoded(writer, thr, "Client", faults[i], operationName, this.javaToQNameMappingsRegistry, this.typeMappingRegistry);
                    writer.leave();
                }
                catch (IOException ioE) {
                    throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2125", new Object[]{ioE.getLocalizedMessage()}, ioE);
                }
                return this.mimeMessage;
            }
        }
        try {
            writer.enter("http://schemas.xmlsoap.org/soap/envelope/", BODYTAG);
            StreamEngine.serializeThrowableLiteral(writer, thr, "Client", null, operationName, null, null);
            writer.leave();
        }
        catch (IOException ioE) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2125", new Object[]{ioE.getLocalizedMessage()}, ioE);
        }
        return this.mimeMessage;
    }

    public Key[] getOperationKeys(OperationDefinition operationData) throws TransportBindingException {
        Config cfg = operationData.getInputConfiguration();
        PropertyDescriptor soapActionDescr = cfg.getProperty("soapAction");
        String firstElName = operationData.getOperationName();
        PropertyDescriptor namespaceDescr = cfg.getProperty("namespace");
        if (namespaceDescr == null || namespaceDescr.getValue() == null) {
            throw new ConfigurationException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2101", new Object[]{firstElName, "namespace", "input"});
        }
        String namespace = namespaceDescr.getValue();
        Key[] keys = new Key[]{new Key("first-body-element-name", firstElName), new Key("first-body-element-ns", namespace)};
        return keys;
    }

    public void sendResponse() throws TransportBindingException {
        this.sendMessage(200);
    }

    public void sendServerError(Throwable thr) throws TransportBindingException {
        try {
            if (this.mimeMessage == null) {
                this.mimeMessage = this.getMIMEMessage();
            }
            this.mimeMessage.initSerializationMode();
            XMLTokenWriter writer = this.mimeMessage.getSOAPMessage().getWriter();
            writer.enter("http://schemas.xmlsoap.org/soap/envelope/", BODYTAG);
            StreamEngine.serializeThrowableLiteral(writer, thr, "Server", null, null, null, null);
            writer.leave();
            this.sendMessage(500);
        }
        catch (Exception e) {
            try {
                StringWriter writer = new StringWriter();
                PrintWriter prWriter = new PrintWriter(writer);
                thr.printStackTrace(prWriter);
                prWriter.flush();
                this.transport.getResponse().sendError(500, writer.toString());
                prWriter.close();
            }
            catch (Exception newE) {
                throw new ProcessException(newE);
            }
        }
    }

    public void clearState() throws TransportBindingException {
    }

    private void sendMessage(int responseCode) throws TransportBindingException {
        try {
            block5: {
                try {
                    HttpServletResponse response = this.transport.getResponse();
                    response.setStatus(responseCode);
                    int partCount = this.mimeMessage.getMultiPartObject().getCount();
                    if (partCount > 0) {
                        ContentType cntType = new ContentType(this.mimeMessage.getMultiPartObject().getContentType());
                        String boundaryValue = cntType.getParameter("boundary");
                        ParameterList list = new ParameterList();
                        list.set("type", "text/xml");
                        list.set("boundary", boundaryValue);
                        response.setContentType(new ContentType("multipart", "related", list).toString());
                        ServletOutputStream outputStream = response.getOutputStream();
                        this.mimeMessage.writeTo((OutputStream)outputStream);
                        break block5;
                    }
                    response.setContentType("text/xml; charset=UTF-8");
                    ServletOutputStream outputStream = response.getOutputStream();
                    this.mimeMessage.getSOAPMessage().writeMessage((OutputStream)outputStream);
                }
                catch (Exception e) {
                    throw new ProcessException(e);
                }
            }
            Object var9_10 = null;
            this.mimeMessage.clearState();
            messages.rollBackInstance(this.mimeMessage);
            this.mimeMessage = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.mimeMessage.clearState();
            messages.rollBackInstance(this.mimeMessage);
            this.mimeMessage = null;
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private InputStream logRequest(Location location, InputStream inputStream, String httpContext) throws ProcessException {
        ReferenceByteArrayOutputStream messBuf = new ReferenceByteArrayOutputStream();
        try {
            int b;
            byte[] rBuf = new byte[128];
            while ((b = inputStream.read(rBuf)) != -1) {
                void var5_6;
                messBuf.write(rBuf, 0, (int)var5_6);
            }
        }
        catch (IOException ioE) {
            throw new ProcessException(ioE);
        }
        location.logT(100, "Requested context: [" + httpContext + "] message: " + messBuf.toString());
        return new ByteArrayInputStream(messBuf.getContentReference(), 0, messBuf.size());
    }

    private InternalMIMEMessage getMIMEMessage() {
        InternalMIMEMessage message = (InternalMIMEMessage)messages.getInstance();
        if (message == null) {
            return new InternalMIMEMessage();
        }
        return message;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

