/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.additions.soaphttp;

import com.sap.engine.interfaces.webservices.runtime.RawMessage;
import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReaderImpl;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriter;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriterImpl;
import com.sap.engine.lib.xml.util.DOMSerializer;
import com.sap.engine.services.webservices.additions.soaphttp.exceptions.ProcessException;
import com.sap.engine.services.webservices.additions.soaphttp.exceptions.TBindingResourceAccessor;
import com.sap.engine.services.webservices.tools.ReferenceByteArrayOutputStream;
import com.sap.localization.ResourceAccessor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPBody;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class InternalSOAPMessage
implements RawMessage {
    public static final int DESERIALIZATION_MODE = 1;
    public static final int SERIALIZATION_MODE = 2;
    public static final String SOAPENV_PREFIX = "SOAP-ENV";
    public static final String XS_PREFIX = "xs";
    public static final String XSI_PREFIX = "xsi";
    private static final int BUFFER_SIZE = 1024;
    private static final int MAX_BUFFER_SIZE = 8192;
    private static final String BODYTAG = "Body";
    private static final String HEADERTAG = "Header";
    private static final String ENVELOPE = "Envelope";
    private static final String VERSION_MISMATCH = "VersionMismatch";
    private static final byte[] STARTENVELOPE_TAG = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" >".getBytes();
    private static final byte[] ENDENVELOPE_TAG = "</SOAP-ENV:Envelope>".getBytes();
    private static final byte[] STARTHEADER_TAG = "<SOAP-ENV:Header>".getBytes();
    private static final byte[] ENDHEADER_TAG = "</SOAP-ENV:Header>".getBytes();
    private static final Hashtable defaultPrefixes = new Hashtable();
    private static DocumentBuilderFactory builderFactory;
    private ArrayList headers;
    private Element soapBody;
    private Element soapEnvelope;
    private XMLTokenReader reader;
    private XMLTokenWriterImpl writer;
    private DOMSerializer domSerializer;
    private ReferenceByteArrayOutputStream bodyByteArrayBuffer;
    private boolean isBodyDOMbuilt = false;
    private boolean isEnvelopeDOMbuilt = false;
    private int messageMode;
    private String bodyWrapperQName;
    private String bodyWrapperUri;
    private boolean isBodyWrapperRead;
    private Document document;
    private Attributes bodyAttrs;
    private Attributes bodyWrapperAttrs;
    private Attributes soapEnvelopeAttrs;
    private String soapEnvelopeQName;
    private Attributes soapHeaderAttrs;
    private String soapHeaderQName;
    private String soapBodyQName;

    public InternalSOAPMessage() {
        this.headers = new ArrayList();
        this.isBodyDOMbuilt = false;
        this.isBodyWrapperRead = false;
        this.messageMode = 0;
        this.writer = new XMLTokenWriterImpl();
        this.reader = new XMLTokenReaderImpl();
        this.bodyByteArrayBuffer = new ReferenceByteArrayOutputStream(1024);
        this.writer.init((OutputStream)this.bodyByteArrayBuffer, defaultPrefixes);
        this.domSerializer = new DOMSerializer();
        this.domSerializer.setOutputProperty("omit-xml-declaration", "yes");
        this.domSerializer.setOutputProperty("indent", "no");
    }

    public InternalSOAPMessage(SOAPBody soapBody) {
        this.soapBody = (Element)soapBody;
        this.isBodyDOMbuilt = true;
    }

    public XMLTokenWriter initSerializationMode() {
        this.messageMode = 2;
        this.headers.clear();
        this.soapBody = null;
        this.isBodyDOMbuilt = false;
        this.isBodyWrapperRead = false;
        this.isEnvelopeDOMbuilt = false;
        this.soapEnvelope = null;
        this.document = null;
        this.bodyAttrs = null;
        this.bodyWrapperAttrs = null;
        this.soapEnvelopeAttrs = null;
        this.soapHeaderAttrs = null;
        this.soapEnvelopeQName = null;
        this.soapHeaderQName = null;
        this.soapBodyQName = null;
        this.bodyByteArrayBuffer.reset();
        this.writer.init((OutputStream)this.bodyByteArrayBuffer, defaultPrefixes);
        return this.writer;
    }

    public XMLTokenReader initDeserializationMode(InputStream inputStream) throws ProcessException {
        this.messageMode = 1;
        this.headers.clear();
        this.soapBody = null;
        this.isBodyDOMbuilt = false;
        this.isBodyWrapperRead = false;
        this.isEnvelopeDOMbuilt = false;
        this.soapEnvelope = null;
        this.document = null;
        this.soapEnvelopeAttrs = null;
        this.soapHeaderAttrs = null;
        this.bodyAttrs = null;
        this.soapEnvelopeQName = null;
        this.soapHeaderQName = null;
        this.soapBodyQName = null;
        this.bodyByteArrayBuffer.reset();
        this.reader.init(inputStream);
        try {
            this.reader.begin();
        }
        catch (ParserException pE) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2114", new Object[]{pE.getLocalizedMessage()}, pE);
        }
        this.extractHeaders(this.reader);
        Attributes attrs = this.reader.getAttributes();
        if (attrs == null) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2117");
        }
        this.bodyAttrs = attrs;
        this.soapBodyQName = this.reader.getQName();
        return this.reader;
    }

    public ArrayList getHeaders() {
        return this.headers;
    }

    public void setBodyWrapperData(XMLTokenReader reader) throws ProcessException {
        Attributes attrs = reader.getAttributes();
        if (attrs == null) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2117");
        }
        this.bodyWrapperAttrs = attrs;
        this.bodyWrapperQName = reader.getQName();
        this.bodyWrapperUri = reader.getURI();
        this.isBodyWrapperRead = true;
    }

    public boolean isDOMbuilt() {
        return this.isBodyDOMbuilt;
    }

    public Element getSoapBody() throws ProcessException {
        if (!this.isBodyDOMbuilt) {
            if (this.messageMode == 1) {
                this.soapBody = this.buildBodyDOMFromReader();
            } else if (this.messageMode == 2) {
                this.soapBody = this.buildBodyDOMFromByteArray();
            }
            this.isBodyDOMbuilt = true;
        }
        return this.soapBody;
    }

    public Element getSoapEnvelope() throws ProcessException {
        if (!this.isEnvelopeDOMbuilt) {
            Element body = this.getSoapBody();
            String soapEnv = this.soapEnvelopeQName != null ? this.soapEnvelopeQName : "SOAP-ENV:Envelope";
            this.soapEnvelope = body.getOwnerDocument().createElementNS("http://schemas.xmlsoap.org/soap/envelope/", soapEnv);
            InternalSOAPMessage.appendAttrs(this.soapEnvelope, this.soapEnvelopeAttrs);
            if (this.headers.size() > 0) {
                String soapHeaderStr = this.soapHeaderQName != null ? this.soapHeaderQName : "SOAP-ENV:Header";
                Element soapHeader = this.soapEnvelope.getOwnerDocument().createElementNS("http://schemas.xmlsoap.org/soap/envelope/", soapHeaderStr);
                InternalSOAPMessage.appendAttrs(soapHeader, this.soapHeaderAttrs);
                this.soapEnvelope.appendChild(soapHeader);
                int i = 0;
                while (i < this.headers.size()) {
                    Element tmpHeader = (Element)this.headers.get(i);
                    if (tmpHeader.getOwnerDocument() != soapHeader.getOwnerDocument()) {
                        tmpHeader = (Element)soapHeader.getOwnerDocument().importNode(tmpHeader, true);
                    }
                    soapHeader.appendChild(tmpHeader);
                    ++i;
                }
            }
            this.soapEnvelope.appendChild(body);
            this.isEnvelopeDOMbuilt = true;
        }
        return this.soapEnvelope;
    }

    public XMLTokenReader getReader() {
        if (this.isBodyDOMbuilt) {
            return null;
        }
        return this.reader;
    }

    public XMLTokenWriter getWriter() {
        return this.writer;
    }

    public void setHeaders(Element[] headers) throws ProcessException {
        if (headers != null) {
            int i = 0;
            while (i < headers.length) {
                this.headers.add(headers[i]);
                ++i;
            }
        }
    }

    public void writeMessage(OutputStream outputStream) throws IOException, ProcessException {
        outputStream.write(STARTENVELOPE_TAG);
        if (this.headers.size() > 0) {
            outputStream.write(STARTHEADER_TAG);
            int i = 0;
            while (i < this.headers.size()) {
                try {
                    this.domSerializer.write((Node)this.headers.get(i), outputStream);
                }
                catch (Exception trE) {
                    throw new ProcessException(trE);
                }
                ++i;
            }
            outputStream.write(ENDHEADER_TAG);
        }
        if (this.isBodyDOMbuilt) {
            try {
                this.domSerializer.write((Node)this.soapBody, outputStream);
            }
            catch (Exception e) {
                throw new ProcessException(e);
            }
        } else {
            this.writer.flush();
            if (this.bodyByteArrayBuffer.size() == 0) {
                throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2175");
            }
            this.bodyByteArrayBuffer.writeTo(outputStream);
        }
        outputStream.write(ENDENVELOPE_TAG);
    }

    void clearState() {
        this.headers.clear();
        this.soapBody = null;
        this.bodyWrapperQName = null;
        this.bodyWrapperUri = null;
        this.bodyAttrs = null;
        this.bodyWrapperAttrs = null;
        if (this.bodyByteArrayBuffer.size() > 8192) {
            this.bodyByteArrayBuffer = new ReferenceByteArrayOutputStream(1024);
            this.writer.init((OutputStream)this.bodyByteArrayBuffer, defaultPrefixes);
        } else {
            this.bodyByteArrayBuffer.reset();
        }
    }

    private void extractHeaders(XMLTokenReader reader) throws ProcessException {
        int code;
        this.checkEnvelopeNS(reader);
        try {
            code = reader.moveToNextElementStart();
        }
        catch (ParserException pE) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2114", new Object[]{pE.getLocalizedMessage()}, pE);
        }
        switch (code) {
            case 1: {
                if (reader.getLocalNameCharArray().equals((Object)HEADERTAG) && reader.getURICharArray().equals((Object)"http://schemas.xmlsoap.org/soap/envelope/")) {
                    this.soapHeaderAttrs = reader.getAttributes();
                    this.soapHeaderQName = reader.getQName();
                    this.loadHeaders(reader);
                    return;
                }
                if (reader.getLocalNameCharArray().equals((Object)BODYTAG) && reader.getURICharArray().equals((Object)"http://schemas.xmlsoap.org/soap/envelope/")) {
                    return;
                }
                throw new ProcessException(new Exception("Not supported element: {" + reader.getURI() + "}" + reader.getLocalName()));
            }
            case 6: {
                throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2141");
            }
        }
    }

    private void loadHeaders(XMLTokenReader reader) throws ProcessException {
        Document hDoc = this.getDocument();
        while (true) {
            int code;
            try {
                code = reader.next();
            }
            catch (ParserException pE) {
                throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2114", new Object[]{pE.getLocalizedMessage()}, pE);
            }
            switch (code) {
                case 1: {
                    Element headerEntry = null;
                    try {
                        headerEntry = reader.getDOMRepresentation(hDoc);
                    }
                    catch (ParserException pE) {
                        throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2114", new Object[]{pE.getLocalizedMessage()}, pE);
                    }
                    this.headers.add(headerEntry);
                    break;
                }
                case 2: {
                    if (reader.getCurrentLevel() == 1) {
                        try {
                            code = reader.moveToNextElementStart();
                        }
                        catch (ParserException pE) {
                            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2114", new Object[]{pE.getLocalizedMessage()}, pE);
                        }
                        if (code == 1) {
                            if (reader.getURICharArray().equals((Object)"http://schemas.xmlsoap.org/soap/envelope/") && reader.getLocalNameCharArray().equals((Object)BODYTAG)) {
                                return;
                            }
                            throw new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2145", new Object[]{reader.getQName()});
                        }
                        throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2146");
                    }
                    throw new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2144", new Object[]{reader.getQName()});
                }
                case 6: {
                    throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2146");
                }
            }
        }
    }

    private static void appendAttrs(Element el, Attributes attrs) {
        if (attrs == null) {
            return;
        }
        int attrsLeght = attrs.getLength();
        int i = 0;
        while (i < attrsLeght) {
            String attribUri = attrs.getURI(i);
            String attribQName = attrs.getQName(i);
            String attribValue = attrs.getValue(i);
            if (attribQName.indexOf(":") != -1) {
                el.setAttributeNS(attribUri, attribQName, attribValue);
            } else {
                el.setAttribute(attribQName, attribValue);
            }
            ++i;
        }
    }

    private Element buildBodyDOMFromReader() throws ProcessException {
        Document document = this.getDocument();
        int code = this.reader.getState();
        if (code == 1 && this.reader.getLocalNameCharArray().equals((Object)BODYTAG) && this.reader.getURICharArray().equals((Object)"http://schemas.xmlsoap.org/soap/envelope/")) {
            try {
                return this.reader.getDOMRepresentation(document);
            }
            catch (ParserException pE) {
                throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2114", new Object[]{pE.getLocalizedMessage()}, pE);
            }
        }
        Element bodyWrapper = null;
        if (!this.isBodyWrapperRead) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2143");
        }
        Element body = document.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", this.soapBodyQName);
        InternalSOAPMessage.appendAttrs(body, this.bodyAttrs);
        bodyWrapper = document.createElementNS(this.bodyWrapperUri, this.bodyWrapperQName);
        InternalSOAPMessage.appendAttrs(bodyWrapper, this.bodyWrapperAttrs);
        body.appendChild(bodyWrapper);
        while (true) {
            try {
                code = this.reader.moveToNextElementStart();
            }
            catch (ParserException pE) {
                throw new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2114", new Object[]{pE.getLocalizedMessage()});
            }
            if (code != 1) break;
            try {
                bodyWrapper.appendChild(this.reader.getDOMRepresentation(document));
            }
            catch (ParserException pE) {
                throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2114", new Object[]{pE.getLocalizedMessage()}, pE);
            }
        }
        return body;
    }

    private Element buildBodyDOMFromByteArray() throws ProcessException {
        try {
            Element body = null;
            if (this.bodyByteArrayBuffer.size() == 0) {
                body = this.getDocument().createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:Body");
            } else {
                ReferenceByteArrayOutputStream envBuf = new ReferenceByteArrayOutputStream(STARTENVELOPE_TAG.length + this.bodyByteArrayBuffer.size() + ENDENVELOPE_TAG.length);
                envBuf.write(STARTENVELOPE_TAG);
                this.bodyByteArrayBuffer.writeTo((OutputStream)envBuf);
                envBuf.write(ENDENVELOPE_TAG);
                Document nDoc = InternalSOAPMessage.getDocumentBuilder().parse(new ByteArrayInputStream(envBuf.getContentReference(), 0, envBuf.size()));
                body = (Element)nDoc.getDocumentElement().getFirstChild();
            }
            return body;
        }
        catch (SAXException saxE) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2147", new Object[]{saxE.getClass().getName(), saxE.getLocalizedMessage()}, saxE);
        }
        catch (IOException ioE) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2147", new Object[]{ioE.getClass().getName(), ioE.getLocalizedMessage()}, ioE);
        }
    }

    private static DocumentBuilder getDocumentBuilder() throws ProcessException {
        try {
            return builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pcfgE) {
            throw new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2142", pcfgE);
        }
    }

    private Document getDocument() throws ProcessException {
        if (this.document == null) {
            this.document = InternalSOAPMessage.getDocumentBuilder().newDocument();
        }
        return this.document;
    }

    private void checkEnvelopeNS(XMLTokenReader reader) throws ProcessException {
        if (reader.getState() != 1) {
            int code;
            try {
                code = reader.moveToNextElementStart();
            }
            catch (ParserException pE) {
                throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2114", new Object[]{pE.getLocalizedMessage()}, pE);
            }
            if (code == 6) {
                throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2172");
            }
        }
        if (reader.getLocalNameCharArray().equals((Object)ENVELOPE) && reader.getURICharArray().equals((Object)"http://schemas.xmlsoap.org/soap/envelope/")) {
            this.soapEnvelopeAttrs = reader.getAttributes();
            this.soapEnvelopeQName = reader.getQName();
            return;
        }
        ProcessException prExc = new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2171", new Object[]{"{http://schemas.xmlsoap.org/soap/envelope/}" + reader.getLocalName(), reader.getURI()});
        prExc.setSOAPFaultCode(VERSION_MISMATCH);
        throw prExc;
    }

    static {
        defaultPrefixes.put("http://schemas.xmlsoap.org/soap/envelope/", SOAPENV_PREFIX);
        defaultPrefixes.put("http://www.w3.org/2001/XMLSchema", XS_PREFIX);
        defaultPrefixes.put("http://www.w3.org/2001/XMLSchema-instance", XSI_PREFIX);
        builderFactory = new DocumentBuilderFactoryImpl();
        builderFactory.setNamespaceAware(true);
    }
}

