/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.additions.soaphttp;

import com.sap.engine.interfaces.webservices.runtime.RawMessage;
import com.sap.engine.services.webservices.additions.soaphttp.ContentTypeInner;
import com.sap.engine.services.webservices.additions.soaphttp.InternalSOAPMessage;
import com.sap.engine.services.webservices.additions.soaphttp.exceptions.ProcessException;
import com.sap.engine.services.webservices.additions.soaphttp.exceptions.TBindingResourceAccessor;
import com.sap.localization.ResourceAccessor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

public class InternalMIMEMessage
implements RawMessage {
    private static final String TEXTXML_TYPE = "text/xml";
    private static final String PRIMARY_TYPE = "multipart";
    private static final String SUB_TYPE = "related";
    private static final String START_PARAMETER = "start";
    private static final String CID = "cid:";
    private InternalSOAPMessage iSOAPMessage = new InternalSOAPMessage();
    private MimeMultipart mimeMessage;
    private Hashtable cidMappings = new Hashtable();
    private Hashtable clMappings = new Hashtable();

    public void initDeserializationMode(final InputStream inputStream, String requestContentType) throws ProcessException {
        block12: {
            BodyPart rootPart = null;
            try {
                if (requestContentType == null) {
                    throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2136");
                }
                final ContentTypeInner contentType = new ContentTypeInner(requestContentType);
                if (contentType.getPrimaryType().equalsIgnoreCase(PRIMARY_TYPE) && contentType.getSubType().equalsIgnoreCase(SUB_TYPE)) {
                    ContentTypeInner partCt;
                    this.mimeMessage = new MimeMultipart(new DataSource(){

                        public InputStream getInputStream() throws IOException {
                            return inputStream;
                        }

                        public OutputStream getOutputStream() throws IOException {
                            return null;
                        }

                        public String getContentType() {
                            return contentType.toString();
                        }

                        public String getName() {
                            return "";
                        }
                    });
                    String stpValue = contentType.getParameter(START_PARAMETER);
                    if (stpValue != null) {
                        rootPart = this.mimeMessage.getBodyPart(stpValue);
                        if (rootPart == null) {
                            throw new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2148", new Object[]{stpValue});
                        }
                    } else if (this.mimeMessage.getCount() > 0) {
                        rootPart = this.mimeMessage.getBodyPart(0);
                    } else {
                        throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2149");
                    }
                    if (!(partCt = new ContentTypeInner(rootPart.getContentType())).getBaseType().equalsIgnoreCase(TEXTXML_TYPE)) {
                        throw new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2150", new Object[]{TEXTXML_TYPE, rootPart.getContentType()});
                    }
                    this.loadMappingTables(rootPart);
                    this.iSOAPMessage.initDeserializationMode(rootPart.getInputStream());
                    break block12;
                }
                if (contentType.getPrimaryType().equalsIgnoreCase("text") && contentType.getSubType().equalsIgnoreCase("xml")) {
                    this.iSOAPMessage.initDeserializationMode(inputStream);
                    break block12;
                }
                throw new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2150", new Object[]{TEXTXML_TYPE, contentType.getBaseType()});
            }
            catch (MessagingException msgE) {
                throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2152", new Object[]{((Object)((Object)msgE)).getClass().getName(), msgE.getLocalizedMessage()}, msgE);
            }
            catch (IOException ioE) {
                throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2152", new Object[]{ioE.getClass().getName(), ioE.getLocalizedMessage()}, ioE);
            }
        }
    }

    public MimeMultipart initSerializationMode() {
        this.iSOAPMessage.initSerializationMode();
        this.mimeMessage = new MimeMultipart(SUB_TYPE);
        return this.mimeMessage;
    }

    public MimeMultipart getMultiPartObject() {
        return this.mimeMessage;
    }

    public InternalSOAPMessage getSOAPMessage() {
        return this.iSOAPMessage;
    }

    public BodyPart getPart(String hrefValue) {
        if (hrefValue.startsWith(CID)) {
            return (BodyPart)this.cidMappings.get(hrefValue.substring(CID.length()));
        }
        return (BodyPart)this.clMappings.get(hrefValue);
    }

    void clearState() {
        this.iSOAPMessage.clearState();
        this.cidMappings.clear();
        this.clMappings.clear();
        this.mimeMessage = null;
    }

    private void loadMappingTables(BodyPart rootPart) throws ProcessException, MessagingException {
        int parts = this.mimeMessage.getCount();
        int i = 0;
        while (i < parts) {
            BodyPart tPart = this.mimeMessage.getBodyPart(i);
            if (rootPart != tPart) {
                String cidh = this.getSingleHeaderValue("Content-ID", tPart);
                String clh = this.getSingleHeaderValue("Content-Location", tPart);
                if (cidh != null) {
                    cidh = cidh.substring(1, cidh.length() - 1);
                    this.cidMappings.put(cidh, tPart);
                } else if (clh != null) {
                    this.clMappings.put(clh, tPart);
                } else {
                    throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2151");
                }
            }
            ++i;
        }
    }

    private String getSingleHeaderValue(String headerName, BodyPart part) throws MessagingException {
        String[] headers = part.getHeader(headerName);
        if (headers == null) {
            return null;
        }
        if (headers.length != 1) {
            return null;
        }
        return headers[0];
    }

    public void writeTo(OutputStream outputStream) throws ProcessException {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.iSOAPMessage.writeMessage(buffer);
            InternetHeaders headers = new InternetHeaders();
            headers.addHeader("Content-type", TEXTXML_TYPE);
            MimeBodyPart rootPart = new MimeBodyPart(headers, buffer.toByteArray());
            this.mimeMessage.addBodyPart((BodyPart)rootPart, 0);
            this.mimeMessage.writeTo(outputStream);
        }
        catch (MessagingException msgE) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2153", new Object[]{((Object)((Object)msgE)).getClass().getName(), msgE.getLocalizedMessage()}, msgE);
        }
        catch (IOException ioE) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2153", new Object[]{ioE.getClass().getName(), ioE.getLocalizedMessage()}, ioE);
        }
    }
}

