/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.additions.soaphttp;

import com.sap.engine.interfaces.webservices.runtime.Config;
import com.sap.engine.interfaces.webservices.runtime.JavaToQNameMappingRegistry;
import com.sap.engine.interfaces.webservices.runtime.Key;
import com.sap.engine.interfaces.webservices.runtime.OperationDefinition;
import com.sap.engine.interfaces.webservices.runtime.ParameterNode;
import com.sap.engine.interfaces.webservices.runtime.RawMessage;
import com.sap.engine.interfaces.webservices.runtime.RuntimeContext;
import com.sap.engine.interfaces.webservices.runtime.Transport;
import com.sap.engine.interfaces.webservices.runtime.TransportBindingException;
import com.sap.engine.interfaces.webservices.runtime.soaphttp.HTTPTransport;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriter;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriterImpl;
import com.sap.engine.services.webservices.additions.soaphttp.AbstractHTTPTransportBinding;
import com.sap.engine.services.webservices.additions.soaphttp.HTTPConflictException;
import com.sap.engine.services.webservices.additions.soaphttp.StreamEngine;
import com.sap.engine.services.webservices.additions.soaphttp.exceptions.ConfigurationException;
import com.sap.engine.services.webservices.additions.soaphttp.exceptions.ProcessException;
import com.sap.engine.services.webservices.additions.soaphttp.exceptions.TBindingResourceAccessor;
import com.sap.localization.ResourceAccessor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.rpc.encoding.TypeMappingRegistry;

public class HTTPTransportBinding
extends AbstractHTTPTransportBinding {
    private static final String OPERATION_LOCATION = "location";
    private HTTPTransport transport;
    private String configMethod;
    private JavaToQNameMappingRegistry javaToQNameMappingRegistry;
    private TypeMappingRegistry typeMappingRegistry;
    private OperationDefinition operation;
    private XMLTokenWriterImpl writer;
    private ByteArrayOutputStream responseContent;
    private String faultErrorMessage;
    static /* synthetic */ Class class$com$sap$engine$interfaces$webservices$runtime$soaphttp$HTTPTransport;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;

    public Transport getTransport() throws TransportBindingException {
        return this.transport;
    }

    public RawMessage getRawMessage() throws TransportBindingException {
        return null;
    }

    public Properties getSupportedFeatures() {
        return null;
    }

    public void setMappingRegistries(JavaToQNameMappingRegistry nameMapping, TypeMappingRegistry registry) throws TransportBindingException {
        this.javaToQNameMappingRegistry = nameMapping;
        this.typeMappingRegistry = registry;
    }

    public Key[] getMessageKeys() throws TransportBindingException {
        String requestedUri = this.transport.getRequest().getRequestURI();
        if (requestedUri != null) {
            int del;
            if (requestedUri.endsWith("/")) {
                requestedUri = requestedUri.substring(0, requestedUri.length() - 1);
            }
            if ((del = requestedUri.lastIndexOf(47)) == -1) {
                throw new HTTPConflictException("Incorrect requestedUri string '" + requestedUri + "'");
            }
            return new Key[]{new Key(OPERATION_LOCATION, requestedUri.substring(del + 1, requestedUri.length()))};
        }
        throw new HTTPConflictException("Incorrect requestedUri string '" + requestedUri + "'");
    }

    public void setRawMessage(RawMessage message) throws TransportBindingException {
    }

    public void setTransport(Transport transport) throws TransportBindingException {
        try {
            this.transport = (HTTPTransport)transport;
            String verb = this.transport.getRequest().getMethod();
            if (!this.configMethod.equalsIgnoreCase(verb)) {
                throw new HTTPConflictException("In config found method property value: '" + this.configMethod + "'. The transport method is: '" + verb + "'");
            }
        }
        catch (ClassCastException e) {
            throw new ConfigurationException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2112", new Object[]{transport, (class$com$sap$engine$interfaces$webservices$runtime$soaphttp$HTTPTransport == null ? (class$com$sap$engine$interfaces$webservices$runtime$soaphttp$HTTPTransport = HTTPTransportBinding.class$("com.sap.engine.interfaces.webservices.runtime.soaphttp.HTTPTransport")) : class$com$sap$engine$interfaces$webservices$runtime$soaphttp$HTTPTransport).getName()});
        }
    }

    public void setGlobalConfiguration(Config config) throws TransportBindingException {
        try {
            this.configMethod = config.getProperty("method").getValue();
        }
        catch (NullPointerException e) {
            throw new ConfigurationException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2106", new Object[]{"method", "global transportBinding", "null"});
        }
    }

    public void setVirtualOperation(OperationDefinition e) throws TransportBindingException {
        this.operation = e;
    }

    public void setRuntimeContext(RuntimeContext wsInterface) {
    }

    public Object[] getParameters(Class[] methodClass, ClassLoader loader) throws TransportBindingException {
        HttpServletRequest request = this.transport.getRequest();
        Map values = request.getParameterMap();
        ParameterNode[] nodes = this.operation.getInputParameters();
        int length = nodes.length;
        Object[] result = new Object[length];
        int i = 0;
        while (i < length) {
            ParameterNode paramNode = nodes[i];
            String partName = paramNode.getParameterName();
            if (paramNode.isExposed()) {
                String[] extractedValue = (String[])values.get(partName);
                if (extractedValue == null) {
                    throw new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2138", new Object[]{partName, extractedValue});
                }
                result[i] = this.createObject(methodClass[i], extractedValue, partName);
            } else {
                result[i] = this.createSimpleObject(methodClass[i], paramNode.getDefaultValue());
            }
            ++i;
        }
        return result;
    }

    public RawMessage createResponseMessage(Object returnObject, Class returnObjectClass, Object[] resultParams, Class[] resultParamsClasses) throws TransportBindingException {
        this.responseContent = new ByteArrayOutputStream();
        this.writer = new XMLTokenWriterImpl();
        this.writer.init((OutputStream)this.responseContent);
        StreamEngine.serialize((XMLTokenWriter)this.writer, returnObject, returnObjectClass, this.operation, this.typeMappingRegistry, this.javaToQNameMappingRegistry, "literal", "document");
        return null;
    }

    public RawMessage createFaultMessage(Throwable thr) throws TransportBindingException {
        this.faultErrorMessage = thr.getLocalizedMessage();
        return null;
    }

    public Key[] getOperationKeys(OperationDefinition operationData) throws TransportBindingException {
        return new Key[]{new Key(OPERATION_LOCATION, operationData.getOperationName())};
    }

    public void sendResponse() throws ProcessException {
        try {
            HttpServletResponse response = this.transport.getResponse();
            if (this.faultErrorMessage != null) {
                response.sendError(500, this.faultErrorMessage);
            } else {
                response.setStatus(200);
                response.setContentType("text/xml");
                ServletOutputStream output = response.getOutputStream();
                this.writer.flush();
                this.responseContent.writeTo((OutputStream)output);
            }
        }
        catch (IOException ioE) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2116", new Object[]{ioE.getLocalizedMessage()}, ioE);
        }
    }

    public void sendServerError(Throwable thr) throws TransportBindingException {
        try {
            HttpServletResponse response = this.transport.getResponse();
            String localizedMessage = thr.getLocalizedMessage();
            if (localizedMessage == null) {
                localizedMessage = "null";
            }
            response.sendError(500, localizedMessage);
        }
        catch (IOException ioE) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2116", new Object[]{ioE.getLocalizedMessage()}, ioE);
        }
    }

    public void clearState() throws ProcessException {
    }

    private Object createObject(Class objClass, String[] objValue, String partName) throws ProcessException {
        if (objClass.isArray()) {
            Class<?> arrComponent = objClass.getComponentType();
            if (arrComponent.isArray()) {
                throw new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2166", new Object[]{partName});
            }
            Object arrObject = Array.newInstance(arrComponent, objValue.length);
            int i = 0;
            while (i < objValue.length) {
                Array.set(arrObject, i, this.createSimpleObject(arrComponent, objValue[i]));
                ++i;
            }
            return arrObject;
        }
        if (objValue.length != 1) {
            throw new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2165", new Object[]{Integer.toString(objValue.length), partName});
        }
        return this.createSimpleObject(objClass, objValue[0]);
    }

    private Object createSimpleObject(Class objClass, String objValue) throws ProcessException {
        try {
            if (objClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = HTTPTransportBinding.class$("java.lang.Integer")) : class$java$lang$Integer) || objClass == Integer.TYPE) {
                return new Integer(objValue);
            }
            if (objClass == (class$java$lang$Short == null ? (class$java$lang$Short = HTTPTransportBinding.class$("java.lang.Short")) : class$java$lang$Short) || objClass == Short.TYPE) {
                return new Short(objValue);
            }
            if (objClass == (class$java$lang$Byte == null ? (class$java$lang$Byte = HTTPTransportBinding.class$("java.lang.Byte")) : class$java$lang$Byte) || objClass == Byte.TYPE) {
                return new Byte(objValue);
            }
            if (objClass == (class$java$lang$Long == null ? (class$java$lang$Long = HTTPTransportBinding.class$("java.lang.Long")) : class$java$lang$Long) || objClass == Long.TYPE) {
                return new Long(objValue);
            }
            if (objClass == (class$java$lang$Float == null ? (class$java$lang$Float = HTTPTransportBinding.class$("java.lang.Float")) : class$java$lang$Float) || objClass == Float.TYPE) {
                return new Float(objValue);
            }
            if (objClass == (class$java$lang$Double == null ? (class$java$lang$Double = HTTPTransportBinding.class$("java.lang.Double")) : class$java$lang$Double) || objClass == Double.TYPE) {
                return new Double(objValue);
            }
            if (objClass == (class$java$lang$String == null ? (class$java$lang$String = HTTPTransportBinding.class$("java.lang.String")) : class$java$lang$String)) {
                return objValue;
            }
            if (objClass == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = HTTPTransportBinding.class$("java.lang.Boolean")) : class$java$lang$Boolean) || objClass == Boolean.TYPE) {
                return new Boolean(objValue);
            }
            if (objClass == (class$java$lang$Character == null ? (class$java$lang$Character = HTTPTransportBinding.class$("java.lang.Character")) : class$java$lang$Character) || objClass == Character.TYPE) {
                return new Character(objValue.charAt(0));
            }
            throw new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2139", new Object[]{objClass});
        }
        catch (NumberFormatException nfE) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2140", new Object[]{objClass, objValue, nfE.getLocalizedMessage()}, nfE);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

