/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.additions.soaphttp;

import com.sap.engine.interfaces.webservices.runtime.Config;
import com.sap.engine.interfaces.webservices.runtime.Feature;
import com.sap.engine.interfaces.webservices.runtime.MessageException;
import com.sap.engine.interfaces.webservices.runtime.PropertyDescriptor;
import com.sap.engine.interfaces.webservices.runtime.Protocol;
import com.sap.engine.interfaces.webservices.runtime.ProtocolContext;
import com.sap.engine.interfaces.webservices.runtime.ProtocolException;
import com.sap.engine.interfaces.webservices.runtime.RawMessage;
import com.sap.engine.interfaces.webservices.runtime.TransportBindingException;
import com.sap.engine.interfaces.webservices.runtime.soaphttp.HTTPTransport;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriter;
import com.sap.engine.services.webservices.additions.soaphttp.InternalSOAPMessage;
import com.sap.engine.services.webservices.additions.soaphttp.exceptions.BaseMessageException;
import com.sap.engine.services.webservices.additions.soaphttp.exceptions.BaseProtocolException;
import com.sap.engine.services.webservices.additions.soaphttp.exceptions.ProcessException;
import com.sap.engine.services.webservices.additions.soaphttp.exceptions.TBindingResourceAccessor;
import com.sap.localization.ResourceAccessor;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class HTTPStatefulProtocol
implements Protocol {
    public static final String PROTOCOL_NAME = "HTTP_StatefulProtocol";
    private static final String STATEFUL_FEATURE_NAME = "http://www.sap.com/webas/630/soap/features/session/";
    private static final String SESSION_METHOD = "SessionMethod";
    private static final String SESSION_METHOD_DEFAULT_VALUE = "httpCookies";
    private static final String SESSION_TIMEOUT = "SessionTimeout";
    private static final String MAINTAIN_SESSION_HEADER = "maintainSession";
    private static final String SOAP_SESSION_WRAPPER_ELEMENT = "Session";
    private static final String SOAP_ENABLESESSION_ELEMENT = "enableSession";
    private static final int INFINITE_SESSION_TIMEOUT = 1800;

    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    public boolean handleFault(ProtocolContext context) throws ProtocolException {
        return true;
    }

    public boolean handleRequest(ProtocolContext context) throws ProtocolException, MessageException {
        RawMessage rawMessage;
        HTTPTransport transport = (HTTPTransport)context.getRuntimeContext().getTransport();
        HttpServletRequest request = transport.getRequest();
        try {
            rawMessage = context.getRuntimeContext().getRuntimeTransportBinding().getRawMessage();
        }
        catch (TransportBindingException tbE) {
            throw new BaseProtocolException(tbE);
        }
        boolean isSessionDisabled = false;
        boolean isSOAPBodyEmpty = false;
        ArrayList headers = null;
        if (rawMessage instanceof InternalSOAPMessage) {
            InternalSOAPMessage soapMessage = (InternalSOAPMessage)rawMessage;
            headers = soapMessage.getHeaders();
            isSessionDisabled = this.isSessionDisabledHeaderAvailable(headers);
            XMLTokenReader reader = soapMessage.getReader();
            try {
                reader.next();
                reader.passChars();
            }
            catch (ParserException pE) {
                throw new BaseProtocolException(pE);
            }
            if (reader.getCurrentLevel() == 1) {
                isSOAPBodyEmpty = true;
            } else {
                try {
                    soapMessage.setBodyWrapperData(reader);
                }
                catch (ProcessException pE) {
                    throw new BaseProtocolException((Throwable)((Object)pE));
                }
            }
        } else {
            String maintSession = request.getHeader(MAINTAIN_SESSION_HEADER);
            if (maintSession != null && maintSession.equals("false")) {
                isSessionDisabled = true;
            }
        }
        if (request.getRequestedSessionId() != null && !request.isRequestedSessionIdValid()) {
            BaseMessageException mE = new BaseMessageException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2159", new Object[]{request.getRequestedSessionId()});
            try {
                context.getRuntimeContext().getRuntimeTransportBinding().createFaultMessage((Throwable)((Object)mE));
            }
            catch (TransportBindingException tbE) {
                throw new BaseProtocolException(tbE);
            }
            return false;
        }
        HttpSession httpSession = request.getSession();
        if (isSessionDisabled && isSOAPBodyEmpty) {
            context.getRuntimeContext().invalidateSession(httpSession.getId());
            httpSession.invalidate();
            InternalSOAPMessage message = new InternalSOAPMessage();
            XMLTokenWriter writer = message.initSerializationMode();
            try {
                writer.enter("http://schemas.xmlsoap.org/soap/envelope/", "Body");
                writer.leave();
                context.getRuntimeContext().getRuntimeTransportBinding().setRawMessage((RawMessage)message);
            }
            catch (Exception ioE) {
                throw new BaseProtocolException(ioE);
            }
            return false;
        }
        if (httpSession.isNew() && isSessionDisabled) {
            httpSession.invalidate();
            return true;
        }
        if (!httpSession.isNew() && isSessionDisabled) {
            throw new BaseProtocolException(new IllegalStateException("Invalidating old session with disable header"));
        }
        Feature sessionFeature = this.getFeature(context.getGlobalFeatures());
        PropertyDescriptor sessionMethodProp = sessionFeature.getConfiguration().getProperty(SESSION_METHOD);
        if (sessionMethodProp == null || !sessionMethodProp.hasValueAttrib() || !sessionMethodProp.getValue().equals(SESSION_METHOD_DEFAULT_VALUE)) {
            throw new BaseProtocolException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2106", new Object[]{SESSION_METHOD, STATEFUL_FEATURE_NAME, sessionMethodProp.hasValueAttrib() ? sessionMethodProp.getValue() : "null"});
        }
        context.getRuntimeContext().setSessionID(httpSession.getId());
        context.getRuntimeContext().setSessionTimeout(httpSession.getMaxInactiveInterval());
        return true;
    }

    public boolean handleResponse(ProtocolContext context) throws ProtocolException {
        return true;
    }

    public Config getRequiredFeatures() {
        return null;
    }

    public void init() {
    }

    private Feature getFeature(Feature[] features) throws ProtocolException {
        int i = 0;
        while (i < features.length) {
            if (features[i].getFeatureName().equals(STATEFUL_FEATURE_NAME)) {
                return features[i];
            }
            ++i;
        }
        throw new BaseProtocolException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2158", new Object[]{STATEFUL_FEATURE_NAME, "global"});
    }

    private boolean isSessionDisabledHeaderAvailable(ArrayList headers) {
        int i = 0;
        while (i < headers.size()) {
            Element enableElement;
            Node text;
            NodeList chNodes;
            Element sessionElement = (Element)headers.get(i);
            if (sessionElement.getNamespaceURI().equals(STATEFUL_FEATURE_NAME) && sessionElement.getLocalName().equals(SOAP_SESSION_WRAPPER_ELEMENT) && (chNodes = sessionElement.getElementsByTagName(SOAP_ENABLESESSION_ELEMENT)).getLength() == 1 && (text = (enableElement = (Element)chNodes.item(0)).getFirstChild()) instanceof Text && ((Text)text).getData().trim().equalsIgnoreCase("false")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

