/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.additions.soaphttp;

import com.sap.engine.interfaces.webservices.runtime.Config;
import com.sap.engine.interfaces.webservices.runtime.Fault;
import com.sap.engine.interfaces.webservices.runtime.JavaToQNameMappingRegistry;
import com.sap.engine.interfaces.webservices.runtime.JavaToQNameMappings;
import com.sap.engine.interfaces.webservices.runtime.OperationDefinition;
import com.sap.engine.interfaces.webservices.runtime.ParameterNode;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.services.webservices.additions.soaphttp.InternalSOAPMessage;
import com.sap.engine.services.webservices.additions.soaphttp.StreamEngine;
import com.sap.engine.services.webservices.additions.soaphttp.exceptions.ProcessException;
import com.sap.engine.services.webservices.additions.soaphttp.exceptions.TBindingResourceAccessor;
import com.sap.engine.services.webservices.jaxrpc.encoding.DeserializerBase;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPDeserializationContext;
import com.sap.engine.services.webservices.jaxrpc.encoding.SOAPSerializationContext;
import com.sap.engine.services.webservices.jaxrpc.encoding.SerializerBase;
import com.sap.engine.services.webservices.runtime.InstancesPool;
import com.sap.localization.ResourceAccessor;
import java.rmi.MarshalException;
import java.rmi.UnmarshalException;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class DOMEngine {
    static final String SERVER_ERROR_CODE = "Server";
    static final String CLIENT_ERROR_CODE = "Client";
    private static final String ENCODED_USE = "encoded";
    private static final String LITERAL_USE = "literal";
    private static final String RESPOINSE_WRAPPER_SUFFIX = "Response";
    private static final String RESPONSE_ELEMENT_PREFIX = "rpl";
    private static final String SERVER_ERROR_NAMESPACE = "http://sap-j2ee-engine/error";
    private static final String CLIENT_ERROR_NAMESPACE = "http://sap-j2ee-engine/client-runtime-error";
    private static final String OMIT_PART_WRAPPER = "omit-part-wrapper";
    private static InstancesPool deserializationContextPool = new InstancesPool();
    private static InstancesPool serializationContextPool = new InstancesPool();
    static /* synthetic */ Class class$java$lang$Void;

    public static final Object[] deserializeEncoded(InternalSOAPMessage soapMessage, OperationDefinition operation, Class[] mParams, TypeMappingRegistry typeMappingRegistry, JavaToQNameMappingRegistry javaToQnameMappingRegistry, ClassLoader appLoader) throws ProcessException {
        return DOMEngine.deserialize(soapMessage, operation, mParams, typeMappingRegistry, javaToQnameMappingRegistry, ENCODED_USE, appLoader);
    }

    public static final Object[] deserializeLiteral(InternalSOAPMessage soapMessage, OperationDefinition operation, Class[] mParams, TypeMappingRegistry typeMappingRegistry, JavaToQNameMappingRegistry javaToQnameMappingRegistry, ClassLoader appLoader) throws ProcessException {
        return DOMEngine.deserialize(soapMessage, operation, mParams, typeMappingRegistry, javaToQnameMappingRegistry, LITERAL_USE, appLoader);
    }

    public static Element serializeEncoded(Element body, Object returnObject, Class objectClass, OperationDefinition operation, TypeMappingRegistry typeMappingRegistry, JavaToQNameMappingRegistry javaToQNameRegistry) throws ProcessException {
        return DOMEngine.serialize(body, returnObject, objectClass, operation, typeMappingRegistry, javaToQNameRegistry, ENCODED_USE);
    }

    public static Element serializeLiteral(Element body, Object returnObject, Class objectClass, OperationDefinition operation, TypeMappingRegistry typeMappingRegistry, JavaToQNameMappingRegistry javaToQNameRegistry) throws ProcessException {
        return DOMEngine.serialize(body, returnObject, objectClass, operation, typeMappingRegistry, javaToQNameRegistry, LITERAL_USE);
    }

    public static Element serializeThrowableEncoded(Element soapBody, Throwable thr, String faultCode, Fault fault, JavaToQNameMappingRegistry javaToQnameRegistry, TypeMappingRegistry tmRegistry) throws ProcessException {
        return DOMEngine.serializeThrowable(soapBody, thr, faultCode, fault, javaToQnameRegistry, tmRegistry, ENCODED_USE);
    }

    public static Element serializeThrowableLiteral(Element soapBody, Throwable thr, String faultCode, Fault fault, JavaToQNameMappingRegistry javaToQnameRegistry, TypeMappingRegistry tmRegistry) throws ProcessException {
        return DOMEngine.serializeThrowable(soapBody, thr, faultCode, fault, javaToQnameRegistry, tmRegistry, LITERAL_USE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final Object[] deserialize(InternalSOAPMessage soapMessage, OperationDefinition operation, Class[] mParams, TypeMappingRegistry typeMappingRegistry, JavaToQNameMappingRegistry javaToQnameMappingRegistry, String use, ClassLoader appLoader) throws ProcessException {
        String omitRPWrap;
        Config inputConfig = operation.getInputConfiguration();
        String namespace = inputConfig.getProperty("namespace").getValue();
        boolean omitPartWrapper = false;
        if (inputConfig.getProperty(OMIT_PART_WRAPPER) != null && (omitRPWrap = inputConfig.getProperty(OMIT_PART_WRAPPER).getValue()) != null && omitRPWrap.equals(Boolean.TRUE.toString())) {
            omitPartWrapper = true;
        }
        Element messageBody = soapMessage.getSoapBody();
        NodeList bodyChilds = messageBody.getChildNodes();
        Element bodyWrapper = null;
        int i = 0;
        while (i < bodyChilds.getLength()) {
            if (bodyChilds.item(i).getNodeType() == 1) {
                if (bodyWrapper != null) {
                    ProcessException prExc = new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2133", new Object[]{operation.getOperationName(), namespace, new Integer(bodyChilds.getLength()), "Body"});
                    prExc.setSOAPFaultCode(CLIENT_ERROR_CODE);
                    throw prExc;
                }
                bodyWrapper = (Element)bodyChilds.item(i);
            }
            ++i;
        }
        String encodingStyle = DOMEngine.getEncodingStyle(inputConfig, use);
        TypeMapping typeMapping = DOMEngine.getTypeMapping(encodingStyle, typeMappingRegistry);
        JavaToQNameMappings javaToQNameMappings = DOMEngine.getJavaToQNameMappings(javaToQnameMappingRegistry, encodingStyle);
        SOAPDeserializationContext context = DOMEngine.getSOAPDeserializationContext(typeMapping, appLoader);
        Element[] domElements = DOM.getChildElementsAsArray((Node)bodyChilds.item(0));
        ParameterNode[] virtualParams = operation.getInputParameters();
        Object[] result = new Object[virtualParams.length];
        if (omitPartWrapper) {
            if (result.length != 1) {
                ProcessException prExc = new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2169", new Object[]{operation.getJavaOperationName(), Integer.toString(mParams.length)});
                prExc.setSOAPFaultCode(CLIENT_ERROR_CODE);
                throw prExc;
            }
            domElements = new Element[]{(Element)bodyChilds.item(0)};
        }
        Element currentElement = null;
        int i2 = 0;
        while (i2 < virtualParams.length) {
            block17: {
                ParameterNode currentParam = virtualParams[i2];
                Class currentClass = mParams[i2];
                currentElement = null;
                QName qname = javaToQNameMappings.getMappedQName(currentParam.getJavaClassName());
                if (qname == null) {
                    throw new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2119", new Object[]{currentParam.getJavaClassName(), javaToQNameMappings});
                }
                DeserializerFactory deserializerFactory = context.getTypeMapping().getDeserializer(currentClass, qname);
                if (deserializerFactory == null) {
                    throw new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2120", new Object[]{qname, context.getTypeMapping()});
                }
                DeserializerBase deserializer = (DeserializerBase)deserializerFactory.getDeserializerAs("");
                if (use.equals(LITERAL_USE)) {
                    currentElement = StreamEngine.getHeaderElement(currentParam, soapMessage.getHeaders(), namespace);
                }
                if (currentElement == null) {
                    currentElement = DOMEngine.getChildElement(domElements, currentParam.getParameterName());
                }
                try {
                    if (currentElement == null) {
                        Object obj;
                        if (currentParam.isExposed()) {
                            if (!currentParam.isOptional()) {
                                ProcessException prExc = new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2163", new Object[]{currentParam.getParameterName()});
                                prExc.setSOAPFaultCode(CLIENT_ERROR_CODE);
                                throw prExc;
                            }
                            result[i2] = obj = deserializer.deserialize(currentParam.getDefaultValue(), context, currentClass);
                            break block17;
                        } else {
                            result[i2] = obj = deserializer.deserialize(currentParam.getDefaultValue(), context, currentClass);
                        }
                        break block17;
                    }
                    result[i2] = deserializer.deserialize((Node)currentElement, context, currentClass);
                }
                catch (UnmarshalException umE) {
                    ProcessException prExc = new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2121", new Object[]{umE.getLocalizedMessage()}, umE);
                    prExc.setSOAPFaultCode(CLIENT_ERROR_CODE);
                    throw prExc;
                }
            }
            ++i2;
        }
        StreamEngine.checkForMandatoryHeaders(soapMessage.getHeaders());
        context.clearContext();
        deserializationContextPool.rollBackInstance(context);
        return result;
    }

    private static Element serialize(Element body, Object returnObject, Class objectClass, OperationDefinition operation, TypeMappingRegistry typeMappingRegistry, JavaToQNameMappingRegistry javaToQNameRegistry, String use) throws ProcessException {
        Element responseElement;
        JavaToQNameMappings javaToQNameMappings;
        SOAPSerializationContext context;
        Config outputConfig = operation.getOutputConfiguration();
        String namespace = outputConfig.getProperty("namespace").getValue();
        Element operationElement = body.getOwnerDocument().createElementNS(namespace, "rpl:" + operation.getOperationName() + RESPOINSE_WRAPPER_SUFFIX);
        body.appendChild(operationElement);
        ParameterNode[] outputNodes = operation.getOutputParameters();
        if (outputNodes == null || outputNodes.length == 0) {
            return body;
        }
        if (outputNodes.length == 1) {
            ParameterNode returnNode = outputNodes[0];
            String encodingStyle = DOMEngine.getEncodingStyle(outputConfig, use);
            if (encodingStyle != null) {
                body.setAttributeNS("", "encodingStyle", encodingStyle);
            }
            TypeMapping typeMapping = DOMEngine.getTypeMapping(encodingStyle, typeMappingRegistry);
            context = DOMEngine.getSOAPSerializationContext(typeMapping);
            javaToQNameMappings = DOMEngine.getJavaToQNameMappings(javaToQNameRegistry, encodingStyle);
            if (use.equals(LITERAL_USE)) {
                responseElement = operationElement.getOwnerDocument().createElementNS(namespace, returnNode.getParameterName());
            } else {
                responseElement = operationElement.getOwnerDocument().createElement(returnNode.getParameterName());
                context.setProperty("javax.xml.rpc.unqualified", (Object)"true");
            }
        } else {
            throw new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2127", new Object[]{new Integer(outputNodes.length)});
        }
        String originalClass = outputNodes[0].getOriginalClassName();
        DOMEngine.fillResponseElement(responseElement, returnObject, objectClass, originalClass != null ? originalClass : outputNodes[0].getJavaClassName(), context, javaToQNameMappings);
        context.clearContext();
        serializationContextPool.rollBackInstance(context);
        return body;
    }

    private static Element serializeThrowable(Element soapBody, Throwable thr, String faultCode, Fault fault, JavaToQNameMappingRegistry javaToQnameRegistry, TypeMappingRegistry tmRegistry, String use) throws ProcessException {
        Element detailContentElement;
        Element faultEl = soapBody.getOwnerDocument().createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:Fault");
        soapBody.appendChild(faultEl);
        Element faultCodeElement = faultEl.getOwnerDocument().createElement("faultcode");
        faultEl.appendChild(faultCodeElement);
        Text faultCodeTextNode = faultCodeElement.getOwnerDocument().createTextNode("SOAP-ENV:" + faultCode);
        faultCodeElement.appendChild(faultCodeTextNode);
        Element faultStringElement = faultEl.getOwnerDocument().createElement("faultstring");
        faultEl.appendChild(faultStringElement);
        Text faultStringTextNode = faultStringElement.getOwnerDocument().createTextNode(thr.getLocalizedMessage());
        faultStringElement.appendChild(faultStringTextNode);
        Element detail = faultEl.getOwnerDocument().createElement("detail");
        faultEl.appendChild(detail);
        if (fault != null) {
            Config config = fault.getFaultConfiguration();
            String namespace = config.getProperty("namespace").getValue();
            detailContentElement = detail.getOwnerDocument().createElementNS(namespace, "err:" + fault.getFaultName());
            String encodingStyle = DOMEngine.getEncodingStyle(config, use);
            if (encodingStyle != null) {
                soapBody.setAttributeNS("", "encodingStyle", encodingStyle);
            }
            TypeMapping typeMapping = DOMEngine.getTypeMapping(encodingStyle, tmRegistry);
            SOAPSerializationContext context = DOMEngine.getSOAPSerializationContext(typeMapping);
            JavaToQNameMappings javaToQNameMappings = DOMEngine.getJavaToQNameMappings(javaToQnameRegistry, encodingStyle);
            DOMEngine.fillResponseElement(detailContentElement, thr, thr.getClass(), fault.getJavaClassName(), context, javaToQNameMappings);
        } else if (faultCode.equals(CLIENT_ERROR_CODE)) {
            detailContentElement = detail.getOwnerDocument().createElementNS(CLIENT_ERROR_NAMESPACE, "err:" + thr.getClass().getName());
            Text textNode = detailContentElement.getOwnerDocument().createTextNode(DOMEngine.getExceptionStackTrace(thr));
            detailContentElement.appendChild(textNode);
        } else {
            detailContentElement = detail.getOwnerDocument().createElementNS(SERVER_ERROR_NAMESPACE, "err:" + thr.getClass().getName());
            Text textNode = detailContentElement.getOwnerDocument().createTextNode(DOMEngine.getExceptionStackTrace(thr));
            detailContentElement.appendChild(textNode);
        }
        detail.appendChild(detailContentElement);
        return faultEl;
    }

    private static void fillResponseElement(Element responseElement, Object returnObject, Class objectClass, String javaClassName, SOAPSerializationContext context, JavaToQNameMappings javaToQNameMappings) throws ProcessException {
        SerializerFactory serializerFactory;
        if (objectClass == (class$java$lang$Void == null ? (class$java$lang$Void = DOMEngine.class$("java.lang.Void")) : class$java$lang$Void)) {
            return;
        }
        QName qname = javaToQNameMappings.getMappedQName(javaClassName);
        if (qname == null) {
            throw new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2119", new Object[]{javaClassName, javaToQNameMappings});
        }
        if (returnObject != null) {
            objectClass = returnObject.getClass();
        }
        if ((serializerFactory = context.getTypeMapping().getSerializer(objectClass, qname)) == null) {
            throw new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2123", new Object[]{qname, context.getTypeMapping()});
        }
        SerializerBase serializer = (SerializerBase)serializerFactory.getSerializerAs("");
        try {
            serializer.serialize(returnObject, (Node)responseElement, context);
        }
        catch (MarshalException mE) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2124", new Object[]{returnObject, mE.getLocalizedMessage()}, mE);
        }
    }

    private static String getEncodingStyle(Config config, String useValue) throws ProcessException {
        if (useValue.equals(LITERAL_USE)) {
            return null;
        }
        String encodingStyle = config.getProperty("encodingStyle").getValue();
        if (encodingStyle == null) {
            throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2131");
        }
        return encodingStyle;
    }

    private static TypeMapping getTypeMapping(String encodingStyle, TypeMappingRegistry typeMappingRegistry) throws ProcessException {
        if (encodingStyle == null) {
            return typeMappingRegistry.getDefaultTypeMapping();
        }
        TypeMapping typeMapping = typeMappingRegistry.getTypeMapping(encodingStyle);
        if (typeMapping == null) {
            throw new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2126", new Object[]{encodingStyle});
        }
        return typeMapping;
    }

    private static JavaToQNameMappings getJavaToQNameMappings(JavaToQNameMappingRegistry registry, String encodingStyle) {
        if (encodingStyle == null) {
            return registry.getLiteralMappings();
        }
        return registry.getEncodedMappings();
    }

    private static SOAPDeserializationContext getSOAPDeserializationContext(TypeMapping typeMapping, ClassLoader appLoader) {
        SOAPDeserializationContext context = (SOAPDeserializationContext)deserializationContextPool.getInstance();
        if (context == null) {
            context = new SOAPDeserializationContext();
        }
        context.setTypeMapping(typeMapping);
        context.setApplicationClassLoader(appLoader);
        return context;
    }

    private static SOAPSerializationContext getSOAPSerializationContext(TypeMapping typeMapping) {
        SOAPSerializationContext context = (SOAPSerializationContext)serializationContextPool.getInstance();
        if (context == null) {
            context = new SOAPSerializationContext();
        }
        context.setTypeMapping(typeMapping);
        return context;
    }

    private static final String getExceptionStackTrace(Throwable thr) {
        return thr.getLocalizedMessage();
    }

    private static Element getChildElement(Element[] elements, String localName) {
        int i = 0;
        while (i < elements.length) {
            if (elements[i].getLocalName().equals(localName)) {
                return elements[i];
            }
            ++i;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

