/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.additions.soaphttp;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParameterList;

public class ContentTypeInner {
    static final String DELIMITER = ";";
    private String baseType;
    private String subType;
    private String primaryType;
    private Hashtable parameters = new Hashtable();

    ContentTypeInner(String value) {
        this.init(value);
    }

    private void init(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Content-type value could not be null.");
        }
        if ((value = value.trim()).indexOf(DELIMITER) == -1) {
            this.baseType = value;
            int del = this.baseType.indexOf("/");
            if (del == -1) {
                throw new IllegalArgumentException("Incorrect value: '" + value + "'");
            }
            this.primaryType = value.substring(0, del);
            this.subType = value.substring(del + 1);
            return;
        }
        StringTokenizer tonenizer = new StringTokenizer(value, DELIMITER);
        while (tonenizer.hasMoreTokens()) {
            String next = tonenizer.nextToken();
            if (this.baseType == null) {
                this.init(next);
                continue;
            }
            int del = next.indexOf("=");
            if (del != -1) {
                String parameter = next.substring(0, del);
                String pValue = next.substring(del + 1);
                if (pValue.startsWith("\"") && pValue.endsWith("\"")) {
                    pValue = pValue.substring(1, pValue.length() - 1);
                }
                this.parameters.put(parameter, pValue);
                continue;
            }
            throw new IllegalArgumentException("Incorrect value: " + value + "'");
        }
    }

    public String getBaseType() {
        return this.baseType;
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getParameter(String name) {
        return (String)this.parameters.get(name);
    }

    public ContentType createStandardType() {
        ParameterList list = new ParameterList();
        Enumeration en = this.parameters.keys();
        while (en.hasMoreElements()) {
            String next = (String)en.nextElement();
            list.set(next, (String)this.parameters.get(next));
        }
        return new ContentType(this.getPrimaryType(), this.getSubType(), list);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.baseType);
        Enumeration en = this.parameters.keys();
        while (en.hasMoreElements()) {
            String current = (String)en.nextElement();
            buffer.append("; ");
            buffer.append(current + "=");
            buffer.append("\"" + (String)this.parameters.get(current) + "\"");
        }
        return buffer.toString();
    }
}

