/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.additions.soaphttp;

import com.sap.engine.interfaces.webservices.runtime.Config;
import com.sap.engine.interfaces.webservices.runtime.Fault;
import com.sap.engine.interfaces.webservices.runtime.Feature;
import com.sap.engine.interfaces.webservices.runtime.JavaToQNameMappingRegistry;
import com.sap.engine.interfaces.webservices.runtime.Key;
import com.sap.engine.interfaces.webservices.runtime.OperationDefinition;
import com.sap.engine.interfaces.webservices.runtime.ParameterNode;
import com.sap.engine.interfaces.webservices.runtime.PortTypeDescriptor;
import com.sap.engine.interfaces.webservices.runtime.RawMessage;
import com.sap.engine.interfaces.webservices.runtime.RuntimeContext;
import com.sap.engine.interfaces.webservices.runtime.Transport;
import com.sap.engine.interfaces.webservices.runtime.TransportBindingException;
import com.sap.engine.lib.xml.parser.handlers.SimpleAttr;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.services.webservices.additions.soaphttp.SOAPHTTPConfigProperties;
import com.sap.engine.services.webservices.additions.soaphttp.exceptions.ConfigurationException;
import com.sap.engine.services.webservices.additions.soaphttp.exceptions.ProcessException;
import com.sap.engine.services.webservices.additions.soaphttp.exceptions.TBindingResourceAccessor;
import com.sap.engine.services.webservices.runtime.interfaces.RuntimeTransportBinding;
import com.sap.engine.services.webservices.runtime.wsdl.BaseWSDLComponentGenerator;
import com.sap.engine.services.webservices.wsdl.WSDLBinding;
import com.sap.engine.services.webservices.wsdl.WSDLBindingChannel;
import com.sap.engine.services.webservices.wsdl.WSDLBindingFault;
import com.sap.engine.services.webservices.wsdl.WSDLBindingOperation;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLDocumentation;
import com.sap.engine.services.webservices.wsdl.WSDLException;
import com.sap.engine.services.webservices.wsdl.WSDLExtension;
import com.sap.localization.ResourceAccessor;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.TypeMappingRegistry;

public abstract class AbstractSOAPTransportBinding
implements RuntimeTransportBinding,
SOAPHTTPConfigProperties {
    protected static final String HTTPTRANSPORT_URI = "http://schemas.xmlsoap.org/soap/http";
    protected static final String SOAP_URI = "http://schemas.xmlsoap.org/wsdl/soap/";
    protected static final String TRANSPORT = "transport";
    protected static final String BINDING = "binding";
    protected static final String OUT_HEADERSMESSAGE_SUFFIX = "OutHeaders";
    protected static final String IN_HEADERSMESSAGE_SUFFIX = "InHeaders";
    protected static final String HEADER_SCHEMAURI_PREFIX = "hs";
    protected static final String DOCUMENT_WSDL_STYLE = "document";
    protected static final String RPC_WSDL_STYLE = "rpc";
    protected static final String RPC_ENCODED_WSDL_STYLE = "rpc_enc";
    static final String SOAPHEADERS_PROP = "soap-headers";
    static final String WSI_CONFORMANCE_CLAIM_DOCUMENTATION = "<wsi:Claim conformsTo=\"http://ws-i.org/profiles/basic/1.0\" xmlns:wsi=\"http://ws-i.org/schemas/conformanceClaim/\"/>";
    public static final String ONE_WAY_OPERATION_FEATURE = "http://www.sap.com/webas/630/soap/features/mep/one-way";

    public String[] getSupportedSyles() {
        return new String[]{RPC_WSDL_STYLE, DOCUMENT_WSDL_STYLE, RPC_ENCODED_WSDL_STYLE};
    }

    public int[] getNecessaryPortTypes() {
        return new int[]{4, 1, 2};
    }

    public String[] getDefaultStyles() {
        return new String[]{DOCUMENT_WSDL_STYLE};
    }

    private String getPortTypeNSPrefix(WSDLDefinitions def, String ns) {
        Hashtable table = def.getAdditionalAttributes();
        Enumeration keys = table.keys();
        while (keys.hasMoreElements()) {
            String value;
            String temp = (String)keys.nextElement();
            if (!temp.startsWith("xmlns:") || !(value = (String)table.get(temp)).equals(ns)) continue;
            return temp.substring("xmlns:".length());
        }
        def.addAdditionalAttribute("xmlns:ptns", ns);
        return "ptns";
    }

    public void generateBinding(String style, QName bindingQName, Config globalConfig, OperationDefinition[] operations, PortTypeDescriptor[] descriptors, WSDLDefinitions definitions) throws TransportBindingException {
        String bindingName = bindingQName.getLocalPart();
        if (style == null) {
            throw new ConfigurationException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2100", new Object[]{style});
        }
        WSDLBinding binding = new WSDLBinding();
        binding.setName(bindingName);
        WSDLExtension bindingExtension = new WSDLExtension();
        bindingExtension.setLocalName(BINDING);
        bindingExtension.setURI(SOAP_URI);
        bindingExtension.setAttribute(new SimpleAttr(TRANSPORT, HTTPTRANSPORT_URI, ""));
        binding.addExtension(bindingExtension);
        int i = 0;
        while (i < descriptors.length) {
            String portTypePrefix = this.getPortTypeNSPrefix(definitions, descriptors[i].getQName().getNamespaceURI());
            if (style.equals(DOCUMENT_WSDL_STYLE) && descriptors[i].getType() == 1) {
                binding.setType(new com.sap.engine.lib.xml.util.QName(portTypePrefix, descriptors[i].getQName().getLocalPart(), descriptors[i].getQName().getNamespaceURI()));
                bindingExtension.setAttribute(new SimpleAttr("style", DOCUMENT_WSDL_STYLE, ""));
                this.generateBindingOperations(definitions, binding, operations, DOCUMENT_WSDL_STYLE, portTypePrefix);
                return;
            }
            if (style.equals(RPC_ENCODED_WSDL_STYLE) && descriptors[i].getType() == 2) {
                binding.setType(new com.sap.engine.lib.xml.util.QName(portTypePrefix, descriptors[i].getQName().getLocalPart(), descriptors[i].getQName().getNamespaceURI()));
                bindingExtension.setAttribute(new SimpleAttr("style", RPC_WSDL_STYLE, ""));
                this.generateBindingOperations(definitions, binding, operations, RPC_ENCODED_WSDL_STYLE, portTypePrefix);
                return;
            }
            if (style.equals(RPC_WSDL_STYLE) && descriptors[i].getType() == 4) {
                binding.setType(new com.sap.engine.lib.xml.util.QName(portTypePrefix, descriptors[i].getQName().getLocalPart(), descriptors[i].getQName().getNamespaceURI()));
                bindingExtension.setAttribute(new SimpleAttr("style", RPC_WSDL_STYLE, ""));
                this.generateBindingOperations(definitions, binding, operations, RPC_WSDL_STYLE, portTypePrefix);
                return;
            }
            ++i;
        }
    }

    private void generateBindingOperations(WSDLDefinitions definitions, WSDLBinding binding, OperationDefinition[] operations, String style, String portTypePrefix) throws ConfigurationException, ProcessException {
        block43: {
            try {
                if (style.equals(DOCUMENT_WSDL_STYLE) || style.equals(RPC_WSDL_STYLE)) {
                    int i = 0;
                    while (i < operations.length) {
                        String namespace;
                        WSDLBindingChannel channel;
                        String soapActionDescr;
                        WSDLBindingOperation tempBindingOperation = new WSDLBindingOperation();
                        binding.addOperation(tempBindingOperation);
                        tempBindingOperation.setName(operations[i].getOperationName());
                        if (operations[i].getDescription() != null) {
                            WSDLDocumentation documentation = new WSDLDocumentation();
                            documentation.setContent(new CharArray(operations[i].getDescription()));
                            tempBindingOperation.setDocumentation(documentation);
                        }
                        WSDLExtension extension = new WSDLExtension();
                        extension.setLocalName("operation");
                        extension.setURI(SOAP_URI);
                        try {
                            soapActionDescr = operations[i].getInputConfiguration().getProperty("soapAction").getValue();
                        }
                        catch (NullPointerException nE) {
                            soapActionDescr = "";
                        }
                        extension.setAttribute(new SimpleAttr("soapAction", soapActionDescr, ""));
                        tempBindingOperation.addExtension(extension);
                        if (style.equals(DOCUMENT_WSDL_STYLE)) {
                            channel = BaseWSDLComponentGenerator.generateSOAPLiteralChannel("parameters");
                        } else {
                            try {
                                namespace = operations[i].getInputConfiguration().getProperty("namespace").getValue();
                                if (namespace == null) {
                                    throw new NullPointerException();
                                }
                                channel = BaseWSDLComponentGenerator.generateSOAPLiteralChannel(namespace, operations[i].getInputParameters());
                            }
                            catch (NullPointerException e) {
                                throw new ConfigurationException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2101", new Object[]{operations[i].getOperationName(), "namespace", "input"});
                            }
                        }
                        channel = this.addHeadersInChannel(channel, portTypePrefix + ":" + this.getInputMessage(operations[i].getOperationName(), style.equals(DOCUMENT_WSDL_STYLE)), operations[i]);
                        tempBindingOperation.setInput(channel);
                        if (!AbstractSOAPTransportBinding.isOneWay(operations[i])) {
                            if (style.equals(DOCUMENT_WSDL_STYLE)) {
                                channel = BaseWSDLComponentGenerator.generateSOAPLiteralChannel(null);
                            } else {
                                try {
                                    namespace = operations[i].getOutputConfiguration().getProperty("namespace").getValue();
                                    if (namespace == null) {
                                        throw new NullPointerException();
                                    }
                                    channel = BaseWSDLComponentGenerator.generateSOAPLiteralChannel(namespace, null);
                                }
                                catch (NullPointerException e) {
                                    throw new ConfigurationException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2101", new Object[]{operations[i].getOperationName(), "output", "namespace"});
                                }
                            }
                            tempBindingOperation.setOutput(channel);
                            Fault[] faults = operations[i].getFaults();
                            int k = 0;
                            while (k < faults.length) {
                                tempBindingOperation.addFault(BaseWSDLComponentGenerator.generateBindingFault(faults[k].getFaultName(), "literal", null));
                                ++k;
                            }
                        }
                        ++i;
                    }
                    definitions.addBinding(binding);
                    break block43;
                }
                if (style.equals(RPC_ENCODED_WSDL_STYLE)) {
                    int i = 0;
                    while (i < operations.length) {
                        if (!this.isOperationWithHeaders(operations[i])) {
                            String soapActionProp;
                            WSDLBindingOperation tempBindingOperation = new WSDLBindingOperation();
                            binding.addOperation(tempBindingOperation);
                            tempBindingOperation.setName(operations[i].getOperationName());
                            if (operations[i].getDescription() != null) {
                                WSDLDocumentation documentation = new WSDLDocumentation();
                                documentation.setContent(new CharArray(operations[i].getDescription()));
                                tempBindingOperation.setDocumentation(documentation);
                            }
                            WSDLExtension extension = new WSDLExtension();
                            extension.setLocalName("operation");
                            extension.setURI(SOAP_URI);
                            try {
                                soapActionProp = operations[i].getInputConfiguration().getProperty("soapAction").getValue();
                            }
                            catch (NullPointerException nE) {
                                soapActionProp = "";
                            }
                            extension.setAttribute(new SimpleAttr("soapAction", soapActionProp, ""));
                            tempBindingOperation.addExtension(extension);
                            String namespace = null;
                            String encodingStyle = null;
                            try {
                                namespace = operations[i].getInputConfiguration().getProperty("namespace").getValue();
                                if (namespace == null) {
                                    throw new NullPointerException();
                                }
                            }
                            catch (NullPointerException nE) {
                                throw new ConfigurationException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2101", new Object[]{operations[i].getOperationName(), "input", "namespace"});
                            }
                            try {
                                encodingStyle = operations[i].getInputConfiguration().getProperty("encodingStyle").getValue();
                                if (encodingStyle == null) {
                                    throw new NullPointerException();
                                }
                            }
                            catch (NullPointerException nE) {
                                throw new ConfigurationException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2101", new Object[]{operations[i].getOperationName(), "input", "encodingStyle"});
                            }
                            WSDLBindingChannel channel = BaseWSDLComponentGenerator.generateSOAPEncodedChannel(namespace, encodingStyle);
                            tempBindingOperation.setInput(channel);
                            try {
                                namespace = operations[i].getInputConfiguration().getProperty("namespace").getValue();
                                if (namespace == null) {
                                    throw new NullPointerException();
                                }
                            }
                            catch (NullPointerException nE) {
                                throw new ConfigurationException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2101", new Object[]{operations[i].getOperationName(), "output", "namespace"});
                            }
                            try {
                                encodingStyle = operations[i].getInputConfiguration().getProperty("encodingStyle").getValue();
                                if (encodingStyle == null) {
                                    throw new NullPointerException();
                                }
                            }
                            catch (NullPointerException nE) {
                                throw new ConfigurationException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2101", new Object[]{operations[i].getOperationName(), "output", "encodingStyle"});
                            }
                            if (!AbstractSOAPTransportBinding.isOneWay(operations[i])) {
                                channel = BaseWSDLComponentGenerator.generateSOAPEncodedChannel(namespace, encodingStyle);
                                tempBindingOperation.setOutput(channel);
                                Fault[] faults = operations[i].getFaults();
                                int k = 0;
                                while (k < faults.length) {
                                    try {
                                        encodingStyle = faults[k].getFaultConfiguration().getProperty("encodingStyle").getValue();
                                    }
                                    catch (NullPointerException nE) {
                                        throw new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2101", new Object[]{faults[k].getFaultName() + "of " + operations[i].getOperationName(), "encodingStyle", "fault"});
                                    }
                                    try {
                                        namespace = faults[k].getFaultConfiguration().getProperty("namespace").getValue();
                                    }
                                    catch (NullPointerException nE) {
                                        throw new ProcessException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2101", new Object[]{faults[k].getFaultName() + "of " + operations[i].getOperationName(), "namespace", "fault"});
                                    }
                                    WSDLBindingFault wsdlBFault = BaseWSDLComponentGenerator.generateBindingFault(faults[k].getFaultName(), "encoded", encodingStyle);
                                    ((WSDLExtension)wsdlBFault.getExtensions().get(0)).setAttribute("namespace", namespace, "");
                                    tempBindingOperation.addFault(wsdlBFault);
                                    ++k;
                                }
                            }
                        }
                        ++i;
                    }
                    definitions.addBinding(binding);
                    break block43;
                }
                throw new ConfigurationException((ResourceAccessor)TBindingResourceAccessor.getResourceAccessor(), "webservices_2100", new Object[]{style});
            }
            catch (WSDLException wsdlE) {
                throw new ProcessException(TBindingResourceAccessor.getResourceAccessor(), "webservices_2102", new Object[]{binding.getName(), wsdlE.getLocalizedMessage()}, wsdlE);
            }
        }
    }

    private WSDLBindingChannel addHeadersInChannel(WSDLBindingChannel channel, String messageQName, OperationDefinition operation) {
        ParameterNode[] inputParams = operation.getInputParameters();
        int i = 0;
        while (i < inputParams.length) {
            if (inputParams[i].isExposed() && inputParams[i].isHeader()) {
                channel.addExtension(BaseWSDLComponentGenerator.generateSOAPHeaderLiteralBindingExtension(messageQName, inputParams[i].getParameterName() + "_" + i));
            }
            ++i;
        }
        return channel;
    }

    private String getInputMessage(String operationName, boolean isDocument) {
        String res = operationName + "In";
        if (isDocument) {
            res = res + "_doc";
        }
        return res;
    }

    private WSDLDocumentation getWSIDocumentation() {
        WSDLDocumentation doc = new WSDLDocumentation();
        doc.setContent(new CharArray(WSI_CONFORMANCE_CLAIM_DOCUMENTATION));
        return doc;
    }

    static boolean isOneWay(OperationDefinition opD) {
        Feature[] fs = opD.getFeatures();
        if (fs != null) {
            int i = 0;
            while (i < fs.length) {
                if (fs[i].getFeatureName().equals(ONE_WAY_OPERATION_FEATURE)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    boolean isOperationWithHeaders(OperationDefinition opD) {
        ParameterNode[] params = opD.getInputParameters();
        int i = 0;
        while (i < params.length) {
            if (params[i].isHeader() && params[i].isExposed()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public abstract void clearState() throws TransportBindingException;

    public abstract void sendServerError(Throwable var1) throws TransportBindingException;

    public abstract void sendResponse() throws TransportBindingException;

    public abstract Key[] getOperationKeys(OperationDefinition var1) throws TransportBindingException;

    public abstract RawMessage createFaultMessage(Throwable var1) throws TransportBindingException;

    public abstract RawMessage createResponseMessage(Object var1, Class var2, Object[] var3, Class[] var4) throws TransportBindingException;

    public abstract Object[] getParameters(Class[] var1, ClassLoader var2) throws TransportBindingException;

    public abstract void setRuntimeContext(RuntimeContext var1) throws TransportBindingException;

    public abstract void setVirtualOperation(OperationDefinition var1) throws TransportBindingException;

    public abstract void setGlobalConfiguration(Config var1) throws TransportBindingException;

    public abstract void setTransport(Transport var1) throws TransportBindingException;

    public abstract void setRawMessage(RawMessage var1) throws TransportBindingException;

    public abstract Key[] getMessageKeys() throws TransportBindingException;

    public abstract void setMappingRegistries(JavaToQNameMappingRegistry var1, TypeMappingRegistry var2) throws TransportBindingException;

    public abstract RawMessage getRawMessage() throws TransportBindingException;
}

