/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.additions.client.messageid;

import com.sap.engine.interfaces.webservices.client.ClientFeatureProvider;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.AbstractMessage;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientProtocolException;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.PropertyContext;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.features.MessageIdFeature;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.ClientMimeMessage;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.ClientSOAPMessage;
import com.sap.guid.GUIDGeneratorFactory;
import com.sap.guid.IGUID;
import com.sap.guid.IGUIDGenerator;
import com.sap.guid.IGUIDGeneratorFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class MessageIdProtocol
implements MessageIdFeature {
    public static final String NAME = "MessageIdProtocol";
    public static final String HEADER_NAME = "messageId";
    public static final String HEADER_NAMESPACE = "http://www.sap.com/webas/640/soap/features/messageId/";
    public static final String PREFIX = "uuid:";
    private IGUIDGeneratorFactory factory = GUIDGeneratorFactory.getInstance();
    private IGUIDGenerator generator = this.factory.createGUIDGenerator();
    private IGUID guid = null;

    public void init(PropertyContext context) throws ClientProtocolException {
    }

    public boolean handleRequest(AbstractMessage message, PropertyContext context) throws ClientProtocolException {
        PropertyContext features;
        PropertyContext feature;
        ClientSOAPMessage msg = null;
        if (message instanceof ClientMimeMessage) {
            msg = ((ClientMimeMessage)message).getSOAPMessage();
        }
        if (message instanceof ClientSOAPMessage) {
            msg = (ClientSOAPMessage)message;
        }
        if (msg != null && (feature = (features = context.getSubContext("featureConfig")).getSubContext(HEADER_NAMESPACE)).isDefined()) {
            this.guid = this.generator.createGUID();
            try {
                Element header = msg.createSoapHeader(HEADER_NAMESPACE, HEADER_NAME);
                Text content = header.getOwnerDocument().createTextNode(PREFIX + this.guid.toString());
                header.appendChild(content);
                msg.getHeaders().add(header);
            }
            catch (Exception e) {
                throw new ClientProtocolException("Unable to add message id header.");
            }
        }
        return true;
    }

    public boolean handleResponse(AbstractMessage message, PropertyContext context) throws ClientProtocolException {
        return true;
    }

    public boolean handleFault(AbstractMessage message, PropertyContext context) throws ClientProtocolException {
        return true;
    }

    public boolean isFeatureImplemented(String featureName, PropertyContext property) {
        return HEADER_NAMESPACE.equals(featureName);
    }

    public String getName() {
        return NAME;
    }

    public String[] getFeatures() {
        return new String[]{HEADER_NAMESPACE};
    }

    public ClientFeatureProvider newInstance() {
        try {
            return new MessageIdProtocol();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getMessageId() {
        if (this.guid != null) {
            return PREFIX + this.guid.toString();
        }
        return null;
    }
}

