/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.applocking.test;

import com.sap.engine.services.applocking.LogicalLocking;
import com.sap.engine.services.applocking.test.BaseLogicalLockingTest;
import com.sap.engine.services.locking.test.TestResult;
import java.util.Properties;

public class LifetimeUserSessionTest
extends BaseLogicalLockingTest {
    public String user;
    public String password;

    public String getName() {
        return "LogicalLocking: Create locks for the usersession-lifetime";
    }

    public String getDescription() {
        return "1) Creates locks of all modes in a newly created user-session\n2) Ends the user-session and check if locks were removed\n\nATTENTION: In order to run this test you have to configure a TestUser\nand a TestUserPassword property in the applocking service. You then\nneed to create a user via the security provider service for the specified values.";
    }

    protected void test(Properties properties, TestResult logging, LogicalLocking locking) throws Exception {
        this.user = properties.getProperty("TestUser");
        this.password = properties.getProperty("TestUserPassword");
        if (this.user == null || this.password == null) {
            logging.log((Object)"Test can not be executed since there are no credentials assigned.");
            return;
        }
        String name1 = "X$$_TESTNAME_$$name1";
        String argument1 = "$$_TESTARGUMENT_$$argument1";
        String argument2 = "$$_TESTARGUMENT_$$argument2";
        String argument3 = "$$_TESTARGUMENT_$$argument3";
        logging.log((Object)"Login");
        this.login(this.user, this.password);
        logging.log((Object)"Create several locks of all types");
        locking.lock((byte)2, name1, argument1, 'S');
        locking.lock((byte)2, name1, argument1, 'S');
        locking.lock((byte)2, name1, argument1, 'S');
        locking.lock((byte)2, name1, argument2, 'E');
        locking.lock((byte)2, name1, argument2, 'E');
        locking.lock((byte)2, name1, argument2, 'E');
        locking.lock((byte)2, name1, argument3, 'X');
        logging.log((Object)"Create several conflicting locks -> expect exception");
        this.lockExpectException(locking, (byte)2, name1, argument1, 'X');
        this.lockExpectException(locking, (byte)2, name1, argument2, 'X');
        this.lockExpectException(locking, (byte)2, name1, argument3, 'X');
        logging.log((Object)"Logout");
        this.logout();
        logging.log((Object)"");
        logging.log((Object)"Login");
        this.login(this.user, this.password);
        logging.log((Object)"Create several previously conflicting locks");
        locking.lock((byte)2, name1, argument1, 'X');
        locking.lock((byte)2, name1, argument2, 'X');
        locking.lock((byte)2, name1, argument3, 'X');
        this.cleanupLocks(logging, locking);
        logging.log((Object)"Create several locks of all types");
        locking.lock((byte)2, name1, argument1, 'S');
        locking.lock((byte)2, name1, argument1, 'S');
        locking.lock((byte)2, name1, argument1, 'S');
        locking.lock((byte)2, name1, argument2, 'E');
        locking.lock((byte)2, name1, argument2, 'E');
        locking.lock((byte)2, name1, argument2, 'E');
        locking.lock((byte)2, name1, argument3, 'X');
        logging.log((Object)"Create several conflicting locks -> expect exception");
        this.lockExpectException(locking, (byte)2, name1, argument1, 'X');
        this.lockExpectException(locking, (byte)2, name1, argument2, 'X');
        this.lockExpectException(locking, (byte)2, name1, argument3, 'X');
    }

    private void cleanupLocks(TestResult logging, LogicalLocking locking) throws Exception {
        logging.log((Object)"Remove all locks");
        locking.unlockAll((byte)2, false);
        logging.log((Object)"");
    }
}

