/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.applocking.test;

import com.sap.engine.frame.core.locking.LockEntry;
import com.sap.engine.frame.core.locking.LockException;
import com.sap.engine.frame.core.locking.LockingContext;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.frame.core.locking.Util;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.lib.util.concurrent.CountDown;
import com.sap.engine.services.applocking.LogicalLocking;
import com.sap.engine.services.applocking.LogicalLockingFactory;
import com.sap.engine.services.applocking.test.ILogicalLockingTest;
import com.sap.engine.services.locking.test.TestResult;
import java.util.Properties;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginContext;
import javax.transaction.TransactionManager;

public abstract class BaseLogicalLockingTest
implements ILogicalLockingTest,
Runnable,
CallbackHandler {
    protected static final Util UTIL = new Util();
    private SecurityContext _securityContext;
    private LogicalLocking _locking;
    private TransactionManager _transactionManager;
    private Properties _properties;
    private TestResult _result;
    private CountDown _countDown;
    private Exception _exceptionInsideThread;
    private String _callbackName;
    private char[] _callbackPassword;
    private Vector _allOwners;
    private LoginContext _lastLoginContext;

    protected abstract void test(Properties var1, TestResult var2, LogicalLocking var3) throws Exception;

    /*
     * Unable to fully structure code
     */
    public TestResult start(LockingContext lockingContext, ThreadSystem threadSystem, SecurityContext securityContext, LogicalLockingFactory lockingFactory, TransactionManager transactionManager, Properties properties) {
        this._securityContext = securityContext;
        this._transactionManager = transactionManager;
        this._properties = properties;
        this._result = new TestResult();
        this._countDown = new CountDown(1);
        this._exceptionInsideThread = null;
        this._allOwners = new Vector<E>();
        try {
            block9: {
                this._result.log((Object)("START TEST " + this.getName()));
                this._result.log((Object)"-------------------------------------------------------");
                this._result.log((Object)"DESCRIPTION:");
                this._result.log((Object)this.getDescription());
                this._result.log((Object)"-------------------------------------------------------");
                try {
                    this._locking = lockingFactory.createLogicalLocking("X$$_TESTNAME_$$", "Internal tests of the locking");
                    threadSystem.startThread((Runnable)this, false);
                    this._countDown.acquire();
                    if (this._exceptionInsideThread != null) {
                        throw this._exceptionInsideThread;
                    }
                    var8_7 = null;
                    success = true;
                    allOwners = this._allOwners.toArray(new String[this._allOwners.size()]);
                    i = 0;
                    ** while (i < allOwners.length)
                }
                catch (Throwable var7_15) {
                    var8_8 = null;
                    success = true;
                    allOwners = this._allOwners.toArray(new String[this._allOwners.size()]);
                    i = 0;
                    ** while (i < allOwners.length)
                }
lbl-1000:
                // 1 sources

                {
                    success &= this.cleanupOwner(lockingContext, this._result, allOwners[i]);
                    ++i;
                    continue;
                }
lbl28:
                // 1 sources

                if (!success) {
                    throw new TechnicalLockException("Cleaning up after the test not successful.\nThe administrator must remove all locks for the following owners manually:\n{1}", new Object[]{allOwners});
                }
                break block9;
lbl-1000:
                // 1 sources

                {
                    success &= this.cleanupOwner(lockingContext, this._result, allOwners[i]);
                    ++i;
                    continue;
                }
lbl41:
                // 1 sources

                if (!success) {
                    throw new TechnicalLockException("Cleaning up after the test not successful.\nThe administrator must remove all locks for the following owners manually:\n{1}", new Object[]{allOwners});
                }
                throw var7_15;
            }
            this._result.close(null);
        }
        catch (Exception e) {
            this._result.close(e);
        }
        return this._result;
    }

    public String toString() {
        return this.getName();
    }

    /*
     * Loose catch block
     */
    public void run() {
        block14: {
            this.test(this._properties, this._result, this._locking);
            Object var3_1 = null;
            this._countDown.release();
            try {
                this.endTransaction(false);
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                this.logout();
            }
            catch (Exception e2) {}
            break block14;
            {
                catch (Exception e) {
                    this._exceptionInsideThread = e;
                    Object var3_2 = null;
                    this._countDown.release();
                    try {
                        this.endTransaction(false);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        this.logout();
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this._countDown.release();
                try {
                    this.endTransaction(false);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    this.logout();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private boolean cleanupOwner(LockingContext lockingContext, TestResult logging, String owner) {
        try {
            lockingContext.getAdministrativeLocking().unlockAll(owner, false);
            return true;
        }
        catch (Exception e) {
            logging.log((Object)"-------------------------------------------------------");
            logging.log((Object)"CRITICAL ERROR: CLEANUP FAILED");
            logging.log((Object)"SOME OF THE CREATED LOCKS COULD NOT BE REMOVED");
            logging.log((Object)("OWNER = [" + owner + "]"));
            logging.log((Object)"-------------------------------------------------------");
            return false;
        }
    }

    public void handle(Callback[] callbacks) {
        int i = 0;
        while (i < callbacks.length) {
            if (callbacks[i] instanceof NameCallback) {
                ((NameCallback)callbacks[i]).setName(this._callbackName);
            } else if (callbacks[i] instanceof PasswordCallback) {
                ((PasswordCallback)callbacks[i]).setPassword(this._callbackPassword);
            }
            ++i;
        }
    }

    protected void login(String name, String password) throws Exception {
        this._callbackName = name;
        this._callbackPassword = new char[password.length()];
        password.getChars(0, password.length(), this._callbackPassword, 0);
        this._lastLoginContext = this._securityContext.getAuthenticationContext().getLoginContext(null, (CallbackHandler)this);
        this._lastLoginContext.login();
        this._allOwners.add(this._locking.getCurrentOwner((byte)2));
    }

    protected void logout() throws Exception {
        this._lastLoginContext.logout();
    }

    protected void beginTransaction() throws Exception {
        this._transactionManager.begin();
        this._allOwners.add(this._locking.getCurrentOwner((byte)1));
    }

    protected void endTransaction(boolean commit) throws Exception {
        if (commit) {
            this._transactionManager.commit();
        } else {
            this._transactionManager.rollback();
        }
    }

    protected void lockExpectException(LogicalLocking locking, byte lifetime, String name, String argument, char mode) throws Exception {
        try {
            locking.lock(lifetime, name, argument, mode);
        }
        catch (LockException e) {
            return;
        }
        throw new Exception("Expected LockException did not occur for " + this.getLockDescription(lifetime, name, argument, mode));
    }

    protected void lockExpectException(LogicalLocking locking, byte lifetime, String[] name, String[] argument, char[] mode) throws Exception {
        try {
            locking.lock(lifetime, name, argument, mode);
        }
        catch (LockException e) {
            return;
        }
        throw new Exception("Expected LockException did not occur for [" + this.getStringForLifetime(lifetime) + "]");
    }

    protected void lockExpectTechnicalException(LogicalLocking locking, byte lifetime, String name, String argument, char mode) throws Exception {
        try {
            locking.lock(lifetime, name, argument, mode);
        }
        catch (TechnicalLockException e) {
            return;
        }
        throw new Exception("Expected TechnicalLockException did not occur for " + this.getLockDescription(lifetime, name, argument, mode));
    }

    protected void lockExpectTechnicalException(LogicalLocking locking, byte lifetime, String[] name, String[] argument, char[] mode) throws Exception {
        try {
            locking.lock(lifetime, name, argument, mode);
        }
        catch (TechnicalLockException e) {
            return;
        }
        throw new Exception("Expected TechnicalLockException did not occur for [owner=" + this.getStringForLifetime(lifetime) + "]");
    }

    protected void unlockExpectTechnicalException(LogicalLocking locking, byte lifetime, String name, String argument, char mode) throws Exception {
        try {
            locking.unlock(lifetime, name, argument, mode);
        }
        catch (TechnicalLockException e) {
            return;
        }
        throw new Exception("Expected TechnicalLockException did not occur for " + this.getLockDescription(lifetime, name, argument, mode));
    }

    protected void unlockExpectTechnicalException(LogicalLocking locking, byte lifetime, String[] name, String[] argument, char[] mode) throws Exception {
        try {
            locking.unlock(lifetime, name, argument, mode);
        }
        catch (TechnicalLockException e) {
            return;
        }
        throw new Exception("Expected TechnicalLockException did not occur for [owner=" + this.getStringForLifetime(lifetime) + "]");
    }

    protected void checkLockEntries(LockEntry[] entries, Integer expectedLength, String owner, String name, String argument, Character mode, Integer count) throws Exception {
        if (name != null) {
            name = UTIL.adjustStringLengthRight(name, 30, ' ');
        }
        if (argument != null) {
            argument = UTIL.adjustStringLengthRight(argument, 150, ' ');
        }
        if (expectedLength != null && entries.length != expectedLength) {
            throw new Exception("Received " + entries.length + " LockEntries, but expected " + expectedLength + " LockEntries");
        }
        int i = 0;
        while (i < entries.length) {
            LockEntry entry = entries[i];
            int differences = 0;
            if (owner != null && !owner.equals(entry.getOwner())) {
                ++differences;
            }
            if (name != null && !name.equals(entry.getName())) {
                ++differences;
            }
            if (argument != null && !argument.equals(entry.getArgument())) {
                ++differences;
            }
            if (mode != null && mode.charValue() != entry.getMode()) {
                ++differences;
            }
            if (count != null && count.intValue() != entry.getCount()) {
                ++differences;
            }
            if (differences > 0) {
                throw new Exception("Received wrong LockEntry (" + differences + " differences):\n" + "expected: [owner=" + owner + ", name=" + name + ", argument=" + argument + ", mode=" + mode + ", count=" + count + "]\n" + "received: [owner=" + entry.getOwner() + ", name=" + entry.getName() + ", argument=" + entry.getArgument() + ", mode=" + entry.getMode() + ", count=" + entry.getCount() + "]\n");
            }
            ++i;
        }
    }

    protected String getStringForLifetime(byte lifetime) {
        if (lifetime == 1) {
            return "LIFETIME_TRANSACTION";
        }
        if (lifetime == 2) {
            return "LIFETIME_USERSESSION";
        }
        return "<unknown lifetime>";
    }

    protected String getLockDescription(byte lifetime, String name, String argument, char mode) {
        return "[lifetime=" + this.getStringForLifetime(lifetime) + ", name=" + name + ", argument=" + argument + ", mode=" + mode + "]";
    }

    public abstract String getDescription();

    public abstract String getName();
}

