/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.applocking.gui;

import com.sap.engine.gui.SortTable;
import com.sap.engine.services.applocking.AppLockingRuntimeInterface;
import com.sap.engine.services.applocking.LifetimeDescription;
import com.sap.engine.services.applocking.gui.BasePanel;
import com.sap.engine.services.applocking.gui.LifetimeDescriptionDetailPanel;
import com.sap.engine.services.applocking.gui.LifetimeDescriptionTableModel;
import com.sap.engine.services.locking.gui.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class DisplayLifetimeDescriptionsPanel
extends BasePanel
implements ActionListener,
ListSelectionListener {
    private AppLockingRuntimeInterface _runtimeInterface;
    private JPanel _lifetimeDescriptionsPanel;
    private SortTable _lifetimeDescriptionsTable;
    private LifetimeDescriptionTableModel _lifetimeDescriptionsTableModel;
    private JButton _lifetimeDescriptionsRefreshButton;
    private JButton _lifetimeDescriptionsDetailButton;

    public DisplayLifetimeDescriptionsPanel(AppLockingRuntimeInterface runtimeInterface) {
        this._runtimeInterface = runtimeInterface;
        this._lifetimeDescriptionsTableModel = new LifetimeDescriptionTableModel();
        this._lifetimeDescriptionsTable = ComponentFactory.createSortableTable((AbstractTableModel)this._lifetimeDescriptionsTableModel);
        this._lifetimeDescriptionsTable.getSelectionModel().addListSelectionListener(this);
        this._lifetimeDescriptionsTableModel.setColumnModel(this._lifetimeDescriptionsTable.getColumnModel());
        this._lifetimeDescriptionsTable.getTableHeader().setReorderingAllowed(false);
        this._lifetimeDescriptionsTable.getSelectionModel().setSelectionMode(2);
        JScrollPane scrollableTable = new JScrollPane((Component)this._lifetimeDescriptionsTable, 20, 30);
        this._lifetimeDescriptionsRefreshButton = ComponentFactory.createButton((String)"Refresh", (ActionListener)this, (String)"Refresh the table");
        this._lifetimeDescriptionsDetailButton = ComponentFactory.createButton((String)"Detail", (ActionListener)this, (String)"Display details for the selected item");
        this._lifetimeDescriptionsDetailButton.setEnabled(false);
        JPanel buttons = ComponentFactory.createHorizontalGridPanel((JComponent[])new JComponent[]{this._lifetimeDescriptionsRefreshButton, this._lifetimeDescriptionsDetailButton});
        this._lifetimeDescriptionsPanel = ComponentFactory.createVerticalPanel(null, (JComponent)scrollableTable, (JComponent)buttons);
        this.setLayout(new BorderLayout());
        this.add((Component)this._lifetimeDescriptionsPanel, "Center");
    }

    private LifetimeDescription[] getSelectedDescriptions() {
        if (this._lifetimeDescriptionsTable.getSelectedRowCount() == 0) {
            return new LifetimeDescription[0];
        }
        int[] selectedRows = this._lifetimeDescriptionsTable.getSelectedRows();
        LifetimeDescription[] allRows = this._lifetimeDescriptionsTableModel.getValues();
        LifetimeDescription[] result = new LifetimeDescription[selectedRows.length];
        int i = 0;
        while (i < selectedRows.length) {
            result[i] = allRows[this._lifetimeDescriptionsTable.getDataIndex(selectedRows[i])];
            ++i;
        }
        return result;
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        if (this._lifetimeDescriptionsTable.getSelectedRowCount() != 1) {
            this._lifetimeDescriptionsDetailButton.setEnabled(false);
        } else {
            this._lifetimeDescriptionsDetailButton.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source == this._lifetimeDescriptionsRefreshButton) {
                LifetimeDescription[] values = this._runtimeInterface.getLifetimeDescriptions();
                this._lifetimeDescriptionsTableModel.setValues(values);
            } else if (source == this._lifetimeDescriptionsDetailButton) {
                LifetimeDescription[] selected = this.getSelectedDescriptions();
                if (selected.length == 0) {
                    return;
                }
                LifetimeDescription description = selected[0];
                LifetimeDescriptionDetailPanel detailPanel = new LifetimeDescriptionDetailPanel(description);
                JOptionPane.showMessageDialog(this, detailPanel, "Details", -1);
            }
        }
        catch (Exception e) {
            this.displayException(e);
        }
    }
}

