/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.applocking.gui;

import com.sap.engine.frame.core.locking.LockException;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.frame.core.locking.Util;
import com.sap.engine.services.locking.gui.ComponentFactory;
import com.sap.exception.standard.SAPIllegalArgumentException;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class BasePanel
extends JPanel {
    protected static final Util UTIL = new Util();
    protected static final String LIFETIME_TRANSACTION = "transaction";
    protected static final String LIFETIME_USERSESSION = "user-session";

    protected static String getDescriptionForLifetime(int lifetime) {
        if (lifetime == 1) {
            return LIFETIME_TRANSACTION;
        }
        if (lifetime == 2) {
            return LIFETIME_USERSESSION;
        }
        return null;
    }

    protected static int getLifetimeForDescription(String lifetime) {
        if (LIFETIME_TRANSACTION.equals(lifetime)) {
            return 1;
        }
        if (LIFETIME_USERSESSION.equals(lifetime)) {
            return 2;
        }
        return 0;
    }

    protected void displayException(Exception e) {
        String text = e instanceof LockException || e instanceof SAPIllegalArgumentException ? "Error: " + e.getMessage() : (e instanceof TechnicalLockException ? "Error: " + e.getMessage() + "\n\nSee log for details." : "Error: " + e.getMessage() + "\n\nDetails:\n" + UTIL.getStackTrace((Throwable)e));
        JOptionPane.showMessageDialog(this, ComponentFactory.createTextView((String)text), "Error", 0);
    }

    protected void displayMessage(String title, String text) {
        JOptionPane.showMessageDialog(this, text, title, 1);
    }
}

