/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.applocking.command;

import com.sap.engine.frame.core.locking.LockingContext;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.applocking.AppLockingApplicationFrame;
import com.sap.engine.services.applocking.LogicalLockingFactory;
import com.sap.engine.services.applocking.command.AbstractCommand;
import com.sap.engine.services.applocking.test.AllTests;
import com.sap.engine.services.applocking.test.ILogicalLockingTest;
import com.sap.engine.services.locking.command.OptionParser;
import com.sap.engine.services.locking.test.TestResult;
import com.sap.exception.standard.SAPIllegalArgumentException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.transaction.TransactionManager;

public class RunTestsCommand
extends AbstractCommand {
    private static final String NAME = "run_applocking_tests";
    private static final String DESCRIPTION = "Runs several tests to check the applocking.";
    private static final String USAGE = "Usage: run_applocking_tests [options]\n\nwhere options include:\n    -d  -detail          Display detailed results\n    -nf -nofunctional    Do not run the functional tests\n    -nl -noload          Do not run the load tests\n\n";

    public RunTestsCommand(AppLockingApplicationFrame lockingApplicationFrame) {
        super(lockingApplicationFrame);
    }

    public final String getName() {
        return NAME;
    }

    public final String getUsage() {
        return USAGE;
    }

    public final String getDescription() {
        return DESCRIPTION;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        OptionParser.FlagOption detail = new OptionParser.FlagOption(new String[]{"d", "detail"});
        OptionParser.FlagOption nofunctional = new OptionParser.FlagOption(new String[]{"nf", "nofunctional"});
        OptionParser.FlagOption noload = new OptionParser.FlagOption(new String[]{"nl", "noload"});
        OptionParser.Option[] options = new OptionParser.Option[]{detail, nofunctional, noload};
        try {
            String[] remaining = OptionParser.parse((String[])params, (OptionParser.Option[])options);
            if (remaining.length > 0) {
                throw new SAPIllegalArgumentException("com.sap.exception.standard_0006");
            }
        }
        catch (Exception e) {
            out.println("Syntax error in command " + this.getName());
            out.println(this.getUsage());
            return;
        }
        try {
            String testResults = this.getTestResults(detail.getValue(), nofunctional.getValue(), noload.getValue());
            out.println(testResults);
        }
        catch (Exception e) {
            this.displayException(out, e);
        }
    }

    private String getTestResults(boolean detail, boolean nofunctional, boolean noload) throws Exception {
        TestResult[] result = this.runLockingContextTests(nofunctional, noload);
        StringBuffer sb = new StringBuffer(1024);
        int successfulTests = 0;
        int i = 0;
        while (i < result.length) {
            if (result[i].getException() == null) {
                ++successfulTests;
            }
            if (detail) {
                sb.append(result[i].getLog());
            }
            ++i;
        }
        if (successfulTests == result.length) {
            sb.append("SUCCESS: All ").append(result.length).append(" tests finished successfully");
        } else {
            sb.append("ERROR: Only ").append(successfulTests).append(" of ").append(result.length).append(" tests finished successfully");
        }
        return sb.toString();
    }

    private TestResult[] runLockingContextTests(boolean nofunctional, boolean noload) throws Exception {
        if (nofunctional && noload) {
            return new TestResult[0];
        }
        ILogicalLockingTest[] test = nofunctional && !noload ? AllTests.getLoadLogicalLockingTests() : (!nofunctional && noload ? AllTests.getFunctionalLogicalLockingTests() : AllTests.getAllLogicalLockingTests());
        LockingContext lockingContext = this.getLockingFrame().getLockingContext();
        ThreadSystem threadSystem = this.getLockingFrame().getThreadSystem();
        SecurityContext securityContext = this.getLockingFrame().getSecurityContext();
        LogicalLockingFactory logicalLockingFactory = this.getLockingRuntime().getLogicalLockingFactory();
        TransactionManager transactionManager = this.getLockingFrame().getTransactionManager();
        TestResult[] result = new TestResult[test.length];
        int i = 0;
        while (i < test.length) {
            result[i] = test[i].start(lockingContext, threadSystem, securityContext, logicalLockingFactory, transactionManager, null);
            ++i;
        }
        return result;
    }
}

