/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.applocking.command;

import com.sap.engine.frame.core.locking.TimeStatisticsHelper;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.applocking.AppLockingApplicationFrame;
import com.sap.engine.services.applocking.command.AbstractCommand;
import com.sap.engine.services.locking.command.OptionParser;
import com.sap.exception.standard.SAPIllegalArgumentException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class ResetTimeStatisticsCommand
extends AbstractCommand {
    private static final TimeStatisticsHelper HELPER = new TimeStatisticsHelper();
    private static final String NAME = "reset_applocking_stat";
    private static final String DESCRIPTION = "Resets the statistics for the performance of Application Locking Service.";
    private static final String USAGE = "Usage: reset_applocking_stat\n";

    public ResetTimeStatisticsCommand(AppLockingApplicationFrame appLockingApplicationFrame) {
        super(appLockingApplicationFrame);
    }

    public final String getName() {
        return NAME;
    }

    public final String getUsage() {
        return USAGE;
    }

    public final String getDescription() {
        return DESCRIPTION;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        OptionParser.FlagOption detail = new OptionParser.FlagOption(new String[]{"d", "detail"});
        OptionParser.Option[] options = new OptionParser.Option[]{detail};
        try {
            String[] remaining = OptionParser.parse((String[])params, (OptionParser.Option[])options);
            if (remaining.length > 0) {
                throw new SAPIllegalArgumentException("com.sap.exception.standard_0006");
            }
        }
        catch (Exception e) {
            out.println("Syntax error in command " + this.getName());
            out.println(this.getUsage());
            return;
        }
        try {
            this.getLockingRuntime().resetTimeStatistics();
            out.println("... done");
        }
        catch (Exception e) {
            this.displayException(out, e);
        }
    }
}

