/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.applocking.command;

import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.lib.text.FastDateFormat;
import com.sap.engine.services.applocking.AppLockingApplicationFrame;
import com.sap.engine.services.applocking.LifetimeDescription;
import com.sap.engine.services.applocking.command.AbstractCommand;
import com.sap.engine.services.locking.command.OptionParser;
import com.sap.exception.standard.SAPIllegalArgumentException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class DisplayOpenSessionsCommand
extends AbstractCommand {
    private static final String NAME = "show_open_sessions";
    private static final String DESCRIPTION = "Shows the open user-sessions and transactions of this server, which use the application-locking.";
    private static final String USAGE = "Usage: show_open_sessions [options]\n\nwhere options include:\n    -d -detail     For a detailed message\n\n";
    private static final String HEADER_LIFETIME = "lifetime";
    private static final String HEADER_USER = "user";
    private static final String HEADER_OWNER = "owner";
    private static final String HEADER_CREATED = "created";
    private static final String HEADER_CHANGED = "changed";
    private static final String SHORT_DATEFORMAT_STRING = "HH:mm:ss";
    private static final String LONG_DATEFORMAT_STRING = "yyyy-MM-dd HH:mm:ss";
    private static final FastDateFormat SHORT_DATEFORMAT = new FastDateFormat("HH:mm:ss", false);
    private static final FastDateFormat LONG_DATEFORMAT = new FastDateFormat("yyyy-MM-dd HH:mm:ss", false);

    public DisplayOpenSessionsCommand(AppLockingApplicationFrame appLockingApplicationFrame) {
        super(appLockingApplicationFrame);
    }

    public final String getName() {
        return NAME;
    }

    public final String getUsage() {
        return USAGE;
    }

    public final String getDescription() {
        return DESCRIPTION;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        OptionParser.FlagOption detail = new OptionParser.FlagOption(new String[]{"d", "detail"});
        OptionParser.Option[] options = new OptionParser.Option[]{detail};
        try {
            String[] remaining = OptionParser.parse((String[])params, (OptionParser.Option[])options);
            if (remaining.length > 0) {
                throw new SAPIllegalArgumentException("com.sap.exception.standard_0006");
            }
        }
        catch (Exception e) {
            out.println("Syntax error in command " + this.getName());
            out.println(this.getUsage());
            return;
        }
        try {
            LifetimeDescription[] descriptions = this.getLockingRuntime().getLifetimeDescriptions();
            out.println(DisplayOpenSessionsCommand.formatLifetimeDescriptions(descriptions, detail.getValue()));
        }
        catch (Exception e) {
            this.displayException(out, e);
        }
    }

    public static String formatLifetimeDescriptions(LifetimeDescription[] descriptions, boolean detail) {
        StringBuffer result = new StringBuffer(1024);
        int maxLifetimeLength = Math.max(HEADER_LIFETIME.length(), DisplayOpenSessionsCommand.getFormatedLifetimeLength());
        int maxCreatedLength = Math.max(HEADER_CREATED.length(), DisplayOpenSessionsCommand.getFormatedDateLength(detail));
        int maxChangedLength = Math.max(HEADER_CREATED.length(), DisplayOpenSessionsCommand.getFormatedDateLength(detail));
        int maxOwnerLength = 58;
        int maxUserLength = HEADER_USER.length();
        int i = 0;
        while (i < descriptions.length) {
            maxUserLength = Math.max(maxUserLength, descriptions[i].getUser().length());
            ++i;
        }
        String header = detail ? AbstractCommand.UTIL.adjustStringLengthRight(HEADER_LIFETIME, maxLifetimeLength, ' ') + " | " + AbstractCommand.UTIL.adjustStringLengthLeft(HEADER_USER, maxUserLength, ' ') + " | " + AbstractCommand.UTIL.adjustStringLengthLeft(HEADER_CREATED, maxCreatedLength, ' ') + " | " + AbstractCommand.UTIL.adjustStringLengthLeft(HEADER_CHANGED, maxChangedLength, ' ') + " | " + AbstractCommand.UTIL.adjustStringLengthLeft(HEADER_OWNER, maxOwnerLength, ' ') : AbstractCommand.UTIL.adjustStringLengthRight(HEADER_LIFETIME, maxLifetimeLength, ' ') + " | " + AbstractCommand.UTIL.adjustStringLengthLeft(HEADER_USER, maxUserLength, ' ') + " | " + AbstractCommand.UTIL.adjustStringLengthLeft(HEADER_CREATED, maxCreatedLength, ' ') + " | " + AbstractCommand.UTIL.adjustStringLengthLeft(HEADER_CHANGED, maxChangedLength, ' ');
        result.append(header).append('\n');
        result.append(AbstractCommand.UTIL.adjustStringLengthRight("", header.length(), '-')).append('\n');
        int i2 = 0;
        while (i2 < descriptions.length) {
            LifetimeDescription next = descriptions[i2];
            String lifetime = AbstractCommand.UTIL.adjustStringLengthRight(DisplayOpenSessionsCommand.formatLifetime(next.getLifetime()), maxLifetimeLength, ' ');
            String user = AbstractCommand.UTIL.adjustStringLengthLeft(next.getUser(), maxUserLength, ' ');
            String created = AbstractCommand.UTIL.adjustStringLengthLeft(DisplayOpenSessionsCommand.formatDate(next.getCreationTime(), detail), maxCreatedLength, ' ');
            String changed = AbstractCommand.UTIL.adjustStringLengthLeft(DisplayOpenSessionsCommand.formatDate(next.getLastChangeTime(), detail), maxChangedLength, ' ');
            String owner = AbstractCommand.UTIL.adjustStringLengthLeft(next.getOwner(), maxOwnerLength, ' ');
            if (detail) {
                result.append(lifetime + " | " + user + " | " + created + " | " + changed + " | " + owner).append('\n');
            } else {
                result.append(lifetime + " | " + user + " | " + created + " | " + changed).append('\n');
            }
            ++i2;
        }
        return result.toString();
    }

    public static String formatDate(long millis, boolean detail) {
        FastDateFormat dateformat = detail ? SHORT_DATEFORMAT : LONG_DATEFORMAT;
        byte[] result = new byte[dateformat.getLength()];
        dateformat.getDate(result, 0);
        return new String(result);
    }

    public static int getFormatedDateLength(boolean detail) {
        return detail ? SHORT_DATEFORMAT_STRING.length() : LONG_DATEFORMAT_STRING.length();
    }

    public static String formatLifetime(int lifetime) {
        if (lifetime == 1) {
            return "transaction";
        }
        return "user-session";
    }

    public static int getFormatedLifetimeLength() {
        return Math.max(DisplayOpenSessionsCommand.formatLifetime(1).length(), DisplayOpenSessionsCommand.formatLifetime(2).length());
    }
}

