/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.applocking.command;

import com.sap.engine.frame.core.locking.LockException;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.frame.core.locking.Util;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.applocking.AppLockingApplicationFrame;
import com.sap.engine.services.applocking.AppLockingRuntimeInterface;
import com.sap.exception.standard.SAPIllegalArgumentException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public abstract class AbstractCommand
implements Command {
    protected static final Util UTIL = new Util();
    private static String GROUP = "applocking";
    private AppLockingApplicationFrame _appLockingApplicationFrame;

    public AbstractCommand(AppLockingApplicationFrame appLockingApplicationFrame) {
        this._appLockingApplicationFrame = appLockingApplicationFrame;
    }

    protected AppLockingApplicationFrame getLockingFrame() {
        return this._appLockingApplicationFrame;
    }

    protected AppLockingRuntimeInterface getLockingRuntime() throws TechnicalLockException {
        return this._appLockingApplicationFrame.getRuntimeInterface();
    }

    public abstract String getUsage();

    public abstract String getDescription();

    public String getHelpMessage() {
        return "\n" + this.getDescription() + "\n" + this.getUsage();
    }

    public String getGroup() {
        return GROUP;
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    protected void displayException(PrintStream out, Exception e) {
        out.println("Error:");
        if (e instanceof LockException || e instanceof SAPIllegalArgumentException || e instanceof TechnicalLockException) {
            out.println(e.getMessage());
            out.println("See log for details\n");
        } else {
            out.println(e.getMessage() + "\n");
            e.printStackTrace(out);
            out.println();
        }
    }

    public abstract String getName();

    public abstract void exec(Environment var1, InputStream var2, OutputStream var3, String[] var4);
}

