/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.applocking;

import com.sap.engine.frame.core.locking.AdministrativeLocking;
import com.sap.engine.frame.core.locking.LockEntry;
import com.sap.engine.frame.core.locking.LockException;
import com.sap.engine.frame.core.locking.SAPLockingIllegalArgumentException;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.applocking.LogicalLocking;
import com.sap.engine.services.applocking.LogicalLockingImpl;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;

public class NamespaceLogicalLockingImpl
implements LogicalLocking {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$applocking$NamespaceLogicalLockingImpl == null ? (class$com$sap$engine$services$applocking$NamespaceLogicalLockingImpl = NamespaceLogicalLockingImpl.class$("com.sap.engine.services.applocking.NamespaceLogicalLockingImpl")) : class$com$sap$engine$services$applocking$NamespaceLogicalLockingImpl));
    private static final Category CATEGORY = LoggingHelper.SYS_SERVER;
    private AdministrativeLocking _adminLocking;
    private LogicalLocking _locking;
    private String _namespace;
    private String _description;
    static /* synthetic */ Class class$com$sap$engine$services$applocking$NamespaceLogicalLockingImpl;

    protected NamespaceLogicalLockingImpl(AdministrativeLocking adminLocking, LogicalLocking locking, String namespace, String description) throws TechnicalLockException, IllegalArgumentException {
        this._adminLocking = adminLocking;
        this._locking = locking;
        this._namespace = namespace;
        this._description = description;
        this._adminLocking.reserveNamespace(this._namespace, this._description);
    }

    public void lock(byte lifetime, String name, String argument, char mode) throws LockException, TechnicalLockException, IllegalArgumentException {
        this._locking.lock(lifetime, this.checkName(name), argument, mode);
    }

    public void lock(byte lifetime, String name, String argument, char mode, int timeout) throws LockException, TechnicalLockException, IllegalArgumentException {
        this._locking.lock(lifetime, this.checkName(name), argument, mode, timeout);
    }

    public void lock(byte lifetime, String[] name, String[] argument, char[] mode) throws LockException, TechnicalLockException, IllegalArgumentException {
        this._locking.lock(lifetime, this.checkName(name), argument, mode);
    }

    public void lock(byte lifetime, String[] name, String[] argument, char[] mode, int timeout) throws LockException, TechnicalLockException, IllegalArgumentException {
        this._locking.lock(lifetime, this.checkName(name), argument, mode, timeout);
    }

    public void unlock(byte lifetime, String name, String argument, char mode, boolean asynchronous) throws TechnicalLockException, IllegalArgumentException {
        this._locking.unlock(lifetime, this.checkName(name), argument, mode, asynchronous);
    }

    public void unlock(byte lifetime, String[] name, String[] argument, char[] mode, boolean asynchronous) throws TechnicalLockException, IllegalArgumentException {
        this._locking.unlock(lifetime, this.checkName(name), argument, mode, asynchronous);
    }

    public void unlock(byte lifetime, String name, String argument, char mode) throws TechnicalLockException, IllegalArgumentException {
        this._locking.unlock(lifetime, this.checkName(name), argument, mode, true);
    }

    public void unlock(byte lifetime, String[] name, String[] argument, char[] mode) throws TechnicalLockException, IllegalArgumentException {
        this._locking.unlock(lifetime, this.checkName(name), argument, mode, true);
    }

    public void unlockAll(byte lifetime, boolean asynchronous) throws TechnicalLockException, IllegalArgumentException {
        this._locking.unlockAll(lifetime, asynchronous);
    }

    public void unlockAll(byte lifetime) throws TechnicalLockException, IllegalArgumentException {
        this._locking.unlockAll(lifetime, true);
    }

    public void assertLifetime(byte lifetime) throws TechnicalLockException, IllegalArgumentException {
        this._locking.assertLifetime(lifetime);
    }

    public String getCurrentOwner(byte lifetime) throws TechnicalLockException, IllegalArgumentException {
        return this._locking.getCurrentOwner(lifetime);
    }

    public String getNamespace() {
        return this._namespace;
    }

    public long getUniqueIncreasingNumber() throws TechnicalLockException {
        return this._locking.getUniqueIncreasingNumber();
    }

    public LockEntry[] getLocks(String name, String argument, String user) throws TechnicalLockException, IllegalArgumentException {
        return this._adminLocking.getLocks(name, argument, user);
    }

    public void unlock(LockEntry[] lockEntries, boolean asynchronous) throws TechnicalLockException {
        String method = "unlock(lockEntries, asnyc)";
        int i = 0;
        while (i < lockEntries.length) {
            String owner = lockEntries[i].getOwner();
            String name = lockEntries[i].getName();
            String argument = lockEntries[i].getArgument();
            char mode = lockEntries[i].getMode();
            this._adminLocking.unlockAllCumulativeCounts(owner, name, argument, mode, asynchronous);
            String user = ((SecurityContextObject)((LogicalLockingImpl)this._locking).getThreadSystem().getThreadContext().getContextObject("security")).getSession().getPrincipal().getName();
            CATEGORY.infoT(LOCATION, method, "{0} unlocked by user {1} from within an application.", new Object[]{lockEntries[i], user});
            ++i;
        }
    }

    private String checkName(String name) throws IllegalArgumentException {
        if (name == null) {
            return null;
        }
        if (!name.startsWith(this._namespace)) {
            throw new SAPLockingIllegalArgumentException("kernel_1055", new Object[]{name, this._namespace, this._description});
        }
        return name;
    }

    private String[] checkName(String[] name) throws IllegalArgumentException {
        if (name == null) {
            return null;
        }
        String[] result = new String[name.length];
        int i = 0;
        while (i < name.length) {
            result[i] = this.checkName(name[i]);
            ++i;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

