/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.applocking;

import com.sap.engine.frame.core.locking.LockException;
import com.sap.engine.frame.core.locking.LockingContext;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.frame.core.locking.TimeStatistics;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.interfaces.security.SecuritySession;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.applocking.AbstractBaseLocking;
import com.sap.engine.services.applocking.LifetimeDescription;
import com.sap.engine.services.applocking.LogicalLocking;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class LogicalLockingImpl
extends AbstractBaseLocking
implements LogicalLocking {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$applocking$LogicalLockingImpl == null ? (class$com$sap$engine$services$applocking$LogicalLockingImpl = LogicalLockingImpl.class$("com.sap.engine.services.applocking.LogicalLockingImpl")) : class$com$sap$engine$services$applocking$LogicalLockingImpl));
    private static final Category CATEGORY = LoggingHelper.SYS_SERVER;
    static /* synthetic */ Class class$com$sap$engine$services$applocking$LogicalLockingImpl;

    public LogicalLockingImpl(TimeStatistics timeStatistics, LockingContext lockingContext, TransactionManager transactionManager, ThreadSystem threadSystem) {
        super(timeStatistics, lockingContext, transactionManager, threadSystem);
    }

    public void lock(byte lifetime, String name, String argument, char mode, int timeout) throws LockException, TechnicalLockException, IllegalArgumentException {
        String METHOD = "lock(lifetime, name, argument, mode, timeout)";
        LOCATION.pathT(METHOD, "lifetime={0}, name={1}, argument={2}, mode={3}, timeout={4}", new Object[]{new Byte(lifetime), name, argument, new Character(mode), new Integer(timeout)});
        this.lockInternal(lifetime, null, name, argument, mode, timeout);
        LOCATION.pathT(METHOD, "success");
    }

    public void lock(byte lifetime, String name, String argument, char mode) throws LockException, TechnicalLockException, IllegalArgumentException {
        String METHOD = "lock(lifetime, name, argument, mode)";
        LOCATION.pathT(METHOD, "lifetime={0}, name={1}, argument={2}, mode={3}", new Object[]{new Byte(lifetime), name, argument, new Character(mode)});
        this.lock(lifetime, name, argument, mode, 0);
        LOCATION.pathT(METHOD, "success");
    }

    public void lock(byte lifetime, String[] name, String[] argument, char[] mode, int timeout) throws LockException, TechnicalLockException, IllegalArgumentException {
        String METHOD = "lock(lifetime, name[], argument[], mode[], timeout)";
        LOCATION.pathT(METHOD, "lifetime={0}, timeout={1[}", new Object[]{new Byte(lifetime), new Integer(timeout)});
        this.lockInternal(lifetime, null, name, argument, mode, timeout);
        LOCATION.pathT(METHOD, "success");
    }

    public void lock(byte lifetime, String[] name, String[] argument, char[] mode) throws LockException, TechnicalLockException, IllegalArgumentException {
        String METHOD = "lock(lifetime, name[], argument[], mode[])";
        LOCATION.pathT(METHOD, "lifetime={0}", new Object[]{new Byte(lifetime)});
        this.lock(lifetime, name, argument, mode, 0);
        LOCATION.pathT(METHOD, "success");
    }

    public void unlock(byte lifetime, String name, String argument, char mode, boolean asynchronous) throws TechnicalLockException, IllegalArgumentException {
        String METHOD = "unlock(lifetime, name, argument, mode, asynchronous)";
        LOCATION.pathT(METHOD, "lifetime={0}, name={1}, argument={2}, mode={3}, asynchronous={4}", new Object[]{new Byte(lifetime), name, argument, new Character(mode), new Boolean(asynchronous)});
        this.unlockInternal(lifetime, null, name, argument, mode, asynchronous);
        LOCATION.pathT(METHOD, "success");
    }

    public void unlock(byte lifetime, String name, String argument, char mode) throws TechnicalLockException, IllegalArgumentException {
        String METHOD = "unlock(lifetime, name, argument, mode)";
        LOCATION.pathT(METHOD, "lifetime={0}, name={1}, argument={2}, mode={3}, asynchronous={4}", new Object[]{new Byte(lifetime), name, argument, new Character(mode)});
        this.unlockInternal(lifetime, null, name, argument, mode);
        LOCATION.pathT(METHOD, "success");
    }

    public void unlock(byte lifetime, String[] name, String[] argument, char[] mode, boolean asynchronous) throws TechnicalLockException, IllegalArgumentException {
        String METHOD = "unlock(lifetime, name[], argument[], mode[], asynchronous)";
        LOCATION.pathT(METHOD, "lifetime={0}, asynchronous={1}", new Object[]{new Byte(lifetime), new Boolean(asynchronous)});
        this.unlockInternal(lifetime, null, name, argument, mode, asynchronous);
        LOCATION.pathT(METHOD, "success");
    }

    public void unlock(byte lifetime, String[] name, String[] argument, char[] mode) throws TechnicalLockException, IllegalArgumentException {
        String METHOD = "unlock(lifetime, name[], argument[], mode[])";
        LOCATION.pathT(METHOD, "lifetime={0}", new Object[]{new Byte(lifetime)});
        this.unlockInternal(lifetime, null, name, argument, mode);
        LOCATION.pathT(METHOD, "success");
    }

    public void unlockAll(byte lifetime, boolean asynchronous) throws TechnicalLockException, IllegalArgumentException {
        String METHOD = "unlockAll(lifetime, asynchronous)";
        LOCATION.pathT(METHOD, "lifetime={0}, asynchronous={1}", new Object[]{new Byte(lifetime), new Boolean(asynchronous)});
        this.unlockAllInternal(lifetime, null, asynchronous);
        LOCATION.pathT(METHOD, "success");
    }

    public void unlockAll(byte lifetime) throws TechnicalLockException, IllegalArgumentException {
        String METHOD = "unlockAll(lifetime)";
        LOCATION.pathT(METHOD, "lifetime={0}", new Object[]{new Byte(lifetime)});
        this.unlockAllInternal(lifetime, null);
        LOCATION.pathT(METHOD, "success");
    }

    public void assertLifetime(byte lifetime) throws TechnicalLockException, IllegalArgumentException {
        String METHOD = "assertLifetime(lifetime)";
        long TIMESTATISTICS = AbstractBaseLocking._timeStatistics.startMeasurement(2);
        LOCATION.debugT(METHOD, "lifetime={0}", new Object[]{new Byte(lifetime)});
        this.checkServiceState();
        this.getObjectForLifetime(lifetime);
        AbstractBaseLocking._timeStatistics.endMeasurement(TIMESTATISTICS, LOCATION, METHOD, "assert lifetime");
    }

    public String getCurrentOwner(byte lifetime) throws TechnicalLockException, IllegalArgumentException {
        String METHOD = "getCurrentOwner(lifetime)";
        long TIMESTATISTICS = AbstractBaseLocking._timeStatistics.startMeasurement(2);
        LOCATION.debugT(METHOD, "lifetime={0}", new Object[]{new Byte(lifetime)});
        String result = this.getCurrentLifetimeDescription(lifetime, null).getOwner();
        AbstractBaseLocking._timeStatistics.endMeasurement(TIMESTATISTICS, LOCATION, METHOD, "get owner for lifetime");
        LOCATION.pathT(METHOD, "result={0}", new Object[]{result});
        return result;
    }

    String getCurrentOwner(byte lifetime, Connection connection) throws TechnicalLockException, IllegalArgumentException {
        return this.getCurrentOwner(lifetime);
    }

    LifetimeDescription getCurrentLifetimeDescription(byte lifetime, Connection connection) throws TechnicalLockException, IllegalArgumentException {
        this.checkServiceState();
        Object o = this.getObjectForLifetime(lifetime);
        LifetimeDescription description = lifetime == 1 ? this.getLifetimeDescriptionForTransaction((Transaction)o) : this.getLifetimeDescriptionForSession((SecuritySession)o);
        description.modifyLastChangeTime();
        return description;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

