/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.applocking;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.locking.LockingConstants;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.frame.core.locking.TimeStatistics;
import com.sap.engine.frame.core.locking.TimeStatisticsEntry;
import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.applocking.AppLockingApplicationFrame;
import com.sap.engine.services.applocking.AppLockingRuntimeInterface;
import com.sap.engine.services.applocking.LifetimeDescription;
import com.sap.engine.services.applocking.LogicalLockingFactory;
import com.sap.engine.services.applocking.LogicalLockingFactoryImpl;
import com.sap.engine.services.applocking.LogicalLockingImpl;
import com.sap.engine.services.applocking.TableLocking;
import com.sap.engine.services.applocking.TableLockingImpl;
import com.sap.engine.services.applocking.exception.AppLockingTechnicalLockException;
import com.sap.engine.services.applocking.test.AllTests;
import com.sap.engine.services.applocking.test.ILogicalLockingTest;
import com.sap.engine.services.locking.test.TestResult;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Properties;
import javax.naming.NamingException;

public class AppLockingRuntimeInterfaceImpl
implements AppLockingRuntimeInterface,
LockingConstants {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$applocking$AppLockingRuntimeInterfaceImpl == null ? (class$com$sap$engine$services$applocking$AppLockingRuntimeInterfaceImpl = AppLockingRuntimeInterfaceImpl.class$("com.sap.engine.services.applocking.AppLockingRuntimeInterfaceImpl")) : class$com$sap$engine$services$applocking$AppLockingRuntimeInterfaceImpl));
    private static final Category CATEGORY = LoggingHelper.SYS_SERVER;
    private ApplicationServiceContext _applicationServiceContext;
    private TimeStatistics _timeStatistics;
    private LogicalLockingImpl _logicalLocking;
    private LogicalLockingFactoryImpl _logicalLockingFactory;
    private TableLockingImpl _tableLocking;
    private AppLockingApplicationFrame _frame;
    private boolean _serviceIsRunning = true;
    static /* synthetic */ Class class$com$sap$engine$services$applocking$AppLockingRuntimeInterfaceImpl;

    public AppLockingRuntimeInterfaceImpl(AppLockingApplicationFrame frame, TimeStatistics timeStatistics, ApplicationServiceContext applicationServiceContext) throws NamingException, TechnicalLockException {
        this._frame = frame;
        this._timeStatistics = timeStatistics;
        this._applicationServiceContext = applicationServiceContext;
        String METHOD = "<init>";
        LOCATION.pathT(METHOD, "begin");
        this._logicalLocking = new LogicalLockingImpl(this._timeStatistics, this._frame.getLockingContext(), this._frame.getTransactionManager(), this._frame.getThreadSystem());
        LOCATION.pathT(METHOD, "created LogicalLockingImpl");
        this._logicalLockingFactory = new LogicalLockingFactoryImpl(this._frame.getLockingContext().getAdministrativeLocking(), this._logicalLocking);
        LOCATION.pathT(METHOD, "created LogicalLockingFactoryImpl");
        this._tableLocking = new TableLockingImpl(this._timeStatistics, this._frame.getLockingContext(), this._frame.getTransactionManager(), this._frame.getThreadSystem());
        LOCATION.pathT(METHOD, "created TableLockingImpl");
        LOCATION.pathT(METHOD, "success");
    }

    public void stop() throws TechnicalLockException {
        try {
            String METHOD = "stop()";
            LOCATION.pathT(METHOD, "begin");
            if (this._logicalLocking != null) {
                this._logicalLocking.stop();
            }
            LOCATION.pathT(METHOD, "success");
            Object var3_2 = null;
            this._serviceIsRunning = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._serviceIsRunning = false;
            throw throwable;
        }
    }

    public void registerManagementListener(ManagementListener managementListener) {
    }

    public LogicalLockingFactory getLogicalLockingFactory() throws TechnicalLockException {
        return this._logicalLockingFactory;
    }

    public TableLocking getTableLocking() throws TechnicalLockException {
        return this._tableLocking;
    }

    public TimeStatisticsEntry[] getTimeStatisticsEntries() {
        return this._timeStatistics.getTimeStatisticsEntries();
    }

    public void resetTimeStatistics() {
        this._timeStatistics.resetTimeStatistics();
    }

    public LifetimeDescription[] getLifetimeDescriptions() {
        return this._logicalLocking.getLifetimeDescriptions();
    }

    public TestResult[] runTests(boolean nofunctional, boolean noload) throws TechnicalLockException {
        String METHOD = "runTests(nofunctional, noload)";
        LOCATION.pathT(METHOD, "nofunctional={0}, noload={1}", new Object[]{new Boolean(nofunctional), new Boolean(noload)});
        Properties props = this._frame.reloadProperties();
        if (nofunctional && noload) {
            return new TestResult[0];
        }
        ILogicalLockingTest[] test = nofunctional && !noload ? AllTests.getLoadLogicalLockingTests() : (!nofunctional && noload ? AllTests.getFunctionalLogicalLockingTests() : AllTests.getAllLogicalLockingTests());
        TestResult[] result = new TestResult[test.length];
        int i = 0;
        while (i < test.length) {
            LOCATION.pathT(METHOD, "start test {0}", new Object[]{test[i].getName()});
            result[i] = test[i].start(this._frame.getLockingContext(), this._frame.getThreadSystem(), this._frame.getSecurityContext(), this.getLogicalLockingFactory(), this._frame.getTransactionManager(), props);
            LOCATION.pathT(METHOD, "test-result:\n{0}", new Object[]{result[i].getLog()});
            ++i;
        }
        LOCATION.pathT(METHOD, "finished");
        return result;
    }

    public void checkServiceState() throws TechnicalLockException {
        if (!this._serviceIsRunning) {
            throw new AppLockingTechnicalLockException("applocking_1002", new Object[]{this, "applocking-service"});
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

