/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.applocking;

import com.sap.engine.frame.core.locking.LockException;
import com.sap.engine.frame.core.locking.LockingContext;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.frame.core.locking.TimeStatistics;
import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.interfaces.security.SecuritySession;
import com.sap.engine.interfaces.security.SessionListener;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.applocking.LifetimeDescription;
import com.sap.engine.services.applocking.LogicalLockingSessionListener;
import com.sap.engine.services.applocking.LogicalLockingSynchronization;
import com.sap.engine.services.applocking.command.DisplayOpenSessionsCommand;
import com.sap.engine.services.applocking.exception.AppLockingTechnicalLockException;
import com.sap.exception.standard.SAPIllegalArgumentException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public abstract class AbstractBaseLocking {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$applocking$AbstractBaseLocking == null ? (class$com$sap$engine$services$applocking$AbstractBaseLocking = AbstractBaseLocking.class$("com.sap.engine.services.applocking.AbstractBaseLocking")) : class$com$sap$engine$services$applocking$AbstractBaseLocking));
    private static final Category CATEGORY = LoggingHelper.SYS_SERVER;
    protected static TimeStatistics _timeStatistics;
    protected static LockingContext _lockingContext;
    protected static TransactionManager _transactionManager;
    protected static ThreadSystem _threadSystem;
    protected static Hashtable _lifetimeDescriptions;
    protected static Hashtable _lifetimeDescriptionsReverse;
    protected static int[] lifetimeStructureLock;
    protected static boolean _serviceIsRunning;
    static /* synthetic */ Class class$com$sap$engine$services$applocking$AbstractBaseLocking;

    public abstract void assertLifetime(byte var1) throws TechnicalLockException, IllegalArgumentException;

    abstract LifetimeDescription getCurrentLifetimeDescription(byte var1, Connection var2) throws TechnicalLockException, IllegalArgumentException;

    public AbstractBaseLocking(TimeStatistics timeStatistics, LockingContext lockingContext, TransactionManager transactionManager, ThreadSystem threadSystem) {
        if (!_serviceIsRunning) {
            _timeStatistics = timeStatistics;
            _lockingContext = lockingContext;
            _transactionManager = transactionManager;
            _threadSystem = threadSystem;
            _serviceIsRunning = true;
        }
        String METHOD = "<init>";
        LOCATION.pathT(METHOD, "success");
    }

    public final void stop() {
        String METHOD = "stop()";
        try {
            LifetimeDescription[] descriptions = this.getLifetimeDescriptions();
            if (descriptions != null && descriptions.length != 0) {
                CATEGORY.warningT(LOCATION, METHOD, "The service is stopping, but there are still sessions open.\nThis means, that the automatic removal of locks can not work any more.\nIt may be necessary to remove the locks from the open sessions manually.\nThe open sessions are:\n======================\n{0}", new Object[]{DisplayOpenSessionsCommand.formatLifetimeDescriptions(descriptions, true)});
                int i = 0;
                while (i < descriptions.length) {
                    descriptions[i].setIsDeactivated(true);
                    ++i;
                }
            }
            _lifetimeDescriptions.clear();
            _lifetimeDescriptionsReverse.clear();
            LOCATION.pathT(METHOD, "success");
            Object var5_4 = null;
            _serviceIsRunning = false;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            _serviceIsRunning = false;
            throw throwable;
        }
    }

    public void lockInternal(byte lifetime, Connection connection, String name, String argument, char mode, int timeout) throws LockException, TechnicalLockException, IllegalArgumentException {
        String METHOD = "lockInternal(lifetime, connection, name, argument, mode, timeout)";
        long TIMESTATISTICS = _timeStatistics.startMeasurement(1);
        LOCATION.pathT(METHOD, "lifetime={0}, connection={1}, name={2},  argument={3}, mode={4}, timeout={5}", new Object[]{new Byte(lifetime), connection, name, argument, new Character(mode), new Integer(timeout)});
        this.checkServiceState();
        LifetimeDescription lifetimeDescription = this.getCurrentLifetimeDescription(lifetime, connection);
        LOCATION.pathT(METHOD, "owner={0}", new Object[]{lifetimeDescription.getOwner()});
        _lockingContext.getAdministrativeLocking().lock(lifetimeDescription.getOwner(), name, argument, mode, lifetimeDescription.getUser(), timeout);
        _timeStatistics.endMeasurement(TIMESTATISTICS, LOCATION, METHOD, "create single lock");
        LOCATION.pathT(METHOD, "success");
    }

    public void lockInternal(byte lifetime, Connection connection, String name, String argument, char mode) throws LockException, TechnicalLockException, IllegalArgumentException {
        this.lockInternal(lifetime, connection, name, argument, mode, 0);
    }

    public void lockInternal(byte lifetime, Connection connection, String[] name, String[] argument, char[] mode, int timeout) throws LockException, TechnicalLockException, IllegalArgumentException {
        String METHOD = "lockInternal(lifetime, connection, name[], argument[], mode[], timeout)";
        long TIMESTATISTICS = _timeStatistics.startMeasurement(1);
        LOCATION.pathT(METHOD, "lifetime={0}, connection={1}, timeout={2}", new Object[]{new Byte(lifetime), connection, new Integer(timeout)});
        this.checkServiceState();
        LifetimeDescription lifetimeDescription = this.getCurrentLifetimeDescription(lifetime, connection);
        LOCATION.pathT(METHOD, "owner={0}", new Object[]{lifetimeDescription.getOwner()});
        _lockingContext.getAdministrativeLocking().lock(lifetimeDescription.getOwner(), name, argument, mode, lifetimeDescription.getUser());
        _timeStatistics.endMeasurement(TIMESTATISTICS, LOCATION, METHOD, "create multiple locks");
        LOCATION.pathT(METHOD, "success");
    }

    public void lockInternal(byte lifetime, Connection connection, String[] name, String[] argument, char[] mode) throws LockException, TechnicalLockException, IllegalArgumentException {
        this.lockInternal(lifetime, connection, name, argument, mode, 0);
    }

    public void unlockInternal(byte lifetime, Connection connection, String name, String argument, char mode) throws TechnicalLockException, IllegalArgumentException {
        String METHOD = "unlock(lifetime, name, argument, mode)";
        long TIMESTATISTICS = _timeStatistics.startMeasurement(1);
        LOCATION.pathT(METHOD, "lifetime={0}, connection={1}, name={2}, argument={3}, mode={4}", new Object[]{new Byte(lifetime), connection, name, argument, new Character(mode)});
        this.checkServiceState();
        LifetimeDescription lifetimeDescription = this.getCurrentLifetimeDescription(lifetime, connection);
        LOCATION.pathT(METHOD, "owner={0}", new Object[]{lifetimeDescription.getOwner()});
        _lockingContext.getAdministrativeLocking().unlock(lifetimeDescription.getOwner(), name, argument, mode, true);
        _timeStatistics.endMeasurement(TIMESTATISTICS, LOCATION, METHOD, "remove single lock");
        LOCATION.pathT(METHOD, "success");
    }

    public void unlockInternal(byte lifetime, Connection connection, String name, String argument, char mode, boolean asynchronous) throws TechnicalLockException, IllegalArgumentException {
        String METHOD = "unlock(lifetime, connection, name, argument, mode, asynchronous)";
        long TIMESTATISTICS = _timeStatistics.startMeasurement(1);
        LOCATION.pathT(METHOD, "lifetime={0}, connection={1}, name={2}, argument={3}, mode={4}, asynchronous={5}", new Object[]{new Byte(lifetime), connection, name, argument, new Character(mode), new Boolean(asynchronous)});
        this.checkServiceState();
        LifetimeDescription lifetimeDescription = this.getCurrentLifetimeDescription(lifetime, connection);
        LOCATION.pathT(METHOD, "owner={0}", new Object[]{lifetimeDescription.getOwner()});
        _lockingContext.getAdministrativeLocking().unlock(lifetimeDescription.getOwner(), name, argument, mode, asynchronous);
        _timeStatistics.endMeasurement(TIMESTATISTICS, LOCATION, METHOD, "remove single lock");
        LOCATION.pathT(METHOD, "success");
    }

    public void unlockInternal(byte lifetime, Connection connection, String[] name, String[] argument, char[] mode) throws TechnicalLockException, IllegalArgumentException {
        String METHOD = "unlock(lifetime, connection, name[], argument[], mode[])";
        long TIMESTATISTICS = _timeStatistics.startMeasurement(1);
        LOCATION.pathT(METHOD, "lifetime={0}, connection={1}", new Object[]{new Byte(lifetime), connection});
        this.checkServiceState();
        LifetimeDescription lifetimeDescription = this.getCurrentLifetimeDescription(lifetime, connection);
        LOCATION.pathT(METHOD, "owner={0}", new Object[]{lifetimeDescription.getOwner()});
        _lockingContext.getAdministrativeLocking().unlock(lifetimeDescription.getOwner(), name, argument, mode, true);
        _timeStatistics.endMeasurement(TIMESTATISTICS, LOCATION, METHOD, "remove multiple locks");
        LOCATION.pathT(METHOD, "success");
    }

    public void unlockInternal(byte lifetime, Connection connection, String[] name, String[] argument, char[] mode, boolean asynchronous) throws TechnicalLockException, IllegalArgumentException {
        String METHOD = "unlock( lifetime, connection, name[], argument[], mode[], asynchronous)";
        long TIMESTATISTICS = _timeStatistics.startMeasurement(1);
        LOCATION.pathT(METHOD, "lifetime={0}, connection={1}, asynchronous={2}", new Object[]{new Byte(lifetime), connection, new Boolean(asynchronous)});
        this.checkServiceState();
        LifetimeDescription lifetimeDescription = this.getCurrentLifetimeDescription(lifetime, connection);
        LOCATION.pathT(METHOD, "owner={0}", new Object[]{lifetimeDescription.getOwner()});
        _lockingContext.getAdministrativeLocking().unlock(lifetimeDescription.getOwner(), name, argument, mode, asynchronous);
        _timeStatistics.endMeasurement(TIMESTATISTICS, LOCATION, METHOD, "remove multiple locks");
        LOCATION.pathT(METHOD, "success");
    }

    public void unlockAllInternal(byte lifetime, Connection connection) throws TechnicalLockException, IllegalArgumentException {
        String METHOD = "unlockAll(lifetime, connection)";
        long TIMESTATISTICS = _timeStatistics.startMeasurement(1);
        LOCATION.pathT(METHOD, "lifetime={0}, connection={1}", new Object[]{new Byte(lifetime), connection});
        this.checkServiceState();
        LifetimeDescription lifetimeDescription = this.getCurrentLifetimeDescription(lifetime, connection);
        LOCATION.pathT(METHOD, "owner={0}", new Object[]{lifetimeDescription.getOwner()});
        _lockingContext.getAdministrativeLocking().unlockAll(lifetimeDescription.getOwner(), true);
        _timeStatistics.endMeasurement(TIMESTATISTICS, LOCATION, METHOD, "remove locks for lifetime");
        LOCATION.pathT(METHOD, "success");
    }

    public void unlockAllInternal(byte lifetime, Connection connection, boolean asynchronous) throws TechnicalLockException, IllegalArgumentException {
        String METHOD = "unlockAllInternal(lifetime, connection, asynchronous)";
        long TIMESTATISTICS = _timeStatistics.startMeasurement(1);
        LOCATION.pathT(METHOD, "lifetime={0}, connection={1}, asynchronous={2}", new Object[]{new Byte(lifetime), connection, new Boolean(asynchronous)});
        this.checkServiceState();
        LifetimeDescription lifetimeDescription = this.getCurrentLifetimeDescription(lifetime, connection);
        LOCATION.pathT(METHOD, "owner={0}", new Object[]{lifetimeDescription.getOwner()});
        _lockingContext.getAdministrativeLocking().unlockAll(lifetimeDescription.getOwner(), asynchronous);
        _timeStatistics.endMeasurement(TIMESTATISTICS, LOCATION, METHOD, "remove locks for lifetime");
        LOCATION.pathT(METHOD, "success");
    }

    protected LogicalLockingSynchronization getLifetimeDescriptionForTransaction(Transaction transaction) throws TechnicalLockException {
        int[] nArray = lifetimeStructureLock;
        synchronized (nArray) {
            String METHOD = "getLifetimeDescriptionForTransaction(transaction)";
            LogicalLockingSynchronization description = (LogicalLockingSynchronization)_lifetimeDescriptions.get(transaction);
            if (description == null) {
                try {
                    LOCATION.pathT(METHOD, "will register Synchronization for new transaction");
                    String owner = _lockingContext.getAdministrativeLocking().createUniqueOwner();
                    description = new LogicalLockingSynchronization(this, owner, transaction);
                    LOCATION.pathT(METHOD, "user={0}, owner={1}", new Object[]{description.getUser(), description.getOwner()});
                    transaction.registerSynchronization((Synchronization)description);
                    LOCATION.pathT(METHOD, "successfully registered in TransactionManager");
                    _lifetimeDescriptions.put(transaction, description);
                    _lifetimeDescriptionsReverse.put(description, transaction);
                }
                catch (SystemException e) {
                    throw new AppLockingTechnicalLockException("applocking_1006", new Object[]{e.getMessage()}, (Exception)((Object)e));
                }
                catch (RollbackException e) {
                    throw new AppLockingTechnicalLockException("applocking_1006", new Object[]{e.getMessage()}, (Exception)((Object)e));
                }
            }
            LogicalLockingSynchronization logicalLockingSynchronization = description;
            return logicalLockingSynchronization;
        }
    }

    protected LogicalLockingSessionListener getLifetimeDescriptionForSession(SecuritySession session) throws TechnicalLockException {
        int[] nArray = lifetimeStructureLock;
        synchronized (nArray) {
            String METHOD = "getLifetimeDescriptionForSession(session)";
            LogicalLockingSessionListener description = (LogicalLockingSessionListener)_lifetimeDescriptions.get(session);
            if (description == null) {
                LOCATION.pathT(METHOD, "will register SessionListener for new session");
                String owner = _lockingContext.getAdministrativeLocking().createUniqueOwner();
                description = new LogicalLockingSessionListener(this, owner, session);
                LOCATION.pathT(METHOD, "user={0}, owner={1}", new Object[]{description.getUser(), description.getOwner()});
                session.registerListener((SessionListener)description);
                LOCATION.pathT(METHOD, "successfully registered in SecuritySession");
                _lifetimeDescriptions.put(session, description);
                _lifetimeDescriptionsReverse.put(description, session);
            }
            LogicalLockingSessionListener logicalLockingSessionListener = description;
            return logicalLockingSessionListener;
        }
    }

    protected Object getObjectForLifetime(byte lifetime) throws TechnicalLockException, IllegalArgumentException {
        String METHOD = "getObjectForLifetime(lifetime)";
        LOCATION.pathT(METHOD, "lifetime={0}", new Object[]{new Byte(lifetime)});
        if (lifetime != 1 && lifetime != 2) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0007", new Object[]{"lifetime", new Byte(lifetime), "LockingConstants.LIFETIME_TRANSACTION, LockingConstants.LIFETIME_USERSESSION"});
        }
        if (lifetime == 1) {
            try {
                Transaction currentTransaction = _transactionManager.getTransaction();
                LOCATION.pathT(METHOD, "currentTransaction={0}", new Object[]{currentTransaction});
                if (currentTransaction == null) {
                    throw new AppLockingTechnicalLockException("applocking_1004");
                }
                if (currentTransaction.getStatus() != 0) {
                    throw new AppLockingTechnicalLockException("applocking_1005");
                }
                return currentTransaction;
            }
            catch (SystemException e) {
                throw new AppLockingTechnicalLockException("applocking_1006", new Object[]{e.getMessage()}, (Exception)((Object)e));
            }
        }
        ThreadContext currentThreadContext = _threadSystem.getThreadContext();
        LOCATION.pathT(METHOD, "currentThreadContext={0}", new Object[]{currentThreadContext});
        if (currentThreadContext == null) {
            throw new AppLockingTechnicalLockException("applocking_1003");
        }
        SecuritySession currentSession = ((SecurityContextObject)currentThreadContext.getContextObject("security")).getSession();
        return currentSession;
    }

    public LifetimeDescription[] getLifetimeDescriptions() {
        int[] nArray = lifetimeStructureLock;
        synchronized (nArray) {
            LifetimeDescription[] result = new LifetimeDescription[_lifetimeDescriptionsReverse.size()];
            int pos = 0;
            Enumeration descriptions = _lifetimeDescriptionsReverse.keys();
            while (descriptions.hasMoreElements()) {
                result[pos++] = (LifetimeDescription)descriptions.nextElement();
            }
            LifetimeDescription[] lifetimeDescriptionArray = result;
            return lifetimeDescriptionArray;
        }
    }

    public void checkServiceState() throws TechnicalLockException {
        if (!_serviceIsRunning) {
            throw new AppLockingTechnicalLockException("applocking_1002", new Object[]{this, "applocking-service"});
        }
    }

    public long getUniqueIncreasingNumber() throws TechnicalLockException {
        String METHOD = "getLifetimeDescriptionForSession(session)";
        long result = _lockingContext.getAdministrativeLocking().getUniqueIncreasingNumber();
        LOCATION.pathT(METHOD, "sucessfully created unique increasing number: " + result);
        return result;
    }

    protected final LockingContext getLockingContext() {
        return _lockingContext;
    }

    protected final ThreadSystem getThreadSystem() {
        return _threadSystem;
    }

    protected final TransactionManager getTransactionManager() {
        return _transactionManager;
    }

    protected void removeLifetimeDescription(LifetimeDescription description) {
        int[] nArray = lifetimeStructureLock;
        synchronized (nArray) {
            description.setIsDeactivated(true);
            Object key = _lifetimeDescriptionsReverse.remove(description);
            if (key != null) {
                _lifetimeDescriptions.remove(key);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _lifetimeDescriptions = new Hashtable();
        _lifetimeDescriptionsReverse = new Hashtable();
        lifetimeStructureLock = new int[0];
        _serviceIsRunning = false;
    }
}

