/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.ep.webservices.utils;

import com.sap.netweaver.ep.webservices.utils.Utility;

public final class CompactCharArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    private static final int BLOCKSHIFT = 5;
    private static final int BLOCKCOUNT = 32;
    private static final int INDEXSHIFT = 11;
    private static final int INDEXCOUNT = 2048;
    private static final int BLOCKMASK = 31;
    private char[] values;
    private char[] indices;
    private int[] hashes;
    private boolean isCompact;
    private char defaultValue;

    public int hashCode() {
        int i = 0;
        int j = Math.min(3, this.values.length / 16);
        int k = 0;
        while (k < this.values.length) {
            i = i * 37 + this.values[k];
            k += j;
        }
        return i;
    }

    public CompactCharArray() {
        this('\u0000');
    }

    public void compact() {
        if (!this.isCompact) {
            int i = 0;
            int j = 0;
            int c = 65535;
            int k = 0;
            while (k < this.indices.length) {
                this.indices[k] = 65535;
                boolean flag = this.blockTouched(k);
                if (!flag && c != 65535) {
                    this.indices[k] = c;
                } else {
                    int i1 = 0;
                    int j1 = 0;
                    j1 = 0;
                    while (j1 < i) {
                        if (this.hashes[k] == this.hashes[j1] && CompactCharArray.arrayRegionMatches(this.values, j, this.values, i1, 32)) {
                            this.indices[k] = (char)i1;
                        }
                        ++j1;
                        i1 += 32;
                    }
                    if (this.indices[k] == '\uffff') {
                        System.arraycopy(this.values, j, this.values, i1, 32);
                        this.indices[k] = (char)i1;
                        this.hashes[j1] = this.hashes[k];
                        ++i;
                        if (!flag) {
                            c = (char)i1;
                        }
                    }
                }
                ++k;
                j += 32;
            }
            int l = i * 32;
            char[] ac = new char[l];
            System.arraycopy(this.values, 0, ac, 0, l);
            this.values = ac;
            this.isCompact = true;
            this.hashes = null;
        }
    }

    private void expand() {
        if (this.isCompact) {
            char[] ac = new char[65536];
            this.hashes = new int[2048];
            int i = 0;
            while (i < 65536) {
                char c;
                ac[i] = c = this.elementAt((char)i);
                this.touchBlock(i >> 5, c);
                ++i;
            }
            int j = 0;
            while (j < 2048) {
                this.indices[j] = (char)(j << 5);
                ++j;
            }
            this.values = null;
            this.values = ac;
            this.isCompact = false;
        }
    }

    public char[] getIndexArray() {
        return this.indices;
    }

    public char[] getStringArray() {
        return this.values;
    }

    public char elementAt(char c) {
        return this.values[(this.indices[c >> 5] & 0xFFFF) + (c & 0x1F)];
    }

    public CompactCharArray(char c) {
        this.values = new char[65536];
        this.indices = new char[2048];
        this.hashes = new int[2048];
        int i = 0;
        while (i < 65536) {
            this.values[i] = c;
            ++i;
        }
        int j = 0;
        while (j < 2048) {
            this.indices[j] = (char)(j << 5);
            this.hashes[j] = 0;
            ++j;
        }
        this.isCompact = false;
        this.defaultValue = c;
    }

    public void setElementAt(char c, char c1) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[c] = c1;
        this.touchBlock(c >> 5, c1);
    }

    public void setElementAt(char c, char c1, char c2) {
        if (this.isCompact) {
            this.expand();
        }
        int i = c;
        while (i <= c1) {
            this.values[i] = c2;
            this.touchBlock(i >> 5, c2);
            ++i;
        }
    }

    private char getArrayValue(int i) {
        return this.values[i];
    }

    private char getIndexArrayValue(int i) {
        return this.indices[i];
    }

    private final boolean blockTouched(int i) {
        return this.hashes[i] != 0;
    }

    private final void touchBlock(int i, int j) {
        this.hashes[i] = this.hashes[i] + (j << 1) | 1;
    }

    static final boolean arrayRegionMatches(char[] ac, int i, char[] ac1, int j, int k) {
        int l = i + k;
        int i1 = j - i;
        int j1 = i;
        while (j1 < l) {
            if (ac[j1] != ac1[j1 + i1]) {
                return false;
            }
            ++j1;
        }
        return true;
    }

    public CompactCharArray(char[] ac, char[] ac1) {
        if (ac.length != 2048) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        int i = 0;
        while (i < 2048) {
            char c = ac[i];
            if (c < '\u0000' || c >= ac1.length + 32) {
                throw new IllegalArgumentException("Index out of bounds.");
            }
            ++i;
        }
        this.indices = ac;
        this.values = ac1;
        this.isCompact = true;
    }

    public Object clone() {
        try {
            CompactCharArray compactchararray = (CompactCharArray)super.clone();
            compactchararray.values = (char[])this.values.clone();
            compactchararray.indices = (char[])this.indices.clone();
            if (this.hashes != null) {
                compactchararray.hashes = (int[])this.hashes.clone();
            }
            return compactchararray;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompactCharArray compactchararray = (CompactCharArray)obj;
        int i = 0;
        while (i < 65536) {
            if (this.elementAt((char)i) != compactchararray.elementAt((char)i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public CompactCharArray(String s, String s1) {
        this(Utility.RLEStringToCharArray(s), Utility.RLEStringToCharArray(s1));
    }
}

