/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.ep.webservices.ui.views;

import com.sap.netweaver.ep.webservices.sender.MessageBuilder;
import com.sap.netweaver.ep.webservices.sender.OperationDescriptor;
import com.sap.netweaver.ep.webservices.sender.SOAPMessageDescriptor;
import com.sap.netweaver.ep.webservices.ui.views.TreeDescriptor;
import com.sapportals.portal.prt.service.soap.util.ToolKit;
import com.sapportals.portal.prt.service.soap.util.XMLValueExtractor;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPMessage;
import org.eclipse.swt.widgets.TreeItem;

public class XMLTree {
    public static void constructXMLTree(TreeDescriptor descriptor, String msg, String url, MimeHeaders headers, String style, String encodingStyle, boolean request) throws Exception {
        SOAPMessage soapmsg = MessageBuilder.getInstance().constructSOAPMessage(headers, new ByteArrayInputStream(msg.toString().getBytes()));
        OperationDescriptor opDescriptor = new OperationDescriptor();
        opDescriptor.setUrl(url);
        opDescriptor.setStyle(style);
        opDescriptor.setEncodingStyle(encodingStyle);
        SOAPMessageDescriptor msgDescriptor = new SOAPMessageDescriptor(soapmsg, opDescriptor);
        XMLTree.constructXMLTree(descriptor, msgDescriptor, request);
    }

    public static void constructXMLTree(TreeDescriptor descriptor, SOAPMessage msg, String url, String style, String encodingStyle, boolean request, HashMap types) throws Exception {
        OperationDescriptor opDescriptor = new OperationDescriptor();
        if (types != null) {
            opDescriptor.setListNameOfArrayFields(types);
        }
        opDescriptor.setUrl(url);
        opDescriptor.setStyle(style);
        opDescriptor.setEncodingStyle(encodingStyle);
        SOAPMessageDescriptor msgDescriptor = new SOAPMessageDescriptor(msg, opDescriptor);
        XMLTree.constructXMLTree(descriptor, msgDescriptor, request);
    }

    public static void constructXMLTree(TreeDescriptor xmlTreeDesc, SOAPMessageDescriptor msgDesc, MimeHeaders mimes, boolean request) throws Exception {
        SOAPMessage soapmsg = MessageBuilder.getInstance().constructSOAPMessage(mimes, new ByteArrayInputStream(msgDesc.getSoapmsg().toString().getBytes()));
        XMLTree.constructXMLTree(xmlTreeDesc, msgDesc, request);
    }

    public static void constructXMLTree(TreeDescriptor xmlTreeDesc, SOAPMessageDescriptor msgDesc, boolean request) throws Exception {
        SOAPBody body;
        SOAPMessage msg = msgDesc.getSoapmsg();
        OperationDescriptor opDesc = msgDesc.getDescriptor();
        boolean rpcStyle = opDesc.getStyle().equals("rpc");
        boolean literal = opDesc.getEncodingStyle().equals("literal");
        HashMap itemsToXML = xmlTreeDesc.getTreeItemToXML();
        ArrayList selection = new ArrayList();
        itemsToXML.clear();
        xmlTreeDesc.getXmlTree().removeAll();
        TreeItem root = new TreeItem(xmlTreeDesc.getXmlTree(), 64);
        root.setText(opDesc.getUrl());
        if (msg.getSOAPPart() != null && msg.getSOAPPart().getEnvelope() != null && (body = msg.getSOAPPart().getEnvelope().getBody()) != null) {
            Iterator iterator = body.getChildElements();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (!(element instanceof SOAPElement)) continue;
                SOAPElement xmlnode = (SOAPElement)element;
                if (rpcStyle) {
                    String ref;
                    TreeItem node = new TreeItem(root, 64);
                    itemsToXML.put(node, xmlnode);
                    String type = XMLValueExtractor.getAttributeValue((SOAPElement)xmlnode, (String)"arrayType");
                    if (type == null) {
                        type = XMLValueExtractor.getAttributeValue((SOAPElement)xmlnode, (String)"type");
                    }
                    if ((ref = XMLValueExtractor.getAttributeValue((SOAPElement)xmlnode, (String)"id")) != null) {
                        type = type == null ? "ID[" + ref + "]" : type + " ID[" + ref + "]";
                    }
                    if (literal && type == null) {
                        type = (String)opDesc.getListNameOfArrayFields().get(xmlnode.getElementName().getLocalName());
                    }
                    node.setText(xmlnode.getElementName().getLocalName() + (type != null ? "(" + type + ")" : ""));
                    XMLTree.createHierachy(node, xmlnode, itemsToXML, selection, rpcStyle, literal, request, opDesc.getListNameOfArrayFields());
                    continue;
                }
                XMLTree.createHierachy(root, xmlnode.getParentElement(), itemsToXML, selection, rpcStyle, literal, request, opDesc.getListNameOfArrayFields());
                break;
            }
        }
        xmlTreeDesc.getXmlTree().setSelection(XMLTree.convertArrayList(selection));
    }

    private static void createHierachy(TreeItem root, SOAPElement element, HashMap itemsToXML, ArrayList selection, boolean rpcStyle, boolean literalStyle, boolean request, HashMap listMappingFieldToType) {
        if (element.getChildElements() != null) {
            Iterator iter = element.getChildElements();
            int count = 0;
            while (iter.hasNext()) {
                int childs;
                String nil;
                Object el = iter.next();
                if (!(el instanceof SOAPElement)) continue;
                TreeItem node = new TreeItem(root, 64);
                itemsToXML.put(node, el);
                String value = null;
                boolean array = false;
                String type = XMLValueExtractor.getAttributeValue((SOAPElement)((SOAPElement)el), (String)"arrayType");
                if (type == null) {
                    type = XMLValueExtractor.getAttributeValue((SOAPElement)((SOAPElement)el), (String)"type");
                } else {
                    array = true;
                }
                String ref = XMLValueExtractor.getAttributeValue((SOAPElement)((SOAPElement)el), (String)"href");
                if (ref != null) {
                    type = type == null ? "ref -> [" + ref + "]" : type + " ref -> [" + ref + "]";
                }
                if ((nil = XMLValueExtractor.getAttributeValue((SOAPElement)((SOAPElement)el), (String)"nil")) != null && (nil.equals("true") || nil.equals("1"))) {
                    type = type == null ? " is nil" : type + " is nil";
                }
                SOAPElement xmlnode = (SOAPElement)el;
                if (literalStyle && type == null) {
                    type = (String)listMappingFieldToType.get(xmlnode.getElementName().getLocalName());
                }
                if (type != null && type.indexOf("[") != -1) {
                    array = true;
                }
                value = (childs = ToolKit.countItem((Iterator)xmlnode.getChildElements())) > 0 || array ? xmlnode.getElementName().getLocalName() + (type != null ? "{" + type : "") + (array && request ? ", Right click..." : "") + (type != null ? "}" : "") : xmlnode.getElementName().getLocalName() + (type != null ? "(" + type + ")" : "");
                if (xmlnode.getValue() != null && xmlnode.getValue().length() > 0 && !xmlnode.getValue().equals("\n") && !xmlnode.getValue().startsWith("\n ")) {
                    value = value + "=" + xmlnode.getValue();
                }
                node.setText(value);
                XMLTree.createHierachy(node, (SOAPElement)el, itemsToXML, selection, rpcStyle, literalStyle, request, listMappingFieldToType);
                ++count;
            }
            if (count == 0) {
                selection.add(root);
            }
        }
    }

    private static TreeItem[] convertArrayList(ArrayList selection) {
        TreeItem[] arrays = new TreeItem[selection.size()];
        int i = 0;
        while (i < selection.size()) {
            arrays[i] = (TreeItem)selection.get(i);
            ++i;
        }
        return arrays;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("XMLTree[");
        buffer.append("]");
        return buffer.toString();
    }
}

