/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.ep.webservices.ui.views;

import com.sap.netweaver.ep.webservices.utils.CharSequence;
import com.sap.netweaver.ep.webservices.utils.Matcher;
import com.sap.netweaver.ep.webservices.utils.Pattern;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;

public class XMLColor {
    private static Pattern xmlTagPattern = Pattern.compile("(<[^(><?)]+>)");
    private static Pattern xmlAttributePattern = Pattern.compile("(\\S+=\".+\")");
    private static Pattern xmlCommentPattern = Pattern.compile("(<!--?[^(?)]+?-->)");

    public static void colorXml(StyledText styledText) {
        int j;
        int i;
        Color xmlTextColor = new Color((Device)styledText.getDisplay(), 255, 0, 0);
        Color xmlTagColor = new Color((Device)styledText.getDisplay(), 0, 0, 0);
        Color xmlAttributeColor = new Color((Device)styledText.getDisplay(), 0, 0, 255);
        Color xmlCommentColor = new Color((Device)styledText.getDisplay(), 0, 255, 0);
        StyleRange styleRange = new StyleRange(0, styledText.getText().length(), xmlTextColor, null);
        styledText.setStyleRange(styleRange);
        Matcher matcher = xmlTagPattern.matcher(new SequenceString(styledText.getText()));
        while (matcher.find()) {
            i = matcher.start();
            j = matcher.end() - i;
            styleRange = new StyleRange(i, j, xmlTagColor, null);
            styledText.setStyleRange(styleRange);
        }
        matcher = xmlAttributePattern.matcher(new SequenceString(styledText.getText()));
        while (matcher.find()) {
            i = matcher.start();
            j = matcher.end() - i;
            styleRange = new StyleRange(i, j, xmlAttributeColor, null);
            styledText.setStyleRange(styleRange);
        }
        matcher = xmlCommentPattern.matcher(new SequenceString(styledText.getText()));
        while (matcher.find()) {
            i = matcher.start();
            j = matcher.end() - i;
            styleRange = new StyleRange(i, j, xmlCommentColor, null);
            styledText.setStyleRange(styleRange);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("XMLColor[");
        buffer.append("xmlTagPattern = ").append(xmlTagPattern);
        buffer.append(", xmlAttributePattern = ").append(xmlAttributePattern);
        buffer.append(", xmlCommentPattern = ").append(xmlCommentPattern);
        buffer.append("]");
        return buffer.toString();
    }

    static class SequenceString
    implements CharSequence {
        private String mm_value = null;

        public SequenceString(String value) {
            this.mm_value = value;
        }

        public int length() {
            return this.mm_value.length();
        }

        public char charAt(int index) {
            return this.mm_value.charAt(index);
        }

        public CharSequence subSequence(int start, int end) {
            return new SequenceString(this.mm_value.substring(start, end));
        }

        public boolean equals(Object obj) {
            return this.mm_value.equals(obj);
        }

        public int hashCode() {
            return this.mm_value.hashCode();
        }

        public String toString() {
            return this.mm_value.toString();
        }
    }
}

