/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.ep.webservices.ui.views;

import com.sap.netweaver.ep.webservices.IPreferenceConstants;
import com.sap.netweaver.ep.webservices.sender.SOAPMessageDescriptor;
import com.sap.netweaver.ep.webservices.tester.SOAPTesterPlugin;
import com.sap.netweaver.ep.webservices.ui.listeners.CloseTabAction;
import com.sap.netweaver.ep.webservices.ui.listeners.GetWSDLFileAction;
import com.sap.netweaver.ep.webservices.ui.listeners.LaunchSOAPAdminAction;
import com.sap.netweaver.ep.webservices.ui.listeners.LaunchSOAPLogViewerAction;
import com.sap.netweaver.ep.webservices.ui.listeners.NewTabAction;
import com.sap.netweaver.ep.webservices.ui.listeners.SaveMessageAction;
import com.sap.netweaver.ep.webservices.ui.listeners.SendMessageAction;
import com.sap.netweaver.ep.webservices.ui.views.SOAPTabItem;
import com.sap.netweaver.ep.webservices.wsdl.WSDLProcessManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class SOAPTesterMessageSenderView
extends ViewPart
implements IPreferenceConstants {
    private Action mm_newTab;
    private Action mm_closeTab;
    private Action mm_saveAction = null;
    private Action mm_sendAction = null;
    private Action mm_soapAdminAction = null;
    private Action mm_logSOAPAction = null;
    private Action mm_getWsdlAction = null;
    private boolean mm_indent = true;
    private IPreferenceStore mm_preferences = null;
    private IPropertyChangeListener mm_propertyChangeListener = null;
    private WSDLProcessManager mm_wsdlGenerator;
    private int mm_lastfocusTabIndex = 0;
    private SOAPMessageDescriptor mm_currentSOAPOperation = null;
    private Vector mm_listSOAPTabItem = new Vector();
    private CTabFolder mm_tabFolder = null;

    public SOAPTesterMessageSenderView() {
        this.mm_preferences = SOAPTesterPlugin.getDefault().getPreferenceStore();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        this.makeActions();
        this.contributeToActionBars();
        this.mm_tabFolder = new CTabFolder(parent, 0);
        this.mm_tabFolder.addCTabFolderListener(new CTabFolderListener(){

            public void itemClosed(CTabFolderEvent arg0) {
                CTabItem tabitem = (CTabItem)arg0.item;
                if (!tabitem.isDisposed()) {
                    tabitem.dispose();
                }
                SOAPTesterMessageSenderView.this.mm_newTab.setEnabled(true);
                if (SOAPTesterMessageSenderView.this.mm_tabFolder.getItemCount() == 0) {
                    SOAPTesterMessageSenderView.this.mm_closeTab.setEnabled(false);
                }
                SOAPTesterMessageSenderView.this.updateTabName();
            }
        });
        CTabItem tabItem = new CTabItem(this.mm_tabFolder, 0);
        tabItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                SOAPTesterMessageSenderView.this.cleanSOAPTabItem(arg0);
            }
        });
        SOAPTabItem first = new SOAPTabItem((Composite)this.mm_tabFolder, 0, this);
        tabItem.setControl((Control)first);
        tabItem.setText("1 - No wsdl");
        this.mm_tabFolder.setSelection(tabItem);
        this.initFocusListenerTabItem(this.mm_tabFolder);
        this.mm_tabFolder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
            }
        });
    }

    private void cleanSOAPTabItem(DisposeEvent arg) {
        if (arg.getSource() instanceof CTabItem) {
            SOAPTabItem soapitem = (SOAPTabItem)((CTabItem)arg.getSource()).getControl();
            if (soapitem != null && soapitem.getCurrentBGProcess() != null && soapitem.getCurrentBGProcess().isAlive()) {
                soapitem.getCurrentBGProcess().stop();
            }
            soapitem.dispose();
            Object var2_2 = null;
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        Action cutAction = new Action(){

            public void run() {
                SOAPTabItem item = SOAPTesterMessageSenderView.this.getCurrentSOAPTabItem();
                if (item.getUrlTextEntry().isFocusControl()) {
                    item.getUrlTextEntry().cut();
                } else if (item.getTextNodeValue().isFocusControl()) {
                    item.getTextNodeValue().cut();
                } else if (item.getRequestSetting().getEditorXML().isFocusControl()) {
                    item.getRequestSetting().getEditorXML().cut();
                }
            }
        };
        Action copyAction = new Action(){

            public void run() {
                SOAPTabItem item = SOAPTesterMessageSenderView.this.getCurrentSOAPTabItem();
                if (item.getUrlTextEntry().isFocusControl()) {
                    item.getUrlTextEntry().copy();
                } else if (item.getTextNodeValue().isFocusControl()) {
                    item.getTextNodeValue().copy();
                } else if (item.getRequestSetting().getEditorXML().isFocusControl()) {
                    item.getRequestSetting().getEditorXML().copy();
                }
            }
        };
        Action pasteAction = new Action(){

            public void run() {
                SOAPTabItem item = SOAPTesterMessageSenderView.this.getCurrentSOAPTabItem();
                if (item.getUrlTextEntry().isFocusControl()) {
                    item.getUrlTextEntry().paste();
                } else if (item.getTextNodeValue().isFocusControl()) {
                    item.getTextNodeValue().paste();
                } else if (item.getRequestSetting().getEditorXML().isFocusControl()) {
                    item.getRequestSetting().getEditorXML().paste();
                }
            }
        };
        Action selectAllAction = new Action(){

            public void run() {
                SOAPTabItem item = SOAPTesterMessageSenderView.this.getCurrentSOAPTabItem();
                if (item.getTextNodeValue().isFocusControl()) {
                    item.getTextNodeValue().selectAll();
                } else if (item.getRequestSetting().getEditorXML().isFocusControl()) {
                    item.getRequestSetting().getEditorXML().selectAll();
                }
            }
        };
        bars.setGlobalActionHandler("cut", (IAction)cutAction);
        bars.setGlobalActionHandler("copy", (IAction)copyAction);
        bars.setGlobalActionHandler("paste", (IAction)pasteAction);
        bars.setGlobalActionHandler("selectAll", (IAction)selectAllAction);
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
        this.mm_sendAction.setEnabled(false);
        this.mm_saveAction.setEnabled(false);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.mm_newTab);
        manager.add((IAction)this.mm_closeTab);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.mm_getWsdlAction);
        manager.add((IAction)this.mm_sendAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.mm_soapAdminAction);
        manager.add((IAction)this.mm_logSOAPAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.mm_saveAction);
        manager.add((IContributionItem)new Separator());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.mm_newTab);
        manager.add((IAction)this.mm_closeTab);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.mm_getWsdlAction);
        manager.add((IAction)this.mm_sendAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.mm_soapAdminAction);
        manager.add((IAction)this.mm_logSOAPAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.mm_saveAction);
        manager.add((IContributionItem)new Separator());
    }

    private void makeActions() {
        this.mm_saveAction = new SaveMessageAction(this);
        this.mm_saveAction.setText("Save");
        this.mm_saveAction.setToolTipText("Save Current soap request/response");
        this.mm_saveAction.setImageDescriptor(SOAPTesterMessageSenderView.getImageDescriptor("saveall_edit.gif"));
        this.mm_sendAction = new SendMessageAction(this);
        this.mm_sendAction.setText("Send");
        this.mm_sendAction.setToolTipText("Send Message");
        this.mm_sendAction.setImageDescriptor(SOAPTesterMessageSenderView.getImageDescriptor("resume_co.gif"));
        this.mm_soapAdminAction = new LaunchSOAPAdminAction(this);
        this.mm_soapAdminAction.setText("SOAP Admin Tool");
        this.mm_soapAdminAction.setToolTipText("Portal SOAP admin (server side)");
        this.mm_soapAdminAction.setImageDescriptor(SOAPTesterMessageSenderView.getImageDescriptor("soapadmin.gif"));
        this.mm_logSOAPAction = new LaunchSOAPLogViewerAction(this);
        this.mm_logSOAPAction.setText("SOAP Log Viewer");
        this.mm_logSOAPAction.setToolTipText("SOAP Log viewer (server side)");
        this.mm_logSOAPAction.setImageDescriptor(SOAPTesterMessageSenderView.getImageDescriptor("soaplog.gif"));
        this.mm_getWsdlAction = new GetWSDLFileAction(this);
        this.mm_getWsdlAction.setText("Get WSDL");
        this.mm_getWsdlAction.setToolTipText("Get the WSDL content from an URL");
        this.mm_getWsdlAction.setImageDescriptor(SOAPTesterMessageSenderView.getImageDescriptor("getwsdl.gif"));
        this.mm_newTab = new NewTabAction(this);
        this.mm_newTab.setText("New View");
        this.mm_newTab.setToolTipText("Create a new Soap view");
        this.mm_newTab.setImageDescriptor(SOAPTesterMessageSenderView.getImageDescriptor("newView.gif"));
        this.mm_closeTab = new CloseTabAction(this);
        this.mm_closeTab.setText("Close View");
        this.mm_closeTab.setToolTipText("CLose the current Soap view");
        this.mm_closeTab.setImageDescriptor(SOAPTesterMessageSenderView.getImageDescriptor("closeView.gif"));
    }

    public static ImageDescriptor getImageDescriptor(String relativePath) {
        String iconPath = "icons/";
        try {
            SOAPTesterPlugin plugin = SOAPTesterPlugin.getDefault();
            URL installURL = plugin.getDescriptor().getInstallURL();
            URL url = new URL(installURL, iconPath + relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public void setFocus() {
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SOAPTesterMessageSenderView[");
        buffer.append("mm_saveAction = ").append(this.mm_saveAction);
        buffer.append(", mm_sendAction = ").append(this.mm_sendAction);
        buffer.append(", mm_getWsdlAction = ").append(this.mm_getWsdlAction);
        buffer.append(", mm_indent = ").append(this.mm_indent);
        buffer.append(", mm_preferences = ").append(this.mm_preferences);
        buffer.append(", mm_propertyChangeListener = ").append(this.mm_propertyChangeListener);
        buffer.append(", mm_currentSOAPOperation = ").append(this.mm_currentSOAPOperation);
        buffer.append("]");
        return buffer.toString();
    }

    public SOAPMessageDescriptor getCurrentSOAPOperation() {
        return this.mm_currentSOAPOperation;
    }

    public synchronized WSDLProcessManager getWsdlGenerator() {
        return this.mm_wsdlGenerator;
    }

    public synchronized void setCurrentSOAPOperation(SOAPMessageDescriptor descriptor) {
        this.mm_currentSOAPOperation = descriptor;
    }

    public void setWsdlGenerator(WSDLProcessManager manager) {
        this.mm_wsdlGenerator = manager;
    }

    public void addNewSOAPTabItem() {
        int ind = this.mm_tabFolder.getItemCount();
        if (ind >= 10) {
            this.mm_newTab.setEnabled(false);
            return;
        }
        if (!this.mm_closeTab.isEnabled()) {
            this.mm_closeTab.setEnabled(true);
        }
        CTabItem tabItem = new CTabItem(this.mm_tabFolder, 0);
        SOAPTabItem soapItem = new SOAPTabItem((Composite)this.mm_tabFolder, 0, this);
        tabItem.setControl((Control)soapItem);
        tabItem.setText("" + (ind + 1) + " - No wsdl");
        this.mm_tabFolder.setSelection(ind);
        this.mm_sendAction.setEnabled(false);
        this.mm_saveAction.setEnabled(false);
        tabItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                SOAPTesterMessageSenderView.this.cleanSOAPTabItem(arg0);
            }
        });
        this.updateTabName();
    }

    public SOAPTabItem getCurrentSOAPTabItem() {
        if (this.mm_tabFolder.getSelection() != null) {
            return (SOAPTabItem)this.mm_tabFolder.getSelection().getControl();
        }
        return null;
    }

    public CTabItem getCurrentTabItem() {
        if (this.mm_tabFolder.getSelection() != null) {
            return this.mm_tabFolder.getSelection();
        }
        return null;
    }

    public int getCurrentIndexTabItem() {
        int ind = this.mm_tabFolder.getSelectionIndex();
        return ind;
    }

    public void closeCurrentSOAPTabItem() {
        CTabItem object = this.getCurrentTabItem();
        int ind = this.getCurrentIndexTabItem();
        this.mm_tabFolder.setSelection(ind);
        this.mm_tabFolder.layout();
        this.mm_tabFolder.update();
        if (object != null) {
            block6: {
                try {
                    if (!object.isDisposed()) {
                        object.dispose();
                    }
                }
                catch (Throwable e) {
                    if (!(e instanceof ThreadDeath)) break block6;
                    throw (ThreadDeath)e;
                }
            }
            this.mm_tabFolder.setSelection(ind - 1);
            if (!this.mm_newTab.isEnabled()) {
                this.mm_newTab.setEnabled(true);
            }
        }
        if (this.mm_tabFolder.getItemCount() == 0) {
            this.mm_closeTab.setEnabled(false);
        }
        this.updateTabName();
    }

    private void initFocusListenerTabItem(final CTabFolder item) {
        item.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
            }

            private void UpdateIcons(CTabFolder item2) {
                SOAPTabItem soapview = null;
                try {
                    soapview = (SOAPTabItem)item2.getItem(SOAPTesterMessageSenderView.this.mm_lastfocusTabIndex).getControl();
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                if (soapview != null) {
                    String request = soapview.getRequestSetting().getEditorXML().getText();
                    String response = soapview.getResponseSetting().getEditorXML().getText();
                    if (request != null && request.length() > 0 && !request.equals("Empty.")) {
                        SOAPTesterMessageSenderView.this.mm_sendAction.setEnabled(true);
                    } else {
                        SOAPTesterMessageSenderView.this.mm_sendAction.setEnabled(false);
                    }
                    if (response != null && response.length() > 0 && !response.equals("Empty.")) {
                        SOAPTesterMessageSenderView.this.mm_saveAction.setEnabled(true);
                    } else {
                        SOAPTesterMessageSenderView.this.mm_saveAction.setEnabled(false);
                    }
                }
            }

            public void focusLost(FocusEvent arg0) {
                SOAPTesterMessageSenderView.this.mm_lastfocusTabIndex = item.getSelectionIndex();
                this.UpdateIcons(item);
            }
        });
    }

    private void updateTabName() {
        if (this.mm_tabFolder != null) {
            CTabItem[] array = this.mm_tabFolder.getItems();
            int i = 0;
            while (i < array.length) {
                CTabItem item = array[i];
                String name = "" + (i + 1) + " - " + ((SOAPTabItem)item.getControl()).getName();
                item.setText(name);
                ++i;
            }
        }
    }

    public Action getSaveAction() {
        return this.mm_saveAction;
    }

    public Action getSendAction() {
        return this.mm_sendAction;
    }
}

