/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.ep.webservices.ui.listeners;

import com.sap.netweaver.ep.webservices.sender.DataTreeItem;
import com.sap.netweaver.ep.webservices.sender.OperationDescriptor;
import com.sap.netweaver.ep.webservices.ui.listeners.GenericAction;
import com.sap.netweaver.ep.webservices.ui.views.SOAPTesterMessageSenderView;
import com.sap.netweaver.ep.webservices.ui.views.UIGroupTabbed;
import com.sap.netweaver.ep.webservices.ui.views.XMLTree;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import com.sapportals.portal.prt.service.soap.util.ToolKit;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class SetArraySizeAction
extends GenericAction
implements SelectionListener {
    public SetArraySizeAction(SOAPTesterMessageSenderView parent) {
        super(parent);
    }

    public void widgetSelected(SelectionEvent arg0) {
        TreeItem[] items;
        UIGroupTabbed requestSetting = this.m_uiInstance.getCurrentSOAPTabItem().getRequestSetting();
        Tree xmlTree = requestSetting.getTreeMessage().getXmlTree();
        InputDialog input = new InputDialog(xmlTree.getShell(), "Array Setting", "Enter the number of items :", "1", new IInputValidator(){

            public String isValid(String arg0) {
                try {
                    Integer.parseInt(arg0);
                    return null;
                }
                catch (NumberFormatException e) {
                    return "Entry not valid !";
                }
            }
        });
        int return_ = input.open();
        if (return_ == 0 && (items = xmlTree.getSelection()).length == 1) {
            if (items[0].getItemCount() > 0) {
                HashMap nodes = requestSetting.getTreeMessage().getTreeItemToXML();
                if (nodes.containsKey(items[0].getItems()[0])) {
                    SOAPElement element = (SOAPElement)nodes.get(items[0].getItems()[0]);
                    SOAPElement parent = element.getParentElement();
                    Iterator iter = parent.getChildElements();
                    SOAPElement childSave = null;
                    int count = 0;
                    try {
                        while (iter.hasNext()) {
                            SOAPElement child = (SOAPElement)iter.next();
                            child.detachNode();
                            child.setParentElement(null);
                            if (count == 0) {
                                childSave = child;
                            }
                            ++count;
                        }
                    }
                    catch (SOAPException e1) {
                        e1.printStackTrace();
                    }
                    this.updateArrayNodeAndUI(requestSetting, input, parent, childSave);
                }
            } else {
                HashMap nodes = requestSetting.getTreeMessage().getTreeItemToXML();
                if (nodes.containsKey(items[0])) {
                    SOAPElement element = (SOAPElement)nodes.get(items[0]);
                    int nbNewElement = Integer.parseInt(input.getValue());
                    if (nbNewElement > 0) {
                        DataTreeItem dsubitem;
                        String itemName;
                        if (this.m_uiInstance.getCurrentSOAPTabItem().getMessageSenderViewInstance().getCurrentSOAPOperation().getDescriptor() == null) {
                            return;
                        }
                        OperationDescriptor operation = this.m_uiInstance.getCurrentSOAPTabItem().getMessageSenderViewInstance().getCurrentSOAPOperation().getDescriptor();
                        DataTreeItem ditem = (DataTreeItem)operation.getDescriptorParams().get(element.getElementName().getLocalName());
                        if (ditem != null && ditem.getSchemaNode() != null && (itemName = ditem.getSchemaNode().getArrayItemName()) != null && (dsubitem = (DataTreeItem)operation.getDescriptorParams().get(itemName)) != null) {
                            this.updateArrayNodeAndUI(requestSetting, input, element, dsubitem.getSoapelement().getElement());
                        }
                    }
                }
            }
        }
    }

    private void updateArrayNodeAndUI(UIGroupTabbed requestSetting, InputDialog input, SOAPElement parent, SOAPElement childSave) {
        try {
            int nbNewElement = Integer.parseInt(input.getValue());
            int i = 0;
            while (i < nbNewElement) {
                this.copyNode(parent, childSave);
                ++i;
            }
            Iterator iter1 = parent.getAllAttributes();
            while (iter1.hasNext()) {
                Name attr = (Name)iter1.next();
                if (!attr.getLocalName().equals("arrayType")) continue;
                String value = parent.getAttributeValue(attr);
                value = value.substring(0, value.indexOf("[") + 1) + nbNewElement + value.substring(value.indexOf("]"), value.length());
                parent.removeAttribute(attr);
                parent.addAttribute(attr, value);
                break;
            }
            requestSetting.getEditorXML().setText(this.m_uiInstance.getCurrentSOAPTabItem().getMessageSenderViewInstance().getCurrentSOAPOperation().getSoapmsg().getSOAPPart().getEnvelope().toString());
            XMLTree.constructXMLTree(requestSetting.getTreeMessage(), this.m_uiInstance.getCurrentSOAPTabItem().getMessageSenderViewInstance().getCurrentSOAPOperation(), true);
            requestSetting.getTreeMessage().getXmlTree().redraw();
            requestSetting.getTreeMessage().getXmlTree().update();
        }
        catch (Exception e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
        }
    }

    private void copyNode(SOAPElement destination, SOAPElement source) {
        Name name = source.getElementName();
        try {
            SOAPElement copy = destination.addChildElement(name);
            if (source.getValue() != null) {
                copy.addTextNode(source.getValue());
            }
            Iterator iterator = source.getAllAttributes();
            while (iterator.hasNext()) {
                Name element = (Name)iterator.next();
                String value = source.getAttributeValue(element);
                copy.addAttribute(element, value);
            }
            int nbChilds = ToolKit.countItem((Iterator)source.getChildElements());
            if (nbChilds > 0) {
                Iterator iterChilds = source.getChildElements();
                while (iterChilds.hasNext()) {
                    SOAPElement element = (SOAPElement)iterChilds.next();
                    this.copyNode(copy, element);
                }
            }
        }
        catch (SOAPException e) {
            SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }
}

