/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.ep.webservices.ui.listeners;

import com.sap.netweaver.ep.webservices.sender.MessageBuilder;
import com.sap.netweaver.ep.webservices.sender.MessageSender;
import com.sap.netweaver.ep.webservices.sender.OperationDescriptor;
import com.sap.netweaver.ep.webservices.sender.SOAPMessageDescriptor;
import com.sap.netweaver.ep.webservices.ui.listeners.GenericBarAction;
import com.sap.netweaver.ep.webservices.ui.views.SOAPTabItem;
import com.sap.netweaver.ep.webservices.ui.views.SOAPTesterMessageSenderView;
import com.sap.netweaver.ep.webservices.ui.views.UIGroupTabbed;
import com.sap.netweaver.ep.webservices.ui.views.XMLColor;
import com.sap.netweaver.ep.webservices.ui.views.XMLTree;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.io.ByteArrayInputStream;
import java.util.Iterator;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class SendMessageAction
extends GenericBarAction {
    private Throwable mm_currentException = null;

    public SendMessageAction(SOAPTesterMessageSenderView parent) {
        super(parent);
    }

    public void run() {
        this.mm_currentException = null;
        if (this.m_uiInstance.getCurrentSOAPTabItem().getMessageSenderViewInstance().getCurrentSOAPOperation() != null) {
            this.m_uiInstance.getCurrentSOAPTabItem().getProgressBar().setVisible(true);
            BgProcess thread = new BgProcess();
            this.m_uiInstance.getCurrentSOAPTabItem().setCurrentBGProcess(thread);
            thread.start();
        }
    }

    class BgProcessUI
    implements Runnable {
        MessageSender sender = this.sender;
        MimeHeaders headers = null;
        UIGroupTabbed responseSetting = null;
        OperationDescriptor oper = null;
        SOAPTabItem soapview = null;

        public BgProcessUI(MimeHeaders headers) {
            this.headers = headers;
            this.responseSetting = SendMessageAction.this.m_uiInstance.getCurrentSOAPTabItem().getResponseSetting();
            this.oper = SendMessageAction.this.m_uiInstance.getCurrentSOAPOperation().getDescriptor();
            this.soapview = SendMessageAction.this.m_uiInstance.getCurrentSOAPTabItem();
        }

        public void run() {
            try {
                if (this.soapview == null || this.soapview.isDisposed()) {
                    return;
                }
                if (SendMessageAction.this.mm_currentException != null) {
                    Tree response = this.responseSetting.getTreeMessage().getXmlTree();
                    response.removeAll();
                    TreeItem error = new TreeItem(response, 0);
                    error.setText(SendMessageAction.this.mm_currentException.toString());
                    response.setSelection(new TreeItem[]{error});
                    return;
                }
                if (this.sender.getResponse() != null) {
                    SOAPMessage msg = MessageBuilder.getInstance().constructSOAPMessage(this.headers, new ByteArrayInputStream(this.sender.getResponse().getBytes()));
                    this.responseSetting.getEditorXML().setText(msg.getSOAPPart().getEnvelope().toString());
                } else {
                    this.responseSetting.getEditorXML().setText(this.sender.getResponse());
                }
                XMLColor.colorXml(this.responseSetting.getEditorXML());
                XMLTree.constructXMLTree(this.responseSetting.getTreeMessage(), this.sender.getResponse(), this.oper.getUrl(), this.sender.getHeadersReturn(), this.oper.getStyle(), this.oper.getEncodingStyle(), false);
                Table httpHeaders = this.responseSetting.getEditorHTTP();
                httpHeaders.removeAll();
                MimeHeaders mimes = this.sender.getHeadersReturn();
                Iterator iter = mimes.getAllHeaders();
                while (iter.hasNext()) {
                    MimeHeader element = (MimeHeader)iter.next();
                    TableItem item = new TableItem(httpHeaders, 0);
                    item.setText(new String[]{element.getName(), element.getValue()});
                }
                this.soapview.getMessageSenderViewInstance().getSaveAction().setEnabled(true);
                this.soapview.getProgressBar().setVisible(false);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
                Tree response = this.responseSetting.getTreeMessage().getXmlTree();
                response.removeAll();
                TreeItem error = new TreeItem(response, 0);
                error.setText("The SOAP message returned is not well formed.");
                TreeItem suberror = new TreeItem(error, 0);
                suberror.setText(e.toString());
                response.setSelection(new TreeItem[]{suberror});
                this.soapview.getProgressBar().setVisible(false);
            }
        }

        public void setSender(MessageSender sender) {
            this.sender = sender;
        }
    }

    class BgProcess
    extends Thread {
        Display display = null;
        SOAPTabItem instanceLock = null;
        UIGroupTabbed requestSetting = null;
        UIGroupTabbed responseSetting = null;
        TableItem[] items = null;
        MimeHeaders headers = null;
        String msgXML = null;
        SOAPMessageDescriptor op = null;
        MessageSender sender = null;
        BgProcessUI uiUpdate = null;

        public BgProcess() {
            this.display = SendMessageAction.this.m_uiInstance.getCurrentSOAPTabItem().getResponseSetting().getTabContainer().getDisplay();
            this.instanceLock = SendMessageAction.this.m_uiInstance.getCurrentSOAPTabItem();
            this.requestSetting = this.instanceLock.getRequestSetting();
            this.responseSetting = this.instanceLock.getResponseSetting();
            this.msgXML = this.requestSetting.getEditorXML().getText();
            this.op = this.instanceLock.getMessageSenderViewInstance().getCurrentSOAPOperation();
            this.items = this.requestSetting.getEditorHTTP().getItems();
            this.headers = new MimeHeaders();
            int i = 0;
            while (i < this.items.length) {
                String name = this.items[i].getText(0);
                String value = this.items[i].getText(1);
                this.headers.addHeader(name.length() == 0 ? "\"\"" : name, value.length() == 0 ? "\"\"" : value);
                ++i;
            }
            this.setPriority(7);
            this.setName("Portal WebService Checker BgProcess(send id:" + this.instanceLock.getName() + ")");
            this.uiUpdate = new BgProcessUI(this.headers);
        }

        public void run() {
            try {
                this.sender = new MessageSender(this.msgXML, this.op, this.headers);
                this.sender.send();
                this.uiUpdate.setSender(this.sender);
                this.display.asyncExec((Runnable)this.uiUpdate);
            }
            catch (Throwable e) {
                SendMessageAction.this.mm_currentException = e;
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            }
        }
    }
}

