/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.ep.webservices.ui.listeners;

import com.sap.netweaver.ep.webservices.tester.URLHistoryManager;
import com.sap.netweaver.ep.webservices.ui.listeners.GenericBarAction;
import com.sap.netweaver.ep.webservices.ui.views.SOAPTabItem;
import com.sap.netweaver.ep.webservices.ui.views.SOAPTesterMessageSenderView;
import com.sap.netweaver.ep.webservices.wsdl.WSDLDescriptor;
import com.sap.netweaver.ep.webservices.wsdl.WSDLProcessManager;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class GetWSDLFileAction
extends GenericBarAction {
    public static final Image WSDL_ICON = SOAPTesterMessageSenderView.getImageDescriptor("wsdl.gif").createImage();
    public static final Image PORT_ICON = SOAPTesterMessageSenderView.getImageDescriptor("port.gif").createImage();
    public static final Image METHOD_ICON = SOAPTesterMessageSenderView.getImageDescriptor("method.gif").createImage();
    public static final Image SELECTED_ICON = SOAPTesterMessageSenderView.getImageDescriptor("selected.gif").createImage();
    private WSDLProcessManager mm_wsdlGenerator;

    public GetWSDLFileAction(SOAPTesterMessageSenderView parent) {
        super(parent);
    }

    public void run() {
        this.m_uiInstance.getCurrentSOAPTabItem().getProgressBar().setVisible(true);
        String urlEntry = this.m_uiInstance.getCurrentSOAPTabItem().getUrlTextEntry().getText();
        this.mm_wsdlGenerator = new WSDLProcessManager();
        this.m_uiInstance.setWsdlGenerator(this.mm_wsdlGenerator);
        this.m_uiInstance.getCurrentSOAPTabItem().setWsdlGenerator(this.mm_wsdlGenerator);
        BgProcess thread = new BgProcess();
        this.m_uiInstance.getCurrentSOAPTabItem().setCurrentBGProcess(thread);
        thread.start();
        try {
            new URL(urlEntry);
            URLHistoryManager.getInstance().addNewURL(urlEntry);
            String[] urls = URLHistoryManager.getInstance().getURLSStored();
            if (urls != null && urls.length != 0) {
                this.m_uiInstance.getCurrentSOAPTabItem().getUrlTextEntry().setItems(urls);
                this.m_uiInstance.getCurrentSOAPTabItem().getUrlTextEntry().setText(urlEntry);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    class BgProcess
    extends Thread {
        Display display = null;
        String urlEntry = null;
        WSDLDescriptor wsdlDesc = null;
        BgProcessUI bgui = null;
        Throwable exception = null;

        public BgProcess() {
            this.display = GetWSDLFileAction.this.m_uiInstance.getCurrentSOAPTabItem().getWsldTree().getDisplay();
            this.urlEntry = GetWSDLFileAction.this.m_uiInstance.getCurrentSOAPTabItem().getUrlTextEntry().getText();
            this.bgui = new BgProcessUI(this, GetWSDLFileAction.this.m_uiInstance.getCurrentSOAPTabItem(), GetWSDLFileAction.this.m_uiInstance.getCurrentTabItem());
            this.setPriority(7);
            this.setName("Portal WebService Checker BgProcess(get wsdl id:" + GetWSDLFileAction.this.m_uiInstance.getCurrentSOAPTabItem().getName() + ")");
        }

        public void run() {
            try {
                URL url = new URL(this.urlEntry);
                this.wsdlDesc = GetWSDLFileAction.this.mm_wsdlGenerator.readWSDLUrl(url);
            }
            catch (Throwable e) {
                this.exception = e;
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                SapPortalPluginsLogger.logError((Object)this, (Throwable)e);
            }
            this.display.asyncExec((Runnable)this.bgui);
        }

        public WSDLDescriptor getWsdlDesc() {
            return this.wsdlDesc;
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    class BgProcessUI
    implements Runnable {
        BgProcess process = null;
        SOAPTabItem currentItem = null;
        String urlEntry = null;
        Tree wsldTree = null;
        CTabItem currentCtabItem = null;
        WSDLDescriptor wsdlDesc = null;
        int icurrent = -1;

        public BgProcessUI(BgProcess process, SOAPTabItem item, CTabItem citem) {
            this.process = process;
            this.currentItem = item;
            this.currentCtabItem = citem;
            this.wsdlDesc = process.getWsdlDesc();
        }

        public void run() {
            if (this.currentItem == null || this.currentItem.isDisposed()) {
                return;
            }
            if (this.currentItem.getUrlTextEntry() == null || this.currentItem.getUrlTextEntry().isDisposed()) {
                return;
            }
            if (this.currentItem.getWsldTree() == null || this.currentItem.getWsldTree().isDisposed()) {
                return;
            }
            if (this.currentCtabItem == null || this.currentCtabItem.isDisposed()) {
                return;
            }
            this.urlEntry = this.currentItem.getUrlTextEntry().getText();
            this.wsldTree = this.currentItem.getWsldTree();
            this.icurrent = GetWSDLFileAction.this.m_uiInstance.getCurrentIndexTabItem();
            if (this.process.getException() != null) {
                this.wsldTree.removeAll();
                TreeItem error = new TreeItem(this.wsldTree, 0);
                error.setText(this.process.getException().toString());
                this.wsldTree.setSelection(new TreeItem[]{error});
                this.wsldTree.showSelection();
                this.currentItem.getProgressBar().setVisible(false);
                return;
            }
            this.wsdlDesc = this.process.getWsdlDesc();
            this.currentCtabItem.setText("" + (this.icurrent + 1) + " - " + this.wsdlDesc.getName());
            this.currentItem.setName(this.wsdlDesc.getName());
            this.currentCtabItem.setToolTipText(this.wsdlDesc.getUrlEndPoint().toString());
            this.wsldTree.removeAll();
            TreeItem root = new TreeItem(this.wsldTree, 0);
            root.setImage(WSDL_ICON);
            root.setText(this.wsdlDesc.getName() == null ? this.wsdlDesc.getUrlEndPoint().toString() : this.wsdlDesc.getName());
            TreeItem[] content = new TreeItem[this.wsdlDesc.getOperations().length];
            HashMap<String, TreeItem> portypes = new HashMap<String, TreeItem>();
            int numMethod = 0;
            int i = 0;
            while (i < this.wsdlDesc.getOperations().length) {
                TreeItem subitem;
                TreeItem item;
                if (portypes.containsKey(this.wsdlDesc.getOperations()[i].getPortType())) {
                    item = (TreeItem)portypes.get(this.wsdlDesc.getOperations()[i].getPortType());
                    subitem = new TreeItem(item, 0);
                    item.setData((Object)new Boolean(false));
                    subitem.setData("methodNum", (Object)(numMethod + ""));
                    ++numMethod;
                    subitem.setText(this.wsdlDesc.getOperations()[i].getName());
                    subitem.setForeground(root.getDisplay().getSystemColor(10));
                    subitem.setImage(METHOD_ICON);
                    subitem.setData((Object)new Boolean(true));
                } else {
                    item = new TreeItem(root, 0);
                    item.setText(this.wsdlDesc.getOperations()[i].getPortType());
                    item.setForeground(root.getDisplay().getSystemColor(9));
                    portypes.put(this.wsdlDesc.getOperations()[i].getPortType(), item);
                    item.setImage(PORT_ICON);
                    item.setData((Object)new Boolean(false));
                    subitem = new TreeItem(item, 0);
                    subitem.setData("methodNum", (Object)"0");
                    numMethod = 1;
                    subitem.setText(this.wsdlDesc.getOperations()[i].getName());
                    subitem.setForeground(root.getDisplay().getSystemColor(10));
                    subitem.setData((Object)new Boolean(true));
                    subitem.setImage(METHOD_ICON);
                    content[i] = item;
                }
                ++i;
            }
            if (content[0] != null && content[0].getItemCount() > 0) {
                this.wsldTree.setSelection(content[0].getItems());
            } else {
                this.wsldTree.setSelection(content);
            }
            this.wsldTree.showSelection();
            this.currentItem.getProgressBar().setVisible(false);
        }
    }
}

