/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.ep.webservices.ui.listeners;

import com.sap.netweaver.ep.webservices.sender.MessageBuilder;
import com.sap.netweaver.ep.webservices.sender.SOAPMessageDescriptor;
import com.sap.netweaver.ep.webservices.ui.listeners.GenericAction;
import com.sap.netweaver.ep.webservices.ui.listeners.GetWSDLFileAction;
import com.sap.netweaver.ep.webservices.ui.views.SOAPTesterMessageSenderView;
import com.sap.netweaver.ep.webservices.ui.views.UIGroupTabbed;
import com.sap.netweaver.ep.webservices.ui.views.XMLColor;
import com.sap.netweaver.ep.webservices.ui.views.XMLTree;
import com.sap.portal.util.eclipse.SapPortalPluginsLogger;
import javax.xml.soap.SOAPException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TreeItem;

public class CreateSOAPRequestAction
extends GenericAction
implements SelectionListener {
    private TreeItem mm_lastMethodSelected = null;

    public CreateSOAPRequestAction(SOAPTesterMessageSenderView parent) {
        super(parent);
    }

    public void widgetSelected(SelectionEvent arg0) {
        UIGroupTabbed requestSetting = this.m_uiInstance.getCurrentSOAPTabItem().getRequestSetting();
        TreeItem[] nodes = this.m_uiInstance.getCurrentSOAPTabItem().getWsldTree().getSelection();
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i].getForeground().equals((Object)nodes[i].getDisplay().getSystemColor(10))) {
                if (this.mm_lastMethodSelected != null && !this.mm_lastMethodSelected.isDisposed()) {
                    this.mm_lastMethodSelected.setImage(GetWSDLFileAction.METHOD_ICON);
                }
                nodes[i].setImage(GetWSDLFileAction.SELECTED_ICON);
                SOAPMessageDescriptor msg = null;
                try {
                    int methodNum = Integer.parseInt((String)nodes[i].getData("methodNum"));
                    msg = MessageBuilder.getInstance().constructSOAPMessage(requestSetting, this.m_uiInstance.getCurrentSOAPTabItem().getWsdlGenerator().getWsdlGenerator(), nodes[i].getParentItem().getText(), nodes[i].getText(), methodNum);
                    XMLTree.constructXMLTree(requestSetting.getTreeMessage(), msg, true);
                    requestSetting.getEditorXML().setText(msg.getSoapmsg().getSOAPPart().getEnvelope().toString());
                    XMLColor.colorXml(requestSetting.getEditorXML());
                    this.m_uiInstance.getCurrentSOAPTabItem().getMessageSenderViewInstance().setCurrentSOAPOperation(msg);
                    requestSetting.setViewXMLTreeuptodate(true);
                    this.m_uiInstance.getCurrentSOAPTabItem().getTextNodeValue().setFocus();
                    this.m_uiInstance.getSendAction().setEnabled(true);
                    this.mm_lastMethodSelected = nodes[i];
                }
                catch (SOAPException e1) {
                    requestSetting.getEditorXML().setText(e1.toString());
                    requestSetting.getEditorXML().setFocus();
                    requestSetting.getTabContainer().setSelection(1);
                    requestSetting.getTabContainer().forceFocus();
                    SapPortalPluginsLogger.logError((Object)this, (Throwable)e1);
                    this.m_uiInstance.getSendAction().setEnabled(false);
                }
                catch (Throwable e1) {
                    SapPortalPluginsLogger.logError((Object)this, (Throwable)e1);
                    requestSetting.getEditorXML().setText(e1.toString());
                    requestSetting.getEditorXML().setFocus();
                    requestSetting.getTabContainer().setSelection(1);
                    requestSetting.getTabContainer().forceFocus();
                    this.m_uiInstance.getSendAction().setEnabled(false);
                }
            }
            ++i;
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }
}

