/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.ep.webservices.tester;

import com.sap.netweaver.ep.webservices.tester.SOAPTesterPlugin;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;

public class URLHistoryManager {
    private static final int MAX_URL_STORED = 10;
    private static final String ID_PROPERTY = "URLS_WEBSERVICES_TESTER";
    private static final String DELIMITER = ";";
    private static URLHistoryManager mm_instance = null;

    private URLHistoryManager() {
    }

    public static URLHistoryManager getInstance() {
        if (mm_instance == null) {
            mm_instance = new URLHistoryManager();
        }
        return mm_instance;
    }

    public String[] getURLSStored() {
        IPreferenceStore storage = SOAPTesterPlugin.getDefault().getPreferenceStore();
        String value = storage.getString(ID_PROPERTY);
        if (value == null) {
            return null;
        }
        StringTokenizer parser = new StringTokenizer(value, DELIMITER);
        String[] urls = new String[parser.countTokens()];
        int i = 0;
        while (i < urls.length) {
            urls[i] = parser.nextToken();
            ++i;
        }
        return urls;
    }

    public void addNewURL(String url) {
        IPreferenceStore storage = SOAPTesterPlugin.getDefault().getPreferenceStore();
        String value = storage.getString(ID_PROPERTY);
        if (value == null) {
            value = url;
        } else {
            StringTokenizer parser = new StringTokenizer(value, DELIMITER);
            ArrayList<String> urls = new ArrayList<String>();
            while (parser.hasMoreTokens()) {
                urls.add(parser.nextToken());
            }
            if (!urls.contains(url.toString())) {
                if (urls.size() > 10) {
                    urls.remove(urls.size() - 1);
                    urls.add(0, url);
                } else {
                    urls.add(0, url);
                }
            }
            storage.setValue(ID_PROPERTY, this.convertArrayList(urls));
        }
    }

    private String convertArrayList(ArrayList list) {
        String urls = "";
        int i = 0;
        while (i < list.size() - 1) {
            urls = urls + list.get(i) + DELIMITER;
            ++i;
        }
        urls = urls + list.get(list.size() - 1);
        return urls;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("URLHistoryManager[");
        buffer.append("MAX_URL_STORED = ").append(10);
        buffer.append(", ID_PROPERTY = ").append(ID_PROPERTY);
        buffer.append(", DELIMITER = ").append(DELIMITER);
        buffer.append(", mm_instance = ").append(mm_instance);
        buffer.append("]");
        return buffer.toString();
    }
}

