/*
 * Decompiled with CFR 0.152.
 */
package com.sap.netweaver.ep.webservices.sender;

import com.sap.netweaver.ep.webservices.sender.MessageBuilder;
import com.sap.netweaver.ep.webservices.sender.SOAPMessageDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;

public class MessageSender {
    private String mm_url = null;
    private SOAPMessage mm_soapDesc = null;
    private MimeHeaders mm_headers = null;
    private MimeHeaders mm_headersReturn = null;
    private String mm_response = null;

    public MessageSender(String msg, SOAPMessageDescriptor soapDesc, MimeHeaders headers) throws Exception {
        this.mm_url = soapDesc.getDescriptor().getUrl();
        this.mm_headers = headers;
        this.mm_soapDesc = MessageBuilder.getInstance().constructSOAPMessage(headers, new ByteArrayInputStream(msg.getBytes()));
    }

    public void send() throws Exception {
        try {
            URL url = new URL(this.mm_url);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            if (this.mm_headers != null) {
                Iterator iter = this.mm_headers.getAllHeaders();
                while (iter.hasNext()) {
                    MimeHeader element = (MimeHeader)iter.next();
                    connection.setRequestProperty(element.getName(), element.getValue());
                }
                connection.setRequestProperty("Connection", "Close");
                connection.setDoOutput(true);
                PrintWriter pw = new PrintWriter(connection.getOutputStream());
                pw.write(this.mm_soapDesc.getSOAPPart().getEnvelope().toString());
                pw.flush();
            }
            connection.connect();
            InputStream inputStream = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] responseBytes = null;
            try {
                int c;
                inputStream = connection.getInputStream();
                while ((c = inputStream.read()) != -1) {
                    baos.write(c);
                }
                responseBytes = baos.toByteArray();
            }
            catch (IOException ioe) {
                int c;
                inputStream = connection.getErrorStream();
                while ((c = inputStream.read()) != -1) {
                    baos.write(c);
                }
                responseBytes = baos.toByteArray();
            }
            this.mm_response = new String(responseBytes);
            this.mm_headersReturn = new MimeHeaders();
            String key = ((URLConnection)connection).getHeaderField(0);
            this.mm_headersReturn.addHeader(key.length() == 0 ? "_" : key, "_");
            int count = 1;
            key = null;
            while ((key = ((URLConnection)connection).getHeaderFieldKey(count)) != null) {
                String value = connection.getHeaderField(key);
                value = value.length() == 0 ? "_" : value;
                this.mm_headersReturn.addHeader(key.length() == 0 ? "_" : key, value);
                ++count;
            }
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public MimeHeaders getHeadersReturn() {
        return this.mm_headersReturn;
    }

    public String getResponse() {
        return this.mm_response;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MessageSender[");
        buffer.append("mm_url = ").append(this.mm_url);
        buffer.append(", mm_soapDesc = ").append(this.mm_soapDesc);
        buffer.append(", mm_headers = ").append(this.mm_headers);
        buffer.append(", mm_headersReturn = ").append(this.mm_headersReturn);
        buffer.append(", mm_response = ").append(this.mm_response);
        buffer.append("]");
        return buffer.toString();
    }
}

