/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.metrics;

import com.sap.tc.jtools.jlint.jom.metrics.MetricInfo;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Properties;

public class Metric {
    public static final String PARAM_INFO_LEVEL_SUFFIX = "_INFO_LEVEL";
    public static final String PARAM_WARNING_LEVEL_SUFFIX = "_WARNING_LEVEL";
    public static final String PARAM_ERROR_LEVEL_SUFFIX = "_ERROR_LEVEL";
    public static final String PARAM_INTERNAL_DATA = "INTERNAL_DATA";
    public static final String PARAM_METRIC_NAME = "METRIC_NAME";
    public static final String PARAM_SUM = "SUM";
    public static final String PARAM_QUADRATIC_SUM = "QUADRATIC_SUM";
    public static final String PARAM_MIN = "MIN";
    public static final String PARAM_MAX = "MAX";
    public static final String PARAM_COUNT = "COUNT";
    public static final String PARAM_AVERAGE = "AVERAGE";
    public static final String PARAM_STD_DEV = "STD_DEV";
    public static final String PARAM_VALUE = "VALUE";
    private static final int MAX_FRACTION_DIGITS = 2;
    public static final NumberFormat formatter = NumberFormat.getInstance(Locale.ENGLISH);
    private String name;
    private int statistics;
    private float infoThreshold;
    private float warningThreshold;
    private float errorThreshold;
    private boolean infoThresholdSet = false;
    private boolean warningThresholdSet = false;
    private boolean errorThresholdSet = false;
    private int counter = 0;
    private float sum = 0.0f;
    private float quadraticSum = 0.0f;
    private float max = 0.0f;
    private float min = 0.0f;
    private int prio;

    public Metric(MetricInfo metricInfo) {
        this.statistics = metricInfo.getStatistics();
        this.name = metricInfo.getName();
        this.prio = metricInfo.getPriority();
    }

    public void resetValues() {
        this.counter = 0;
        this.sum = 0.0f;
        this.quadraticSum = 0.0f;
        this.max = 0.0f;
        this.min = 0.0f;
    }

    public String getName() {
        return this.name;
    }

    public int addValue(float value) {
        this.max = this.counter == 0 ? value : Math.max(value, this.max);
        this.min = this.counter == 0 ? value : Math.min(value, this.min);
        ++this.counter;
        this.sum += value;
        this.quadraticSum += value * value;
        if (value >= this.errorThreshold && this.errorThresholdSet) {
            return 1;
        }
        if (value >= this.warningThreshold && this.warningThresholdSet) {
            return 2;
        }
        if (value >= this.infoThreshold && this.infoThresholdSet) {
            return 3;
        }
        return -1;
    }

    public void addValues(Properties p) {
        float sum = Float.parseFloat(p.getProperty(PARAM_SUM).trim());
        float quadraticSum = Float.parseFloat(p.getProperty(PARAM_QUADRATIC_SUM).trim());
        float newMin = Float.parseFloat(p.getProperty(PARAM_MIN).trim());
        float newMax = Float.parseFloat(p.getProperty(PARAM_MAX).trim());
        int count = Integer.parseInt(p.getProperty(PARAM_COUNT).trim());
        this.sum += sum;
        this.quadraticSum += quadraticSum;
        this.min = this.counter == 0 ? newMin : Math.min(this.min, newMin);
        this.max = this.counter == 0 ? newMax : Math.max(this.max, newMax);
        this.counter += count;
    }

    public int getStatistics() {
        return this.statistics;
    }

    public int count() {
        return this.counter;
    }

    public float getMax() {
        return this.max;
    }

    public float getMin() {
        return this.min;
    }

    public float getAverage() {
        if (this.counter == 0) {
            return 0.0f;
        }
        return this.sum / (float)this.counter;
    }

    public float getSum() {
        return this.sum;
    }

    public float getStandardDeviation() {
        if (this.counter == 0) {
            return 0.0f;
        }
        float avg = this.getAverage();
        return (float)Math.sqrt(this.quadraticSum / (float)this.counter - avg * avg);
    }

    public void setInfoThreshold(float infoLevel) {
        this.infoThreshold = infoLevel;
        this.infoThresholdSet = true;
    }

    public void setWarningThreshold(float warningLevel) {
        this.warningThreshold = warningLevel;
        this.warningThresholdSet = true;
    }

    public void setErrorThreshold(float errorLevel) {
        this.errorThreshold = errorLevel;
        this.errorThresholdSet = true;
    }

    public Properties getMessageProperties() {
        Properties p = new Properties();
        p.setProperty(PARAM_INTERNAL_DATA, String.valueOf(true));
        p.setProperty(PARAM_METRIC_NAME, this.name);
        p.setProperty(PARAM_SUM, formatter.format(this.sum));
        p.setProperty(PARAM_QUADRATIC_SUM, formatter.format(this.quadraticSum));
        p.setProperty(PARAM_MIN, formatter.format(this.min));
        p.setProperty(PARAM_MAX, formatter.format(this.max));
        p.setProperty(PARAM_COUNT, String.valueOf(this.counter));
        p.setProperty(PARAM_AVERAGE, formatter.format(this.getAverage()));
        p.setProperty(PARAM_STD_DEV, formatter.format(this.getStandardDeviation()));
        return p;
    }

    public int getPriority() {
        return this.prio;
    }

    static {
        formatter.setGroupingUsed(false);
        formatter.setMaximumFractionDigits(2);
    }
}

