/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.metrics;

import com.sap.tc.jtools.jlint.Result;
import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.metrics.Metric;
import com.sap.tc.jtools.jlint.jom.metrics.MetricInfo;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class JomMetricVisitor
extends JomTestVisitor {
    private Metric[] metrics;
    private Map name2MetricMap = new HashMap();
    private static final String MSG_KEY_0 = "metric.0";
    private static final String MSG_KEY_CLASSDATA = "METRIC_CLASS_DATA";
    private static final String MSG_KEY_PREFIX = "metric.";

    public JomMetricVisitor() {
        MetricInfo[] metricInfos = this.getMetricInfos();
        if (metricInfos == null || metricInfos.length == 0) {
            throw new IllegalArgumentException("getMetricInfos() must not return null or an empty array!");
        }
        this.metrics = new Metric[metricInfos.length];
        int i = 0;
        while (i < metricInfos.length) {
            this.metrics[i] = new Metric(metricInfos[i]);
            this.name2MetricMap.put(metricInfos[i].getName(), this.metrics[i]);
            ++i;
        }
    }

    protected abstract MetricInfo[] getMetricInfos();

    protected final void addMetricValue(String metricName, float value, Position pos) {
        Metric metric = this.getMetric(metricName);
        int severity = metric.addValue(value);
        if (severity != -1 && metric.getPriority() <= 3) {
            Properties msgProps = new Properties();
            msgProps.setProperty("VALUE", Metric.formatter.format(value));
            msgProps.setProperty("METRIC_NAME", metric.getName());
            this.addError(MSG_KEY_0, "", msgProps, severity, pos);
        }
    }

    public void setParameters(ParameterInterface[] parameters, TestObject testObject) {
        super.setParameters(parameters, testObject);
        int i = 0;
        while (i < this.metrics.length) {
            ParameterInterface errorParam;
            ParameterInterface warningParam;
            String upperCaseName = this.metrics[i].getName().toUpperCase();
            ParameterInterface infoParam = this.getParameter(upperCaseName + "_INFO_LEVEL");
            if (infoParam != null && "FLOAT".equals(infoParam.getType())) {
                this.metrics[i].setInfoThreshold(((Float)infoParam.getValue()).floatValue());
            }
            if ((warningParam = this.getParameter(upperCaseName + "_WARNING_LEVEL")) != null && "FLOAT".equals(warningParam.getType())) {
                this.metrics[i].setWarningThreshold(((Float)warningParam.getValue()).floatValue());
            }
            if ((errorParam = this.getParameter(upperCaseName + "_ERROR_LEVEL")) != null && "FLOAT".equals(errorParam.getType())) {
                this.metrics[i].setErrorThreshold(((Float)errorParam.getValue()).floatValue());
            }
            ++i;
        }
    }

    public final void postVisit(ICompilationUnit unit) {
        int i = 0;
        while (i < this.metrics.length) {
            if (this.metrics[i].count() > 0) {
                this.addError(MSG_KEY_CLASSDATA, "", this.metrics[i].getMessageProperties(), this.metrics[i].getPriority(), null);
            }
            this.metrics[i].resetValues();
            ++i;
        }
    }

    public final ResultInterface[] processErrors(ResultInterface[] results) {
        ArrayList<Object> newResults = new ArrayList<Object>();
        String myName = this.getName();
        int i = 0;
        while (i < this.metrics.length) {
            this.metrics[i].resetValues();
            ++i;
        }
        int i2 = 0;
        while (i2 < results.length) {
            if (myName.equals(results[i2].getTestName())) {
                Properties props = results[i2].getErrorParameters();
                if (props.getProperty("INTERNAL_DATA") == null) {
                    newResults.add(results[i2]);
                } else {
                    try {
                        Metric metric = this.getMetric(props.getProperty("METRIC_NAME"));
                        metric.addValues(props);
                    }
                    catch (Exception e) {
                        this.logException(e);
                    }
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.metrics.length) {
            if (this.metrics[i3].count() != 0) {
                Properties msgProps = this.metrics[i3].getMessageProperties();
                msgProps.setProperty("__MSG_KEY", MSG_KEY_PREFIX + this.metrics[i3].getStatistics());
                newResults.add(new Result(this.getName(), "Java file list", "", null, this.metrics[i3].getPriority(), "", msgProps));
            }
            ++i3;
        }
        return newResults.toArray(new ResultInterface[0]);
    }

    private Metric getMetric(String name) {
        Metric m = (Metric)this.name2MetricMap.get(name);
        if (m == null) {
            throw new IllegalArgumentException("unknown metric: " + name);
        }
        return m;
    }
}

