/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.ArrayTypeFromTypeReference;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SimpleTypeFromTypeReference;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SourceContent;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.VariableBinding;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.Wrapper;
import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IType;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclarationStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class VariableDeclarationStatement
implements IVariableDeclarationStatement {
    private AbstractVariableDeclaration decl;
    private BlockScope scope;
    private SourceContent source;
    private IType type;
    private IExpression initializer;
    private IComment[] comments;
    private IComment endOfLineComment;
    private boolean commentParsed = false;

    public VariableDeclarationStatement(AbstractVariableDeclaration decl, BlockScope scope, SourceContent source) {
        this.decl = decl;
        this.scope = scope;
        this.source = source;
    }

    public int getNodeType() {
        return 57;
    }

    public int getModifiers() {
        return this.decl.modifiers;
    }

    public IType getType() {
        if (this.type == null) {
            TypeReference tr = this.decl.type;
            if (tr.dimensions() == 0) {
                this.type = new SimpleTypeFromTypeReference(tr);
            } else if (tr instanceof ArrayTypeReference) {
                this.type = new ArrayTypeFromTypeReference((ArrayTypeReference)tr);
            } else if (tr instanceof ArrayQualifiedTypeReference) {
                this.type = new ArrayTypeFromTypeReference((ArrayQualifiedTypeReference)tr);
            }
        }
        return this.type;
    }

    public String getName() {
        return new String(this.decl.name);
    }

    public IExpression getInitializer() {
        if (this.initializer == null && this.decl.initialization != null) {
            this.initializer = Wrapper.wrapExpression(this.decl.initialization, this.scope, this.source);
        }
        return this.initializer;
    }

    public IVariableBinding resolveBinding() {
        if (this.decl instanceof FieldDeclaration) {
            return new VariableBinding((org.eclipse.jdt.internal.compiler.lookup.VariableBinding)((FieldDeclaration)this.decl).binding);
        }
        if (this.decl instanceof LocalDeclaration) {
            return new VariableBinding((org.eclipse.jdt.internal.compiler.lookup.VariableBinding)((LocalDeclaration)this.decl).binding);
        }
        return null;
    }

    public int getStartPosition() {
        return this.decl.sourceStart;
    }

    public void traverse(IVisitor visitor) {
        if (visitor.visit(this)) {
            this.getType().traverse(visitor);
            IExpression init = this.getInitializer();
            if (init != null) {
                init.traverse(visitor);
            }
        }
        visitor.endVisit(this);
    }

    public IComment[] getComments() {
        if (this.comments == null) {
            this.comments = this.source.getBlockComment(this.decl.declarationSourceEnd + 1);
        }
        return this.comments;
    }

    public IComment getEndOfLineComment() {
        if (!this.commentParsed) {
            this.endOfLineComment = this.source.getEndOfLineComment(this.decl.declarationSourceEnd + 1);
            this.commentParsed = true;
        }
        return this.endOfLineComment;
    }
}

