/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.Block;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.CatchClause;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SourceContent;
import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.ITryStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class TryStatement
implements ITryStatement {
    private org.eclipse.jdt.internal.compiler.ast.TryStatement ts;
    private BlockScope scope;
    private SourceContent source;
    private IBlock body;
    private List catchClauses;
    private IBlock finalBlock;
    private IComment[] comments;
    private IComment endOfLineComment;
    private boolean commentParsed = false;

    public TryStatement(org.eclipse.jdt.internal.compiler.ast.TryStatement ts, BlockScope scope, SourceContent source) {
        this.ts = ts;
        this.scope = scope;
        this.source = source;
    }

    public int getNodeType() {
        return 52;
    }

    public IBlock getBody() {
        if (this.body == null) {
            this.body = new Block(this.ts.tryBlock, this.source);
        }
        return this.body;
    }

    public List catchClauses() {
        if (this.catchClauses == null) {
            this.catchClauses = new Vector();
            Argument[] arguments = this.ts.catchArguments;
            org.eclipse.jdt.internal.compiler.ast.Block[] blocks = this.ts.catchBlocks;
            if (arguments != null) {
                int i = 0;
                while (i < arguments.length) {
                    this.catchClauses.add(new CatchClause(arguments[i], blocks[i], this.scope, this.source));
                    ++i;
                }
            }
        }
        return this.catchClauses;
    }

    public IBlock getFinally() {
        if (this.ts.finallyBlock == null) {
            return null;
        }
        if (this.finalBlock == null) {
            this.finalBlock = new Block(this.ts.finallyBlock, this.source);
        }
        return this.finalBlock;
    }

    public int getStartPosition() {
        return this.ts.sourceStart;
    }

    public void traverse(IVisitor visitor) {
        if (visitor.visit(this)) {
            IBlock finallyBlock;
            this.getBody().traverse(visitor);
            List catchArguments = this.catchClauses();
            if (catchArguments != null) {
                Iterator iterator = catchArguments.iterator();
                while (iterator.hasNext()) {
                    ((Traversable)iterator.next()).traverse(visitor);
                }
            }
            if ((finallyBlock = this.getFinally()) != null) {
                finallyBlock.traverse(visitor);
            }
        }
        visitor.endVisit(this);
    }

    public IComment[] getComments() {
        if (this.comments == null) {
            this.comments = this.source.getBlockComment(this.ts.sourceEnd + 1);
        }
        return this.comments;
    }

    public IComment getEndOfLineComment() {
        if (!this.commentParsed) {
            this.endOfLineComment = this.source.getEndOfLineComment(this.ts.sourceEnd + 1);
            this.commentParsed = true;
        }
        return this.endOfLineComment;
    }
}

