/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SourceContent;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.Wrapper;
import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.ISwitchStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class SwitchStatement
implements ISwitchStatement {
    private org.eclipse.jdt.internal.compiler.ast.SwitchStatement ss;
    private BlockScope scope;
    private SourceContent source;
    private IExpression expr;
    private List stmts;
    private IComment[] comments;
    private IComment endOfLineComment;
    private boolean commentParsed = false;

    public SwitchStatement(org.eclipse.jdt.internal.compiler.ast.SwitchStatement ss, BlockScope scope, SourceContent source) {
        this.ss = ss;
        this.scope = scope;
        this.source = source;
    }

    public int getNodeType() {
        return 48;
    }

    public IExpression getExpression() {
        if (this.expr == null) {
            this.expr = Wrapper.wrapExpression(this.ss.testExpression, this.scope, this.source);
        }
        return this.expr;
    }

    public List statements() {
        if (this.stmts == null) {
            Statement[] statements = this.ss.statements;
            this.stmts = new Vector();
            if (statements != null) {
                int i = 0;
                while (i < statements.length) {
                    this.stmts.add(Wrapper.wrapStatement(statements[i], this.scope, this.source));
                    ++i;
                }
            }
        }
        return this.stmts;
    }

    public int getStartPosition() {
        return this.ss.sourceStart;
    }

    public IComment[] getComments() {
        if (this.comments == null) {
            this.comments = this.source.getBlockComment(this.ss.sourceEnd);
        }
        return this.comments;
    }

    public IComment getEndOfLineComment() {
        if (!this.commentParsed) {
            this.endOfLineComment = this.source.getEndOfLineComment(this.ss.sourceEnd);
            this.commentParsed = true;
        }
        return this.endOfLineComment;
    }

    public void traverse(IVisitor visitor) {
        if (visitor.visit(this)) {
            this.getExpression().traverse(visitor);
            List statements = this.statements();
            if (statements != null) {
                Iterator iterator = statements.iterator();
                while (iterator.hasNext()) {
                    ((Traversable)iterator.next()).traverse(visitor);
                }
            }
        }
        visitor.endVisit(this);
    }
}

