/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.BindingFactory;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.MethodBinding;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.VariableBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class ReferenceTypeBinding
implements IReferenceTypeBinding {
    private ReferenceBinding binding;
    private String name = null;

    public ReferenceTypeBinding(ReferenceBinding binding) {
        this.binding = binding;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isNullType() {
        return this.binding.equals(BaseTypes.NullBinding);
    }

    public boolean isArray() {
        return false;
    }

    public boolean isClass() {
        return this.binding.isClass();
    }

    public boolean isInterface() {
        return this.binding.isInterface();
    }

    public String getIdentifier() {
        if (this.isAnonymous()) {
            if (this.binding.superInterfaces() == TypeConstants.NoSuperInterfaces) {
                return "<" + new String(this.binding.superclass().readableName()) + ">";
            }
            return "<" + new String(this.binding.superInterfaces()[0].readableName()) + ">";
        }
        String name = new String(this.binding.sourceName());
        return name;
    }

    public IPackageBinding getPackage() {
        return BindingFactory.getPackageBinding(this.binding.getPackage());
    }

    public IReferenceTypeBinding getDeclaringClass() {
        return BindingFactory.getReferenceTypeBinding(this.binding.enclosingType());
    }

    public IReferenceTypeBinding getSuperclass() {
        ReferenceBinding superBinding = this.binding.superclass();
        return BindingFactory.getReferenceTypeBinding(superBinding);
    }

    public IReferenceTypeBinding[] getInterfaces() {
        ReferenceBinding[] superBindings = this.binding.superInterfaces();
        if (superBindings == null) {
            return null;
        }
        IReferenceTypeBinding[] out = new IReferenceTypeBinding[superBindings.length];
        int i = 0;
        while (i < out.length) {
            out[i] = BindingFactory.getReferenceTypeBinding(superBindings[i]);
            ++i;
        }
        return out;
    }

    public int getModifiers() {
        return this.binding.modifiers & 0xFFF;
    }

    public int getDeclaredModifiers() {
        return 0;
    }

    public boolean isTopLevel() {
        return this.binding.enclosingType() == null;
    }

    public boolean isNested() {
        return this.binding.isNestedType();
    }

    public boolean isMember() {
        return this.binding.isMemberType();
    }

    public boolean isLocal() {
        return this.binding.isLocalType();
    }

    public boolean isAnonymous() {
        return this.binding.isAnonymousType();
    }

    public IReferenceTypeBinding[] getDeclaredTypes() {
        ReferenceBinding[] intTypes = this.binding.memberTypes();
        if (intTypes == null) {
            return new IReferenceTypeBinding[0];
        }
        IReferenceTypeBinding[] extTypes = new IReferenceTypeBinding[intTypes.length];
        int i = 0;
        while (i < extTypes.length) {
            extTypes[i] = BindingFactory.getReferenceTypeBinding(intTypes[i]);
            ++i;
        }
        return extTypes;
    }

    public IVariableBinding[] getDeclaredFields() {
        FieldBinding[] intFields = this.binding.fields();
        if (intFields == null) {
            return new IVariableBinding[0];
        }
        IVariableBinding[] extFields = new VariableBinding[intFields.length];
        int i = 0;
        while (i < extFields.length) {
            extFields[i] = new VariableBinding((org.eclipse.jdt.internal.compiler.lookup.VariableBinding)intFields[i]);
            ++i;
        }
        return extFields;
    }

    public IMethodBinding[] getDeclaredMethods() {
        org.eclipse.jdt.internal.compiler.lookup.MethodBinding[] intMethods = this.binding.methods();
        if (intMethods == null) {
            return new IMethodBinding[0];
        }
        IMethodBinding[] extMethods = new MethodBinding[intMethods.length];
        int i = 0;
        while (i < extMethods.length) {
            extMethods[i] = new MethodBinding(intMethods[i]);
            ++i;
        }
        return extMethods;
    }

    public IMethodBinding[] getAvailableMethods() {
        org.eclipse.jdt.internal.compiler.lookup.MethodBinding[] intMethods = this.binding.availableMethods();
        if (intMethods == null) {
            return new IMethodBinding[0];
        }
        IMethodBinding[] extMethods = new MethodBinding[intMethods.length];
        int i = 0;
        while (i < extMethods.length) {
            extMethods[i] = new MethodBinding(intMethods[i]);
            ++i;
        }
        return extMethods;
    }

    public boolean isFromSource() {
        return false;
    }

    public int getKind() {
        return 2;
    }

    public boolean isDeprecated() {
        return this.binding.isDeprecated();
    }

    public boolean equals(Object object) {
        return object instanceof ReferenceTypeBinding && ((ReferenceTypeBinding)object).binding.equals(this.binding);
    }

    public int hashCode() {
        return this.binding.hashCode();
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.isAnonymous()) {
            this.name = this.getIdentifier();
            return this.name;
        }
        String packageName = this.getPackage() == null || this.getPackage().getName() == null ? "" : this.getPackage().getName().concat(".");
        StringBuffer classNameBuf = new StringBuffer(this.getIdentifier());
        IReferenceTypeBinding currentBinding = this;
        while (currentBinding.getDeclaringClass() != null) {
            classNameBuf.insert(0, currentBinding.getDeclaringClass().getIdentifier().concat("."));
            currentBinding = currentBinding.getDeclaringClass();
        }
        this.name = packageName.concat(classNameBuf.toString());
        return this.name;
    }

    public boolean isReference() {
        return true;
    }
}

