/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.BindingFactory;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.PackageName;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.QualifiedName;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.ReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SimpleNameFromString;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.VariableBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IQualifier;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class QualifiedNameFromQualifiedNameReference
extends QualifiedName {
    private QualifiedNameReference qn;
    private int index;
    private IBinding binding;
    private IQualifier qual;

    public QualifiedNameFromQualifiedNameReference(QualifiedNameReference qn) {
        this.qn = qn;
        this.index = qn.tokens.length - 1;
    }

    public QualifiedNameFromQualifiedNameReference(QualifiedNameReference qn, int index, IBinding binding) {
        this(qn);
        this.index = index;
        this.binding = binding;
    }

    public int getStartPosition() {
        return this.qn.sourceStart;
    }

    public IQualifier getQualifier() {
        if (this.qual == null) {
            IBinding qualifierBinding = this.getQualifierBinding();
            if (qualifierBinding instanceof IPackageBinding) {
                this.qual = new PackageName(this.qn, this.index - 1);
            } else if (this.index == 1) {
                char[][] qualifier = this.qn.tokens;
                this.qual = new SimpleNameFromString(new String(qualifier[0]), this.getStartPosition(), (ITypeBinding)qualifierBinding);
            } else {
                this.qual = new QualifiedNameFromQualifiedNameReference(this.qn, this.index - 1, this.getQualifierBinding());
            }
        }
        return this.qual;
    }

    public String getName() {
        char[][] tokens = this.qn.tokens;
        return new String(tokens[this.index]);
    }

    public IBinding resolveBinding() {
        if (this.binding != null) {
            return this.binding;
        }
        Binding qualifiedNameBinding = this.qn.binding;
        if (this.qn.otherBindings != null && this.qn.otherBindings.length + this.index + 1 - this.qn.tokens.length > 0) {
            qualifiedNameBinding = this.qn.otherBindings[this.qn.otherBindings.length - 1 + this.index + 1 - this.qn.tokens.length];
        }
        switch (qualifiedNameBinding.bindingType()) {
            case 4: {
                return BindingFactory.getReferenceTypeBinding((ReferenceBinding)qualifiedNameBinding);
            }
            case 1: {
                return new VariableBinding((org.eclipse.jdt.internal.compiler.lookup.VariableBinding)((FieldBinding)qualifiedNameBinding));
            }
        }
        throw new IllegalArgumentException("wrong binding type: " + qualifiedNameBinding.bindingType());
    }

    public ITypeBinding resolveTypeBinding() {
        IBinding binding = this.resolveBinding();
        switch (binding.getKind()) {
            case 3: {
                return ((VariableBinding)binding).getType();
            }
            case 2: {
                return (ITypeBinding)binding;
            }
        }
        return null;
    }

    public String[] getNameComponents() {
        char[][] tokens = this.qn.tokens;
        String[] out = new String[this.index + 1];
        int i = 0;
        while (i <= this.index) {
            out[i] = new String(tokens[i]);
            ++i;
        }
        return out;
    }

    public boolean isPackageName() {
        return false;
    }

    private IBinding getQualifierBinding() {
        Binding qualifierBinding = this.qn.binding;
        if (this.qn.otherBindings != null && this.qn.otherBindings.length + this.index - this.qn.tokens.length > 0) {
            qualifierBinding = this.qn.otherBindings[this.qn.otherBindings.length - 1 + this.index - this.qn.tokens.length];
            switch (qualifierBinding.bindingType()) {
                case 4: {
                    return BindingFactory.getReferenceTypeBinding((ReferenceBinding)qualifierBinding);
                }
                case 1: {
                    return new VariableBinding((org.eclipse.jdt.internal.compiler.lookup.VariableBinding)((FieldBinding)qualifierBinding));
                }
            }
            throw new IllegalArgumentException("wrong binding type: " + qualifierBinding.bindingType());
        }
        if (this.index == this.qn.tokens.length - 1 && this.qn.otherBindings != null && this.qn.otherBindings.length == 1) {
            qualifierBinding = this.qn.binding;
            switch (qualifierBinding.bindingType()) {
                case 4: {
                    return BindingFactory.getTypeBinding((TypeBinding)((ReferenceBinding)qualifierBinding));
                }
                case 1: {
                    return new VariableBinding((org.eclipse.jdt.internal.compiler.lookup.VariableBinding)((FieldBinding)qualifierBinding));
                }
            }
            throw new IllegalArgumentException("wrong binding type: " + qualifierBinding.bindingType());
        }
        IBinding qualifiedBinding = this.resolveBinding();
        switch (qualifiedBinding.getKind()) {
            case 2: {
                IReferenceTypeBinding outerClass = ((ReferenceTypeBinding)qualifiedBinding).getDeclaringClass();
                if (outerClass != null) {
                    return outerClass;
                }
                return ((ReferenceTypeBinding)qualifiedBinding).getPackage();
            }
            case 3: {
                return ((VariableBinding)qualifiedBinding).getDeclaringClass();
            }
        }
        return null;
    }
}

