/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.ArrayTypeFromTypeReference;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.Block;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.MethodBinding;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.QualifiedNameFromTypeReference;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SimpleNameFromTypeReference;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SimpleTypeFromTypeReference;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SingleVariableDeclaration;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SourceContent;
import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IJavadoc;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IType;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class MethodDeclaration
implements IMethodDeclaration {
    private AbstractMethodDeclaration md;
    private BlockScope scope;
    private SourceContent source;
    private List parameters;
    private List exceptions;
    private IType returnType;
    private IBlock body;
    private IJavadoc javadoc;
    private IComment[] comments;
    private IComment endOfLineComment;
    private boolean commentParsed = false;

    public MethodDeclaration(AbstractMethodDeclaration md, BlockScope scope, SourceContent source) {
        this.md = md;
        this.scope = scope;
        this.source = source;
    }

    public int getNodeType() {
        return 31;
    }

    public int getStartPosition() {
        return this.md.declarationSourceStart;
    }

    public boolean isConstructor() {
        return this.md.isConstructor();
    }

    public int getModifiers() {
        return this.md.modifiers;
    }

    public String getName() {
        return new String(this.md.selector);
    }

    public List parameters() {
        if (this.parameters == null) {
            this.parameters = new Vector();
            Argument[] arguments = this.md.arguments;
            if (arguments != null) {
                int i = 0;
                while (i < arguments.length) {
                    this.parameters.add(new SingleVariableDeclaration((LocalDeclaration)arguments[i], (BlockScope)this.md.scope, this.source));
                    ++i;
                }
            }
        }
        return this.parameters;
    }

    public List thrownExceptions() {
        if (this.exceptions == null) {
            this.md.bindThrownExceptions();
            this.exceptions = new Vector();
            TypeReference[] exceptionArray = this.md.thrownExceptions;
            if (exceptionArray != null) {
                int i = 0;
                while (i < exceptionArray.length) {
                    char[][] tokens = exceptionArray[i].getTypeName();
                    if (tokens.length == 1) {
                        this.exceptions.add(new SimpleNameFromTypeReference(exceptionArray[i]));
                    } else {
                        this.exceptions.add(new QualifiedNameFromTypeReference(exceptionArray[i]));
                    }
                    ++i;
                }
            }
        }
        return this.exceptions;
    }

    public IType getReturnType() {
        if (this.md.isConstructor()) {
            return null;
        }
        if (this.returnType == null && this.md instanceof org.eclipse.jdt.internal.compiler.ast.MethodDeclaration) {
            TypeReference tr = ((org.eclipse.jdt.internal.compiler.ast.MethodDeclaration)this.md).returnType;
            if (tr instanceof ArrayTypeReference) {
                this.returnType = new ArrayTypeFromTypeReference((ArrayTypeReference)tr);
            } else if (tr instanceof SingleTypeReference) {
                this.returnType = new SimpleTypeFromTypeReference(tr);
            } else if (tr instanceof QualifiedTypeReference) {
                this.returnType = new SimpleTypeFromTypeReference(tr);
            }
        }
        return this.returnType;
    }

    public IBlock getBody() {
        if (this.md.isAbstract()) {
            return null;
        }
        if (this.body == null) {
            if (this.md.isConstructor()) {
                ExplicitConstructorCall ecc = ((ConstructorDeclaration)this.md).constructorCall;
                if (ecc != null && ecc.sourceStart > this.md.bodyStart) {
                    int oldLength = this.md.statements == null ? 0 : this.md.statements.length;
                    Statement[] statements = new Statement[oldLength + 1];
                    int i = 0;
                    while (i < oldLength) {
                        statements[i + 1] = this.md.statements[i];
                        ++i;
                    }
                    statements[0] = ecc;
                    this.body = new Block(statements, this.md.bodyStart, this.md.bodyEnd, (BlockScope)this.md.scope, this.source);
                } else {
                    this.body = new Block(this.md.statements, this.md.bodyStart, this.md.bodyEnd + 1, (BlockScope)this.md.scope, this.source);
                }
            } else {
                this.body = new Block(this.md.statements, this.md.bodyStart, this.md.bodyEnd + 1, (BlockScope)this.md.scope, this.source);
            }
        }
        return this.body;
    }

    public IMethodBinding resolveBinding() {
        return new MethodBinding(this.md.binding);
    }

    public IJavadoc getJavadoc() {
        if (this.javadoc == null) {
            this.javadoc = this.source.getJavadoc(this.md.declarationSourceStart);
        }
        return this.javadoc;
    }

    public IComment[] getComments() {
        if (this.comments == null) {
            this.comments = this.source.getBlockComment(this.md.sourceEnd + 1);
        }
        return this.comments;
    }

    public IComment getEndOfLineComment() {
        if (!this.commentParsed) {
            this.endOfLineComment = this.source.getEndOfLineComment(this.md.sourceStart);
            this.commentParsed = true;
        }
        return this.endOfLineComment;
    }

    public void traverse(IVisitor visitor) {
        if (visitor.visit(this)) {
            IBlock body;
            List thrownExceptions;
            List arguments;
            IType returnType = this.getReturnType();
            if (returnType != null) {
                returnType.traverse(visitor);
            }
            if ((arguments = this.parameters()) != null) {
                Iterator iterator = arguments.iterator();
                while (iterator.hasNext()) {
                    ((Traversable)iterator.next()).traverse(visitor);
                }
            }
            if ((thrownExceptions = this.thrownExceptions()) != null) {
                Iterator iterator = thrownExceptions.iterator();
                while (iterator.hasNext()) {
                    ((Traversable)iterator.next()).traverse(visitor);
                }
            }
            if ((body = this.getBody()) != null) {
                body.traverse(visitor);
            }
        }
        visitor.endVisit(this);
    }
}

