/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.BindingFactory;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SourceContent;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.Wrapper;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IInfixExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class InfixExpression
implements IInfixExpression {
    private BinaryExpression be;
    private BlockScope scope;
    private SourceContent source;
    private IExpression lExpr;
    private IExpression rExpr;

    public InfixExpression(BinaryExpression be, BlockScope scope, SourceContent source) {
        this.be = be;
        this.scope = scope;
        this.source = source;
    }

    public int getNodeType() {
        return 27;
    }

    public String getOperator() {
        return this.be.operatorToString();
    }

    public IExpression getLeftOperand() {
        if (this.lExpr == null) {
            this.lExpr = Wrapper.wrapExpression(this.be.left, this.scope, this.source);
        }
        return this.lExpr;
    }

    public IExpression getRightOperand() {
        if (this.rExpr == null) {
            this.rExpr = Wrapper.wrapExpression(this.be.right, this.scope, this.source);
        }
        return this.rExpr;
    }

    public ITypeBinding resolveTypeBinding() {
        return BindingFactory.getTypeBinding(this.be.resolvedType);
    }

    public int getStartPosition() {
        return this.be.sourceStart;
    }

    public void traverse(IVisitor visitor) {
        if (visitor.visit(this)) {
            this.getLeftOperand().traverse(visitor);
            this.getRightOperand().traverse(visitor);
        }
        visitor.endVisit(this);
    }
}

