/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.EmptyStatement;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SourceContent;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.VariableDeclarationStatement;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.Wrapper;
import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IForStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class ForStatement
implements IForStatement {
    private org.eclipse.jdt.internal.compiler.ast.ForStatement fs;
    private BlockScope scope;
    private SourceContent source;
    private IStatement[] initializers;
    private IExpression expression;
    private IExpression[] updaters;
    private IStatement body;
    private IComment[] comments;
    private IComment endOfLineComment;
    private boolean commentParsed = false;

    public ForStatement(org.eclipse.jdt.internal.compiler.ast.ForStatement fs, BlockScope scope, SourceContent source) {
        this.fs = fs;
        this.scope = scope;
        this.source = source;
    }

    public int getNodeType() {
        return 24;
    }

    public IStatement[] getInitializers() {
        block6: {
            if (this.initializers != null) break block6;
            Statement[] statements = this.fs.initializations;
            if (statements == null || statements.length == 0) {
                this.initializers = new IStatement[0];
            } else {
                this.initializers = new IStatement[statements.length];
                if (statements[0] instanceof LocalDeclaration) {
                    int i = 0;
                    while (i < statements.length) {
                        this.initializers[i] = new VariableDeclarationStatement((AbstractVariableDeclaration)((LocalDeclaration)statements[i]), this.scope, this.source);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < statements.length) {
                        this.initializers[i] = Wrapper.wrapStatement(statements[i], this.scope, this.source);
                        ++i;
                    }
                }
            }
        }
        return this.initializers;
    }

    public IExpression getExpression() {
        if (this.expression == null && this.fs.condition != null) {
            this.expression = Wrapper.wrapExpression(this.fs.condition, this.scope, this.source);
        }
        return this.expression;
    }

    public IExpression[] getUpdaters() {
        if (this.updaters == null) {
            Statement[] statements = this.fs.increments;
            if (statements == null) {
                this.updaters = new IExpression[0];
            } else {
                this.updaters = new IExpression[statements.length];
                int i = 0;
                while (i < statements.length) {
                    if (!(statements[i] instanceof Expression)) {
                        throw new IllegalArgumentException("wrong updater class: " + statements[i].getClass().getName());
                    }
                    this.updaters[i] = Wrapper.wrapExpression((Expression)statements[i], this.scope, this.source);
                    ++i;
                }
            }
        }
        return this.updaters;
    }

    public IStatement getBody() {
        if (this.body == null) {
            this.body = this.fs.action == null ? new EmptyStatement(this.fs.sourceEnd, this.source) : Wrapper.wrapStatement(this.fs.action, this.scope, this.source);
        }
        return this.body;
    }

    public int getStartPosition() {
        return this.fs.sourceStart;
    }

    public IComment[] getComments() {
        if (this.comments == null) {
            this.comments = this.source.getBlockComment(this.fs.sourceEnd);
        }
        return this.comments;
    }

    public IComment getEndOfLineComment() {
        if (!this.commentParsed) {
            this.endOfLineComment = this.source.getEndOfLineComment(this.fs.sourceEnd);
            this.commentParsed = true;
        }
        return this.endOfLineComment;
    }

    public void traverse(IVisitor visitor) {
        if (visitor.visit(this)) {
            IStatement[] initializers = this.getInitializers();
            int i = 0;
            while (i < initializers.length) {
                initializers[i].traverse(visitor);
                ++i;
            }
            IExpression condition = this.getExpression();
            if (condition != null) {
                condition.traverse(visitor);
            }
            IExpression[] updaters = this.getUpdaters();
            int i2 = 0;
            while (i2 < updaters.length) {
                updaters[i2].traverse(visitor);
                ++i2;
            }
            this.getBody().traverse(visitor);
        }
        visitor.endVisit(this);
    }
}

