/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.ArrayTypeFromTypeReference;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SimpleTypeFromTypeReference;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SourceContent;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.VariableBinding;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.Wrapper;
import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IJavadoc;
import com.sap.tc.jtools.jlint.jom.interfaces.IType;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class FieldDeclaration
implements IFieldDeclaration {
    private org.eclipse.jdt.internal.compiler.ast.FieldDeclaration fd;
    private BlockScope scope;
    private SourceContent source;
    private IType type;
    private IExpression initializer;
    private IJavadoc javadoc;
    private IComment[] comments;
    private IComment endOfLineComment;
    private boolean commentParsed;

    public FieldDeclaration(org.eclipse.jdt.internal.compiler.ast.FieldDeclaration fd, BlockScope scope, SourceContent source) {
        this.fd = fd;
        this.scope = scope;
        this.source = source;
    }

    public int getNodeType() {
        return 23;
    }

    public int getStartPosition() {
        return this.fd.declarationSourceStart;
    }

    public int getModifiers() {
        return this.fd.modifiers;
    }

    public IType getType() {
        if (this.type == null) {
            TypeReference tr = this.fd.type;
            if (tr instanceof ArrayTypeReference) {
                this.type = new ArrayTypeFromTypeReference((ArrayTypeReference)tr);
            } else if (tr instanceof ArrayQualifiedTypeReference) {
                this.type = new ArrayTypeFromTypeReference((ArrayQualifiedTypeReference)tr);
            } else if (tr instanceof SingleTypeReference) {
                this.type = new SimpleTypeFromTypeReference((TypeReference)((SingleTypeReference)tr));
            } else if (tr instanceof QualifiedTypeReference) {
                this.type = new SimpleTypeFromTypeReference(tr);
            } else {
                throw new IllegalArgumentException("illegal type: " + tr.getClass().getName());
            }
        }
        return this.type;
    }

    public String getName() {
        return new String(this.fd.name);
    }

    public IExpression getInitializer() {
        if (this.initializer == null && this.fd.initialization != null) {
            this.initializer = Wrapper.wrapExpression(this.fd.initialization, this.scope, this.source);
        }
        return this.initializer;
    }

    public IVariableBinding resolveBinding() {
        return new VariableBinding((org.eclipse.jdt.internal.compiler.lookup.VariableBinding)this.fd.binding);
    }

    public IJavadoc getJavadoc() {
        if (this.javadoc == null) {
            this.javadoc = this.source.getJavadoc(this.fd.declarationSourceStart);
        }
        return this.javadoc;
    }

    public IComment[] getComments() {
        if (this.comments == null) {
            this.comments = this.source.getBlockComment(this.fd.declarationEnd);
        }
        return this.comments;
    }

    public IComment getEndOfLineComment() {
        if (!this.commentParsed) {
            this.endOfLineComment = this.source.getEndOfLineComment(this.fd.declarationEnd);
            this.commentParsed = true;
        }
        return this.endOfLineComment;
    }

    public void traverse(IVisitor visitor) {
        if (visitor.visit(this)) {
            this.getType().traverse(visitor);
            IExpression initializer = this.getInitializer();
            if (initializer != null) {
                initializer.traverse(visitor);
            }
        }
        visitor.endVisit(this);
    }
}

