/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SourceContent;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.Wrapper;
import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpressionStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class ExpressionStatement
implements IExpressionStatement {
    private Expression expr;
    private BlockScope scope;
    private SourceContent source;
    private IExpression expression;
    private IComment[] comments;
    private IComment endOfLineComment;
    private boolean commentParsed = false;

    public ExpressionStatement(Expression expr, BlockScope scope, SourceContent source) {
        this.expr = expr;
        this.scope = scope;
        this.source = source;
    }

    public int getNodeType() {
        return 21;
    }

    public IExpression getExpression() {
        if (this.expression == null) {
            this.expression = Wrapper.wrapExpression(this.expr, this.scope, this.source);
        }
        return this.expression;
    }

    public int getStartPosition() {
        return this.expr.sourceStart;
    }

    public void traverse(IVisitor visitor) {
        if (visitor.visit(this)) {
            this.getExpression().traverse(visitor);
        }
        visitor.endVisit(this);
    }

    public IComment[] getComments() {
        if (this.comments == null) {
            this.comments = this.source.getBlockComment(this.expr.sourceEnd + 1);
        }
        return this.comments;
    }

    public IComment getEndOfLineComment() {
        if (!this.commentParsed) {
            this.endOfLineComment = this.source.getEndOfLineComment(this.expr.sourceEnd + 1);
            this.commentParsed = true;
        }
        return this.endOfLineComment;
    }
}

