/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SourceContent;
import com.sap.tc.jtools.jlint.jom.interfaces.IComment;
import com.sap.tc.jtools.jlint.jom.interfaces.IContinueStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;
import org.eclipse.jdt.internal.compiler.ast.Continue;

public class ContinueStatement
implements IContinueStatement {
    private Continue cs;
    private SourceContent source;
    private IComment[] comments;
    private IComment endOfLineComment;
    private boolean commentParsed = false;

    public ContinueStatement(Continue cs, SourceContent source) {
        this.cs = cs;
        this.source = source;
    }

    public int getNodeType() {
        return 18;
    }

    public String getLabel() {
        if (this.cs.label == null) {
            return null;
        }
        return new String(this.cs.label);
    }

    public int getStartPosition() {
        return this.cs.sourceStart;
    }

    public void traverse(IVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public IComment[] getComments() {
        if (this.comments == null) {
            this.comments = this.source.getBlockComment(this.cs.sourceEnd + 1);
        }
        return this.comments;
    }

    public IComment getEndOfLineComment() {
        if (!this.commentParsed) {
            this.endOfLineComment = this.source.getEndOfLineComment(this.cs.sourceEnd + 1);
            this.commentParsed = true;
        }
        return this.endOfLineComment;
    }
}

