/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.BindingFactory;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SourceContent;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.Wrapper;
import com.sap.tc.jtools.jlint.jom.interfaces.IConditionalExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class ConditionalExpression
implements IConditionalExpression {
    private org.eclipse.jdt.internal.compiler.ast.ConditionalExpression ce;
    private BlockScope scope;
    private SourceContent source;
    private IExpression expression;
    private IExpression thenExpression;
    private IExpression elseExpression;

    public ConditionalExpression(org.eclipse.jdt.internal.compiler.ast.ConditionalExpression ce, BlockScope scope, SourceContent source) {
        this.ce = ce;
        this.scope = scope;
        this.source = source;
    }

    public int getNodeType() {
        return 16;
    }

    public IExpression getExpression() {
        if (this.expression == null) {
            this.expression = Wrapper.wrapExpression(this.ce.condition, this.scope, this.source);
        }
        return this.expression;
    }

    public IExpression getThenExpression() {
        if (this.thenExpression == null) {
            this.thenExpression = Wrapper.wrapExpression(this.ce.valueIfTrue, this.scope, this.source);
        }
        return this.thenExpression;
    }

    public IExpression getElseExpression() {
        if (this.elseExpression == null) {
            this.elseExpression = Wrapper.wrapExpression(this.ce.valueIfFalse, this.scope, this.source);
        }
        return this.elseExpression;
    }

    public ITypeBinding resolveTypeBinding() {
        return BindingFactory.getTypeBinding(this.ce.resolvedType);
    }

    public int getStartPosition() {
        return this.ce.sourceStart;
    }

    public void traverse(IVisitor visitor) {
        if (visitor.visit(this)) {
            this.getExpression().traverse(visitor);
            this.getThenExpression().traverse(visitor);
            this.getElseExpression().traverse(visitor);
        }
        visitor.endVisit(this);
    }
}

