/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.BindingFactory;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.ImportDeclarationWithImportBinding;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.ImportDeclarationWithPackageBinding;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.ImportDeclarationWithTypeBinding;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.PackageDeclaration;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SourceContent;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.TypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

public class CompilationUnit
implements ICompilationUnit {
    public CompilationUnitDeclaration cud;
    private SourceContent source;
    private CompilationUnitScope scope;
    private IPackageDeclaration pack;
    private List imports;
    private List types;

    public CompilationUnit(CompilationUnitDeclaration cud, char[] source) {
        this.cud = cud;
        this.source = new SourceContent(source, cud.compilationResult.lineSeparatorPositions);
        this.scope = cud.scope;
    }

    public int getNodeType() {
        return 15;
    }

    public int getStartPosition() {
        return this.cud.sourceStart;
    }

    public String getFileName() {
        char[] token = this.cud.getFileName();
        if (token == null) {
            return null;
        }
        return new String(token).replace('\\', '/');
    }

    public IPackageDeclaration getPackage() {
        if (this.pack == null) {
            ImportReference ir = this.cud.currentPackage;
            if (ir == null || ir.tokens.length == 0) {
                return null;
            }
            this.pack = new PackageDeclaration(ir);
        }
        return this.pack;
    }

    public List imports() {
        if (this.imports == null) {
            this.imports = new Vector();
            ImportBinding[] importBindings = this.cud.scope.imports;
            ImportReference[] importArray = this.cud.imports;
            if (importArray != null) {
                int i = 0;
                while (i < importArray.length) {
                    int bindingIndex = -1;
                    int j = 0;
                    while (j < importBindings.length && bindingIndex == -1) {
                        if (this.charDoubleArraysAreEqual(importArray[i].tokens, importBindings[j].compoundName)) {
                            bindingIndex = j;
                        }
                        ++j;
                    }
                    if (bindingIndex == -1) {
                        this.imports.add(new ImportDeclarationWithPackageBinding(importArray[i], this.getPackage().resolveBinding()));
                    } else if (importArray[i].onDemand) {
                        this.imports.add(new ImportDeclarationWithImportBinding(importArray[i], importBindings[bindingIndex]));
                    } else {
                        this.imports.add(new ImportDeclarationWithTypeBinding(importArray[i], (ReferenceBinding)this.cud.scope.getType(importArray[i].tokens)));
                    }
                    ++i;
                }
            }
        }
        return this.imports;
    }

    public List types() {
        if (this.types == null) {
            org.eclipse.jdt.internal.compiler.ast.TypeDeclaration[] temp = this.cud.types;
            this.types = new Vector();
            if (temp != null) {
                int i = 0;
                while (i < temp.length) {
                    TypeDeclaration td = new TypeDeclaration(temp[i], this.source);
                    this.types.add(td);
                    ++i;
                }
            }
        }
        return this.types;
    }

    public int lineNumber(int position) {
        return this.source.lineNumber(position);
    }

    public int columnNumber(int position) {
        return this.source.columnNumber(position);
    }

    public void traverse(IVisitor visitor) {
        if (visitor.visit(this)) {
            List types;
            List imports;
            IPackageDeclaration pack = this.getPackage();
            if (pack != null) {
                pack.traverse(visitor);
            }
            if ((imports = this.imports()) != null) {
                Iterator iterator = imports.iterator();
                while (iterator.hasNext()) {
                    ((Traversable)iterator.next()).traverse(visitor);
                }
            }
            if ((types = this.types()) != null) {
                Iterator iterator = types.iterator();
                while (iterator.hasNext()) {
                    ((Traversable)iterator.next()).traverse(visitor);
                }
            }
        }
        visitor.endVisit(this);
    }

    public ITypeBinding getBindingForName(String fullName) {
        char[] charName = fullName.toCharArray();
        return BindingFactory.getTypeBinding(this.scope.getType(charName));
    }

    private boolean charDoubleArraysAreEqual(char[][] c, char[][] c1) {
        if (c.length != c1.length) {
            return false;
        }
        int i = 0;
        while (i < c.length) {
            if (c[i].length != c1[i].length) {
                return false;
            }
            int j = 0;
            while (j < c1[i].length) {
                if (c[i][j] != c1[i][j]) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public int lineCount() {
        return this.source.getLineCount();
    }
}

