/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.BindingFactory;
import com.sap.tc.jtools.jlint.jom.interfaces.ICharacterLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;

public class CharacterLiteral
implements ICharacterLiteral {
    private CharLiteral literal;

    public CharacterLiteral(CharLiteral literal) {
        this.literal = literal;
    }

    public int getNodeType() {
        return 13;
    }

    public char charValue() {
        return this.literal.constant.charValue();
    }

    public ITypeBinding resolveTypeBinding() {
        return BindingFactory.getPrimitiveTypeBinding(BaseTypes.CharBinding);
    }

    public int getStartPosition() {
        return this.literal.sourceStart;
    }

    public void traverse(IVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public String getEscapedValue() {
        switch (this.charValue()) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\"': {
                return "\\\"";
            }
            case '\'': {
                return "\\'";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return String.valueOf(this.charValue());
    }
}

