/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.BindingFactory;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ArrayTypeBinding
implements IArrayTypeBinding {
    private static final String ARRAY_INDICATOR = "[]";
    TypeBinding binding;
    int extraDims;

    public ArrayTypeBinding(ArrayBinding binding) {
        this.binding = binding;
    }

    public ArrayTypeBinding(TypeBinding binding, int extraDims) {
        this.binding = binding;
        this.extraDims = extraDims;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isNullType() {
        return false;
    }

    public boolean isArray() {
        return true;
    }

    public ITypeBinding getElementType() {
        TypeBinding element = this.binding instanceof ArrayBinding ? ((ArrayBinding)this.binding).leafComponentType() : this.binding;
        return BindingFactory.getTypeBinding(element);
    }

    public int getDimensions() {
        return this.extraDims + (this.binding.isArrayType() ? ((ArrayBinding)this.binding).dimensions : 0);
    }

    public String getName() {
        String name = this.getElementType().getName();
        int i = 0;
        while (i < this.getDimensions()) {
            name = name + ARRAY_INDICATOR;
            ++i;
        }
        return name;
    }

    public int getKind() {
        return 2;
    }

    public boolean equals(Object object) {
        return object instanceof ArrayTypeBinding && ((ArrayTypeBinding)object).binding.equals(this.binding) && ((ArrayTypeBinding)object).extraDims == this.extraDims;
    }

    public int hashCode() {
        return this.binding.hashCode() + this.extraDims * 37;
    }

    public boolean isReference() {
        return false;
    }
}

