/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.ciwrappers2_1;

import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.ArrayInitializer;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.ArrayTypeFromTypeReference;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.SourceContent;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.Wrapper;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayInitializer;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayType;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.Traversable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class ArrayCreation
implements IArrayCreation {
    private ArrayAllocationExpression expr;
    private BlockScope scope;
    private SourceContent source;
    private IArrayType type;
    private List dimensions;
    private IArrayInitializer initializer;

    public ArrayCreation(ArrayAllocationExpression expr, BlockScope scope, SourceContent source) {
        this.expr = expr;
        this.scope = scope;
        this.source = source;
    }

    public int getNodeType() {
        return 3;
    }

    public IArrayType getType() {
        if (this.type == null) {
            this.type = new ArrayTypeFromTypeReference(this.expr.type, this.expr.dimensions.length);
        }
        return this.type;
    }

    public List dimensions() {
        if (this.dimensions == null) {
            this.dimensions = new Vector();
            Expression[] expressions = this.expr.dimensions;
            if (expressions != null) {
                int i = 0;
                while (i < expressions.length) {
                    this.dimensions.add(Wrapper.wrapExpression(expressions[i], this.scope, this.source));
                    ++i;
                }
            }
        }
        return this.dimensions;
    }

    public IArrayInitializer getInitializer() {
        if (this.initializer == null && this.expr.initializer != null) {
            this.initializer = new ArrayInitializer(this.expr.initializer, this.scope, this.source);
        }
        return this.initializer;
    }

    public ITypeBinding resolveTypeBinding() {
        return this.getType().resolveBinding();
    }

    public int getStartPosition() {
        return this.expr.sourceStart;
    }

    public void traverse(IVisitor visitor) {
        if (visitor.visit(this)) {
            IArrayInitializer initializer;
            this.getType().traverse(visitor);
            List dimensions = this.dimensions();
            if (dimensions != null) {
                Iterator iterator = dimensions.iterator();
                while (iterator.hasNext()) {
                    Traversable current = (Traversable)iterator.next();
                    if (current == null) continue;
                    current.traverse(visitor);
                }
            }
            if ((initializer = this.getInitializer()) != null) {
                initializer.traverse(visitor);
            }
        }
        visitor.endVisit(this);
    }
}

